/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.url.component;

import java.util.Map;
import org.apache.dubbo.common.utils.LRUCache;

public class URLItemCache {
    private static final Map<String, String> PARAM_KEY_CACHE = new LRUCache<String, String>(10000);
    private static final Map<String, String> PARAM_VALUE_CACHE = new LRUCache<String, String>(50000);
    private static final Map<String, String> PATH_CACHE = new LRUCache<String, String>(10000);
    private static final Map<String, String> REVISION_CACHE = new LRUCache<String, String>(10000);

    public static void putParams(Map<String, String> params, String key, String value) {
        String cachedValue;
        String cachedKey = PARAM_KEY_CACHE.get(key);
        if (cachedKey == null) {
            cachedKey = key;
            PARAM_KEY_CACHE.put(key, key);
        }
        if ((cachedValue = PARAM_VALUE_CACHE.get(value)) == null) {
            cachedValue = value;
            PARAM_VALUE_CACHE.put(value, value);
        }
        params.put(cachedKey, cachedValue);
    }

    public static String checkPath(String _path) {
        if (_path == null) {
            return _path;
        }
        String cachedPath = PATH_CACHE.putIfAbsent(_path, _path);
        if (cachedPath != null) {
            return cachedPath;
        }
        return _path;
    }

    public static String checkRevision(String _revision) {
        if (_revision == null) {
            return _revision;
        }
        String revision = REVISION_CACHE.putIfAbsent(_revision, _revision);
        if (revision != null) {
            return revision;
        }
        return _revision;
    }

    public static String intern(String _protocol) {
        if (_protocol == null) {
            return _protocol;
        }
        return _protocol.intern();
    }

    public static void putParamsIntern(Map<String, String> params, String key, String value) {
        if (key == null || value == null) {
            params.put(key, value);
            return;
        }
        key = key.intern();
        value = value.intern();
        params.put(key, value);
    }
}

