/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.context;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.dubbo.common.config.CompositeConfiguration;
import org.apache.dubbo.common.context.FrameworkExt;
import org.apache.dubbo.common.context.LifecycleAdapter;
import org.apache.dubbo.common.extension.DisableInject;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.AbstractInterfaceConfig;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ConfigCenterConfig;
import org.apache.dubbo.config.ConsumerConfig;
import org.apache.dubbo.config.MetadataReportConfig;
import org.apache.dubbo.config.MethodConfig;
import org.apache.dubbo.config.MetricsConfig;
import org.apache.dubbo.config.ModuleConfig;
import org.apache.dubbo.config.MonitorConfig;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.ProviderConfig;
import org.apache.dubbo.config.ReferenceConfigBase;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.ServiceConfigBase;
import org.apache.dubbo.config.SslConfig;
import org.apache.dubbo.config.context.ConfigMode;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class ConfigManager
extends LifecycleAdapter
implements FrameworkExt {
    private static final Logger logger = LoggerFactory.getLogger(ConfigManager.class);
    public static final String NAME = "config";
    public static final String BEAN_NAME = "dubboConfigManager";
    private static final String CONFIG_NAME_READ_METHOD = "getName";
    public static final String DUBBO_CONFIG_MODE = "dubbo.config.mode";
    final Map<String, Map<String, AbstractConfig>> configsCache = new ConcurrentHashMap<String, Map<String, AbstractConfig>>();
    private Map<String, AbstractInterfaceConfig> referenceConfigCache = new ConcurrentHashMap<String, AbstractInterfaceConfig>();
    private Map<String, AbstractInterfaceConfig> serviceConfigCache = new ConcurrentHashMap<String, AbstractInterfaceConfig>();
    private Set<AbstractConfig> duplicatedConfigs = new ConcurrentHashSet<AbstractConfig>();
    private ConfigMode configMode = ConfigMode.STRICT;
    private boolean ignoreDuplicatedInterface = false;
    private static Map<String, AtomicInteger> configIdIndexes = new ConcurrentHashMap<String, AtomicInteger>();
    private static Set<Class<? extends AbstractConfig>> uniqueConfigTypes = new ConcurrentHashSet<Class<? extends AbstractConfig>>();

    @Override
    public void initialize() throws IllegalStateException {
        CompositeConfiguration configuration = ApplicationModel.getEnvironment().getConfiguration();
        String configModeStr = (String)configuration.getProperty(DUBBO_CONFIG_MODE);
        try {
            if (StringUtils.hasText(configModeStr)) {
                this.configMode = ConfigMode.valueOf(configModeStr.toUpperCase());
            }
        }
        catch (Exception e) {
            String msg = "Illegal 'dubbo.config.mode' config value [" + configModeStr + "], available values " + Arrays.toString((Object[])ConfigMode.values());
            logger.error(msg, e);
            throw new IllegalArgumentException(msg, e);
        }
        String ignoreDuplicatedInterfaceStr = (String)configuration.getProperty("dubbo.config.ignore-duplicated-interface");
        if (ignoreDuplicatedInterfaceStr != null) {
            this.ignoreDuplicatedInterface = Boolean.parseBoolean(ignoreDuplicatedInterfaceStr);
        }
        logger.info("Dubbo config mode: " + (Object)((Object)this.configMode) + ", ignore duplicated interface: " + this.ignoreDuplicatedInterface);
    }

    @DisableInject
    public void setApplication(ApplicationConfig application) {
        this.addConfig(application, true);
    }

    public Optional<ApplicationConfig> getApplication() {
        return Optional.ofNullable((ApplicationConfig)this.getSingleConfig(AbstractConfig.getTagName(ApplicationConfig.class)));
    }

    public ApplicationConfig getApplicationOrElseThrow() {
        return this.getApplication().orElseThrow(() -> new IllegalStateException("There's no ApplicationConfig specified."));
    }

    @DisableInject
    public void setMonitor(MonitorConfig monitor) {
        this.addConfig(monitor, true);
    }

    public Optional<MonitorConfig> getMonitor() {
        return Optional.ofNullable((MonitorConfig)this.getSingleConfig(AbstractConfig.getTagName(MonitorConfig.class)));
    }

    @DisableInject
    public void setModule(ModuleConfig module) {
        this.addConfig(module, true);
    }

    public Optional<ModuleConfig> getModule() {
        return Optional.ofNullable((ModuleConfig)this.getSingleConfig(AbstractConfig.getTagName(ModuleConfig.class)));
    }

    @DisableInject
    public void setMetrics(MetricsConfig metrics) {
        this.addConfig(metrics, true);
    }

    public Optional<MetricsConfig> getMetrics() {
        return Optional.ofNullable((MetricsConfig)this.getSingleConfig(AbstractConfig.getTagName(MetricsConfig.class)));
    }

    @DisableInject
    public void setSsl(SslConfig sslConfig) {
        this.addConfig(sslConfig, true);
    }

    public Optional<SslConfig> getSsl() {
        return Optional.ofNullable((SslConfig)this.getSingleConfig(AbstractConfig.getTagName(SslConfig.class)));
    }

    public void addConfigCenter(ConfigCenterConfig configCenter) {
        this.addConfig(configCenter);
    }

    public void addConfigCenters(Iterable<ConfigCenterConfig> configCenters) {
        configCenters.forEach(this::addConfigCenter);
    }

    public Optional<Collection<ConfigCenterConfig>> getDefaultConfigCenter() {
        Collection<Object> defaults = ConfigManager.getDefaultConfigs(this.getConfigsMap(AbstractConfig.getTagName(ConfigCenterConfig.class)));
        if (CollectionUtils.isEmpty(defaults)) {
            defaults = this.getConfigCenters();
        }
        return Optional.ofNullable(defaults);
    }

    public Optional<ConfigCenterConfig> getConfigCenter(String id) {
        return this.getConfig(ConfigCenterConfig.class, id);
    }

    public Collection<ConfigCenterConfig> getConfigCenters() {
        return this.getConfigs(AbstractConfig.getTagName(ConfigCenterConfig.class));
    }

    public void addMetadataReport(MetadataReportConfig metadataReportConfig) {
        this.addConfig(metadataReportConfig);
    }

    public void addMetadataReports(Iterable<MetadataReportConfig> metadataReportConfigs) {
        metadataReportConfigs.forEach(this::addMetadataReport);
    }

    public Collection<MetadataReportConfig> getMetadataConfigs() {
        return this.getConfigs(AbstractConfig.getTagName(MetadataReportConfig.class));
    }

    public Collection<MetadataReportConfig> getDefaultMetadataConfigs() {
        List<MetadataReportConfig> defaults = ConfigManager.getDefaultConfigs(this.getConfigsMap(AbstractConfig.getTagName(MetadataReportConfig.class)));
        if (CollectionUtils.isEmpty(defaults)) {
            return this.getMetadataConfigs();
        }
        return defaults;
    }

    public void addProvider(ProviderConfig providerConfig) {
        this.addConfig(providerConfig);
    }

    public void addProviders(Iterable<ProviderConfig> providerConfigs) {
        providerConfigs.forEach(this::addProvider);
    }

    public Optional<ProviderConfig> getProvider(String id) {
        return this.getConfig(ProviderConfig.class, id);
    }

    public Optional<ProviderConfig> getDefaultProvider() {
        List providerConfigs = ConfigManager.getDefaultConfigs(this.getConfigsMap(AbstractConfig.getTagName(ProviderConfig.class)));
        if (CollectionUtils.isNotEmpty(providerConfigs)) {
            return Optional.of((ProviderConfig)providerConfigs.get(0));
        }
        return Optional.empty();
    }

    public Collection<ProviderConfig> getProviders() {
        return this.getConfigs(AbstractConfig.getTagName(ProviderConfig.class));
    }

    public void addConsumer(ConsumerConfig consumerConfig) {
        this.addConfig(consumerConfig);
    }

    public void addConsumers(Iterable<ConsumerConfig> consumerConfigs) {
        consumerConfigs.forEach(this::addConsumer);
    }

    public Optional<ConsumerConfig> getConsumer(String id) {
        return this.getConfig(ConsumerConfig.class, id);
    }

    public Optional<ConsumerConfig> getDefaultConsumer() {
        List consumerConfigs = ConfigManager.getDefaultConfigs(this.getConfigsMap(AbstractConfig.getTagName(ConsumerConfig.class)));
        if (CollectionUtils.isNotEmpty(consumerConfigs)) {
            return Optional.of((ConsumerConfig)consumerConfigs.get(0));
        }
        return Optional.empty();
    }

    public Collection<ConsumerConfig> getConsumers() {
        return this.getConfigs(AbstractConfig.getTagName(ConsumerConfig.class));
    }

    public void addProtocol(ProtocolConfig protocolConfig) {
        this.addConfig(protocolConfig);
    }

    public void addProtocols(Iterable<ProtocolConfig> protocolConfigs) {
        if (protocolConfigs != null) {
            protocolConfigs.forEach(this::addProtocol);
        }
    }

    public Optional<ProtocolConfig> getProtocol(String idOrName) {
        return this.getConfig(ProtocolConfig.class, idOrName);
    }

    public List<ProtocolConfig> getDefaultProtocols() {
        return this.getDefaultConfigs(ProtocolConfig.class);
    }

    public <C extends AbstractConfig> List<C> getDefaultConfigs(Class<C> cls) {
        return ConfigManager.getDefaultConfigs(this.getConfigsMap(AbstractConfig.getTagName(cls)));
    }

    public Collection<ProtocolConfig> getProtocols() {
        return this.getConfigs(AbstractConfig.getTagName(ProtocolConfig.class));
    }

    public void addRegistry(RegistryConfig registryConfig) {
        this.addConfig(registryConfig);
    }

    public void addRegistries(Iterable<RegistryConfig> registryConfigs) {
        if (registryConfigs != null) {
            registryConfigs.forEach(this::addRegistry);
        }
    }

    public Optional<RegistryConfig> getRegistry(String id) {
        return this.getConfig(RegistryConfig.class, id);
    }

    public <T extends AbstractConfig> Optional<T> getConfig(Class<T> cls, String idOrName) {
        Object config = this.getConfigById(AbstractConfig.getTagName(cls), idOrName);
        if (config == null) {
            config = this.getConfigByName(cls, idOrName);
        }
        return Optional.ofNullable(config);
    }

    public List<RegistryConfig> getDefaultRegistries() {
        return ConfigManager.getDefaultConfigs(this.getConfigsMap(AbstractConfig.getTagName(RegistryConfig.class)));
    }

    public Collection<RegistryConfig> getRegistries() {
        return this.getConfigs(AbstractConfig.getTagName(RegistryConfig.class));
    }

    public void addService(ServiceConfigBase<?> serviceConfig) {
        this.addConfig(serviceConfig);
    }

    public void addServices(Iterable<ServiceConfigBase<?>> serviceConfigs) {
        serviceConfigs.forEach(this::addService);
    }

    public Collection<ServiceConfigBase> getServices() {
        return this.getConfigs(AbstractConfig.getTagName(ServiceConfigBase.class));
    }

    public <T> ServiceConfigBase<T> getService(String id) {
        return this.getConfig(ServiceConfigBase.class, id).orElse(null);
    }

    public void addReference(ReferenceConfigBase<?> referenceConfig) {
        this.addConfig(referenceConfig);
    }

    public void addReferences(Iterable<ReferenceConfigBase<?>> referenceConfigs) {
        referenceConfigs.forEach(this::addReference);
    }

    public Collection<ReferenceConfigBase<?>> getReferences() {
        return this.getConfigs(AbstractConfig.getTagName(ReferenceConfigBase.class));
    }

    public <T> ReferenceConfigBase<T> getReference(String id) {
        return this.getConfig(ReferenceConfigBase.class, id).orElse(null);
    }

    public void refreshAll() {
        this.getApplication().ifPresent(ApplicationConfig::refresh);
        this.getMonitor().ifPresent(AbstractConfig::refresh);
        this.getModule().ifPresent(AbstractConfig::refresh);
        this.getMetrics().ifPresent(AbstractConfig::refresh);
        this.getSsl().ifPresent(AbstractConfig::refresh);
        this.getProtocols().forEach(AbstractConfig::refresh);
        this.getRegistries().forEach(AbstractConfig::refresh);
        this.getProviders().forEach(AbstractConfig::refresh);
        this.getConsumers().forEach(AbstractConfig::refresh);
        this.getConfigCenters().forEach(AbstractConfig::refresh);
        this.getMetadataConfigs().forEach(AbstractConfig::refresh);
    }

    public void removeConfig(AbstractConfig config) {
        if (config == null) {
            return;
        }
        Map<String, AbstractConfig> configs = this.configsCache.get(AbstractConfig.getTagName(config.getClass()));
        if (CollectionUtils.isNotEmptyMap(configs)) {
            configs.values().removeIf(c -> config == c);
        }
    }

    public void clear() {
        this.configsCache.clear();
        configIdIndexes.clear();
        this.referenceConfigCache.clear();
        this.serviceConfigCache.clear();
        this.duplicatedConfigs.clear();
    }

    @Override
    public void destroy() throws IllegalStateException {
        this.clear();
    }

    public void addConfig(AbstractConfig config) {
        if (config == null) {
            return;
        }
        this.addConfig(config, this.isUniqueConfig(config));
    }

    private boolean isUniqueConfig(AbstractConfig config) {
        return uniqueConfigTypes.contains(config.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends AbstractConfig> T addConfig(AbstractConfig config, boolean unique) {
        if (config == null) {
            return null;
        }
        if (config instanceof MethodConfig) {
            return null;
        }
        Map configsMap = this.configsCache.computeIfAbsent(AbstractConfig.getTagName(config.getClass()), type -> ConfigManager.newMap());
        if (!(config instanceof ReferenceConfigBase) && !(config instanceof ServiceConfigBase)) {
            for (AbstractConfig value : configsMap.values()) {
                if (!value.equals(config)) continue;
                return (T)value;
            }
        }
        Map map = configsMap;
        synchronized (map) {
            return (T)this.addIfAbsent(config, configsMap, unique);
        }
    }

    public <C extends AbstractConfig> Map<String, C> getConfigsMap(Class<C> cls) {
        return this.getConfigsMap(AbstractConfig.getTagName(cls));
    }

    private <C extends AbstractConfig> Map<String, C> getConfigsMap(String configType) {
        return this.configsCache.getOrDefault(configType, Collections.emptyMap());
    }

    private <C extends AbstractConfig> Collection<C> getConfigs(String configType) {
        return this.getConfigsMap(configType).values();
    }

    public <C extends AbstractConfig> Collection<C> getConfigs(Class<C> configType) {
        return this.getConfigsMap(AbstractConfig.getTagName(configType)).values();
    }

    private <C extends AbstractConfig> C getConfigById(String configType, String id) {
        return (C)((AbstractConfig)this.getConfigsMap(configType).get(id));
    }

    private <C extends AbstractConfig> C getConfigByName(Class<? extends C> cls, String name) {
        Map<String, C> configsMap = this.getConfigsMap(cls);
        if (configsMap.isEmpty()) {
            return null;
        }
        if (ReflectUtils.hasMethod(cls, CONFIG_NAME_READ_METHOD)) {
            List list = configsMap.values().stream().filter(cfg -> name.equals(this.getConfigName(cfg))).collect(Collectors.toList());
            if (list.size() > 1) {
                throw new IllegalStateException("Found more than one config by name: " + name + ", instances: " + list + ". Please remove redundant configs or get config by id.");
            }
            if (list.size() == 1) {
                return (C)((AbstractConfig)list.get(0));
            }
        }
        return null;
    }

    private <C extends AbstractConfig> String getConfigName(C config) {
        try {
            return (String)ReflectUtils.getProperty(config, CONFIG_NAME_READ_METHOD);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected <C extends AbstractConfig> C getSingleConfig(String configType) throws IllegalStateException {
        Map<String, C> configsMap = this.getConfigsMap(configType);
        int size = configsMap.size();
        if (size < 1) {
            return null;
        }
        if (size > 1) {
            throw new IllegalStateException("Expected single instance of " + configType + ", but found " + size + " instances, please remove redundant configs. instances: " + configsMap.values());
        }
        return (C)((AbstractConfig)configsMap.values().iterator().next());
    }

    private static boolean isEquals(AbstractConfig oldOne, AbstractConfig newOne) {
        if (oldOne == newOne) {
            return true;
        }
        if (oldOne == null || newOne == null) {
            return false;
        }
        if (oldOne.getClass() != newOne.getClass()) {
            return false;
        }
        if (oldOne.isRefreshed() || newOne.isRefreshed()) {
            if (!oldOne.isRefreshed()) {
                oldOne.refresh();
            }
            if (!newOne.isRefreshed()) {
                newOne.refresh();
            }
        }
        return oldOne.equals(newOne);
    }

    private static Map newMap() {
        return new ConcurrentHashMap();
    }

    private <C extends AbstractConfig> C addIfAbsent(C config, Map<String, C> configsMap, boolean unique) throws IllegalStateException {
        AbstractConfig existedConfig;
        String key;
        if (config == null || configsMap == null) {
            return config;
        }
        if (config instanceof ReferenceConfigBase || config instanceof ServiceConfigBase) {
            AbstractInterfaceConfig existedConfig2 = this.checkDuplicatedInterfaceConfig((AbstractInterfaceConfig)config);
            if (existedConfig2 != null) {
                return (C)existedConfig2;
            }
        } else {
            Optional<C> prevConfig = this.findConfigByValue(configsMap.values(), config);
            if (prevConfig.isPresent()) {
                if (prevConfig.get() == config) {
                    return (C)((AbstractConfig)prevConfig.get());
                }
                if (logger.isInfoEnabled() && this.duplicatedConfigs.add(config)) {
                    logger.info("Ignore duplicated config: " + config);
                }
                return (C)((AbstractConfig)prevConfig.get());
            }
        }
        if (unique && configsMap.size() > 0) {
            AbstractConfig oldOne = (AbstractConfig)configsMap.values().iterator().next();
            String configName = oldOne.getClass().getSimpleName();
            String msgPrefix = "Duplicate Configs found for " + configName + ", only one unique " + configName + " is allowed for one application. previous: " + oldOne + ", later: " + config + ". According to config mode [" + (Object)((Object)this.configMode) + "], ";
            switch (this.configMode) {
                case STRICT: {
                    if (ConfigManager.isEquals(oldOne, config)) break;
                    throw new IllegalStateException(msgPrefix + "please remove redundant configs and keep only one.");
                }
                case IGNORE: {
                    if (logger.isWarnEnabled() && this.duplicatedConfigs.add(config)) {
                        logger.warn(msgPrefix + "keep previous config and ignore later config");
                    }
                    return (C)oldOne;
                }
                case OVERRIDE: {
                    configsMap.clear();
                    if (!logger.isWarnEnabled() || !this.duplicatedConfigs.add(config)) break;
                    logger.warn(msgPrefix + "override previous config with later config");
                }
            }
        }
        if ((key = ConfigManager.getId(config)) == null) {
            while (configsMap.containsKey(key = ConfigManager.generateConfigId(config))) {
            }
        }
        if ((existedConfig = (AbstractConfig)configsMap.get(key)) != null && !ConfigManager.isEquals(existedConfig, config)) {
            String type = config.getClass().getSimpleName();
            logger.warn(String.format("Duplicate %s found, there already has one default %s or more than two %ss have the same id, you can try to give each %s a different id, override previous config with later config. id: %s, prev: %s, later: %s", type, type, type, type, key, existedConfig, config));
        }
        configsMap.put(key, config);
        return config;
    }

    private <C extends AbstractConfig> Optional<C> findConfigByValue(Collection<C> values, C config) {
        Optional<AbstractConfig> prevConfig = values.stream().filter(val -> val == config).findFirst();
        if (prevConfig.isPresent()) {
            return prevConfig;
        }
        prevConfig = values.stream().filter(val -> ConfigManager.isEquals(val, config)).findFirst();
        return prevConfig;
    }

    private AbstractInterfaceConfig checkDuplicatedInterfaceConfig(AbstractInterfaceConfig config) {
        Map<String, AbstractInterfaceConfig> configCache;
        String uniqueServiceName;
        if (config instanceof ReferenceConfigBase) {
            ReferenceConfigBase referenceConfig = (ReferenceConfigBase)config;
            uniqueServiceName = referenceConfig.getUniqueServiceName();
            configCache = this.referenceConfigCache;
        } else if (config instanceof ServiceConfigBase) {
            ServiceConfigBase serviceConfig = (ServiceConfigBase)config;
            uniqueServiceName = serviceConfig.getUniqueServiceName();
            configCache = this.serviceConfigCache;
        } else {
            throw new IllegalArgumentException("Illegal type of parameter 'config' : " + config.getClass().getName());
        }
        AbstractInterfaceConfig prevConfig = configCache.putIfAbsent(uniqueServiceName, config);
        if (prevConfig != null) {
            if (prevConfig == config) {
                return prevConfig;
            }
            if (prevConfig.equals(config)) {
                if (logger.isWarnEnabled() && this.duplicatedConfigs.add(config)) {
                    logger.warn("Ignore duplicated and equal config: " + config);
                }
                return prevConfig;
            }
            String configType = config.getClass().getSimpleName();
            String msg = "Found multiple " + configType + "s with unique service name [" + uniqueServiceName + "], previous: " + prevConfig + ", later: " + config + ". There can only be one instance of " + configType + " with the same triple (group, interface, version). If multiple instances are required for the same interface, please use a different group or version.";
            if (logger.isWarnEnabled() && this.duplicatedConfigs.add(config)) {
                logger.warn(msg);
            }
            if (!this.ignoreDuplicatedInterface) {
                throw new IllegalStateException(msg);
            }
        }
        return prevConfig;
    }

    public static <C extends AbstractConfig> String generateConfigId(C config) {
        String tagName = AbstractConfig.getTagName(config.getClass());
        int idx = configIdIndexes.computeIfAbsent(tagName, clazz -> new AtomicInteger(0)).incrementAndGet();
        return tagName + "#" + idx;
    }

    static <C extends AbstractConfig> String getId(C config) {
        String id = config.getId();
        return StringUtils.isNotEmpty(id) ? id : null;
    }

    static <C extends AbstractConfig> Boolean isDefaultConfig(C config) {
        return config.isDefault();
    }

    static <C extends AbstractConfig> List<C> getDefaultConfigs(Map<String, C> configsMap) {
        List list = configsMap.values().stream().filter(c -> Boolean.TRUE.equals(ConfigManager.isDefaultConfig(c))).collect(Collectors.toList());
        if (list.size() > 0) {
            return list;
        }
        list = configsMap.values().stream().filter(c -> ConfigManager.isDefaultConfig(c) == null).collect(Collectors.toList());
        return list;
    }

    protected ConfigMode getConfigMode() {
        return this.configMode;
    }

    static {
        uniqueConfigTypes.add(ApplicationConfig.class);
        uniqueConfigTypes.add(ModuleConfig.class);
        uniqueConfigTypes.add(MonitorConfig.class);
        uniqueConfigTypes.add(MetricsConfig.class);
        uniqueConfigTypes.add(SslConfig.class);
        ArrayList<String> configNames = new ArrayList<String>(uniqueConfigTypes.size());
        for (Class<? extends AbstractConfig> configType : uniqueConfigTypes) {
            configNames.add(configType.getSimpleName());
        }
    }
}

