/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.logger;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.dubbo.common.logger.Level;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerAdapter;
import org.apache.dubbo.common.logger.jcl.JclLoggerAdapter;
import org.apache.dubbo.common.logger.jdk.JdkLoggerAdapter;
import org.apache.dubbo.common.logger.log4j.Log4jLoggerAdapter;
import org.apache.dubbo.common.logger.log4j2.Log4j2LoggerAdapter;
import org.apache.dubbo.common.logger.slf4j.Slf4jLoggerAdapter;
import org.apache.dubbo.common.logger.support.FailsafeLogger;
import org.apache.dubbo.rpc.model.FrameworkModel;

public class LoggerFactory {
    private static final ConcurrentMap<String, FailsafeLogger> LOGGERS;
    private static volatile LoggerAdapter LOGGER_ADAPTER;

    private LoggerFactory() {
    }

    public static void setLoggerAdapter(FrameworkModel frameworkModel, String loggerAdapter) {
        if (loggerAdapter != null && loggerAdapter.length() > 0) {
            LoggerFactory.setLoggerAdapter(frameworkModel.getExtensionLoader(LoggerAdapter.class).getExtension(loggerAdapter));
        }
    }

    public static void setLoggerAdapter(LoggerAdapter loggerAdapter) {
        if (loggerAdapter != null) {
            if (loggerAdapter == LOGGER_ADAPTER) {
                return;
            }
            loggerAdapter.getLogger(LoggerFactory.class.getName());
            LOGGER_ADAPTER = loggerAdapter;
            for (Map.Entry entry : LOGGERS.entrySet()) {
                ((FailsafeLogger)entry.getValue()).setLogger(LOGGER_ADAPTER.getLogger((String)entry.getKey()));
            }
        }
    }

    public static Logger getLogger(Class<?> key) {
        return LOGGERS.computeIfAbsent(key.getName(), name -> new FailsafeLogger(LOGGER_ADAPTER.getLogger((String)name)));
    }

    public static Logger getLogger(String key) {
        return LOGGERS.computeIfAbsent(key, k -> new FailsafeLogger(LOGGER_ADAPTER.getLogger((String)k)));
    }

    public static Level getLevel() {
        return LOGGER_ADAPTER.getLevel();
    }

    public static void setLevel(Level level) {
        LOGGER_ADAPTER.setLevel(level);
    }

    public static File getFile() {
        return LOGGER_ADAPTER.getFile();
    }

    public static List<String> getAvailableAdapter() {
        HashMap<Class<JdkLoggerAdapter>, String> candidates = new HashMap<Class<JdkLoggerAdapter>, String>();
        candidates.put(Log4jLoggerAdapter.class, "log4j");
        candidates.put(Slf4jLoggerAdapter.class, "slf4j");
        candidates.put(Log4j2LoggerAdapter.class, "log4j2");
        candidates.put(JclLoggerAdapter.class, "jcl");
        candidates.put(JdkLoggerAdapter.class, "jdk");
        LinkedList<String> result = new LinkedList<String>();
        for (Map.Entry entry : candidates.entrySet()) {
            try {
                LoggerAdapter loggerAdapter = (LoggerAdapter)((Class)entry.getKey()).newInstance();
                loggerAdapter.getLogger(LoggerFactory.class);
                result.add((String)entry.getValue());
            }
            catch (Throwable throwable) {}
        }
        return result;
    }

    public static String getCurrentAdapter() {
        HashMap<Class<JdkLoggerAdapter>, String> candidates = new HashMap<Class<JdkLoggerAdapter>, String>();
        candidates.put(Log4jLoggerAdapter.class, "log4j");
        candidates.put(Slf4jLoggerAdapter.class, "slf4j");
        candidates.put(Log4j2LoggerAdapter.class, "log4j2");
        candidates.put(JclLoggerAdapter.class, "jcl");
        candidates.put(JdkLoggerAdapter.class, "jdk");
        String name = (String)candidates.get(LOGGER_ADAPTER.getClass());
        if (name == null) {
            name = LOGGER_ADAPTER.getClass().getSimpleName();
        }
        return name;
    }

    static {
        String logger;
        LOGGERS = new ConcurrentHashMap<String, FailsafeLogger>();
        block8 : switch (logger = System.getProperty("dubbo.application.logger", "")) {
            case "slf4j": {
                LoggerFactory.setLoggerAdapter(new Slf4jLoggerAdapter());
                break;
            }
            case "jcl": {
                LoggerFactory.setLoggerAdapter(new JclLoggerAdapter());
                break;
            }
            case "log4j": {
                LoggerFactory.setLoggerAdapter(new Log4jLoggerAdapter());
                break;
            }
            case "jdk": {
                LoggerFactory.setLoggerAdapter(new JdkLoggerAdapter());
                break;
            }
            case "log4j2": {
                LoggerFactory.setLoggerAdapter(new Log4j2LoggerAdapter());
                break;
            }
            default: {
                List<Class> candidates = Arrays.asList(Log4jLoggerAdapter.class, Slf4jLoggerAdapter.class, Log4j2LoggerAdapter.class, JclLoggerAdapter.class, JdkLoggerAdapter.class);
                for (Class clazz : candidates) {
                    try {
                        LoggerAdapter loggerAdapter = (LoggerAdapter)clazz.newInstance();
                        loggerAdapter.getLogger(LoggerFactory.class);
                        LoggerFactory.setLoggerAdapter(loggerAdapter);
                        break block8;
                    }
                    catch (Throwable throwable) {
                    }
                }
            }
        }
    }
}

