/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.model;

import java.util.HashMap;
import java.util.Set;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.ModuleEnvironment;
import org.apache.dubbo.common.context.ModuleExt;
import org.apache.dubbo.common.deploy.ApplicationDeployer;
import org.apache.dubbo.common.deploy.DeployState;
import org.apache.dubbo.common.deploy.ModuleDeployer;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.extension.ExtensionScope;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.config.context.ModuleConfigManager;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.AsyncMethodInfo;
import org.apache.dubbo.rpc.model.ConsumerModel;
import org.apache.dubbo.rpc.model.ModuleServiceRepository;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.model.ScopeModelInitializer;
import org.apache.dubbo.rpc.model.ServiceMetadata;

public class ModuleModel
extends ScopeModel {
    private static final Logger logger = LoggerFactory.getLogger(ModuleModel.class);
    public static final String NAME = "ModuleModel";
    private final ApplicationModel applicationModel;
    private ModuleEnvironment moduleEnvironment;
    private ModuleServiceRepository serviceRepository;
    private ModuleConfigManager moduleConfigManager;
    private ModuleDeployer deployer;

    public ModuleModel(ApplicationModel applicationModel) {
        this(applicationModel, false);
    }

    public ModuleModel(ApplicationModel applicationModel, boolean isInternal) {
        super(applicationModel, ExtensionScope.MODULE, isInternal);
        Assert.notNull((Object)applicationModel, "ApplicationModel can not be null");
        this.applicationModel = applicationModel;
        applicationModel.addModule(this, isInternal);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(this.getDesc() + " is created");
        }
        this.initialize();
        Assert.notNull((Object)this.serviceRepository, "ModuleServiceRepository can not be null");
        Assert.notNull((Object)this.moduleConfigManager, "ModuleConfigManager can not be null");
        Assert.assertTrue(this.moduleConfigManager.isInitialized(), "ModuleConfigManager can not be initialized");
        ApplicationDeployer applicationDeployer = applicationModel.getDeployer();
        if (applicationDeployer != null) {
            applicationDeployer.notifyModuleChanged(this, DeployState.PENDING);
        }
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.serviceRepository = new ModuleServiceRepository(this);
        this.moduleConfigManager = new ModuleConfigManager(this);
        this.moduleConfigManager.initialize();
        this.initModuleExt();
        ExtensionLoader<ScopeModelInitializer> initializerExtensionLoader = this.getExtensionLoader(ScopeModelInitializer.class);
        Set<ScopeModelInitializer> initializers = initializerExtensionLoader.getSupportedExtensionInstances();
        for (ScopeModelInitializer initializer : initializers) {
            initializer.initializeModuleModel(this);
        }
    }

    private void initModuleExt() {
        Set<ModuleExt> exts = this.getExtensionLoader(ModuleExt.class).getSupportedExtensionInstances();
        for (ModuleExt ext : exts) {
            ext.initialize();
        }
    }

    @Override
    protected void onDestroy() {
        this.applicationModel.removeModule(this);
        if (this.deployer != null) {
            this.deployer.preDestroy();
        }
        if (this.deployer != null) {
            this.deployer.postDestroy();
        }
        this.notifyDestroy();
        if (this.serviceRepository != null) {
            this.serviceRepository.destroy();
            this.serviceRepository = null;
        }
        if (this.moduleEnvironment != null) {
            this.moduleEnvironment.destroy();
            this.moduleEnvironment = null;
        }
        if (this.moduleConfigManager != null) {
            this.moduleConfigManager.destroy();
            this.moduleConfigManager = null;
        }
        this.applicationModel.tryDestroy();
    }

    public ApplicationModel getApplicationModel() {
        return this.applicationModel;
    }

    public ModuleServiceRepository getServiceRepository() {
        return this.serviceRepository;
    }

    @Override
    public void addClassLoader(ClassLoader classLoader) {
        super.addClassLoader(classLoader);
        if (this.moduleEnvironment != null) {
            this.moduleEnvironment.refreshClassLoaders();
        }
    }

    @Override
    public ModuleEnvironment getModelEnvironment() {
        if (this.moduleEnvironment == null) {
            this.moduleEnvironment = (ModuleEnvironment)this.getExtensionLoader(ModuleExt.class).getExtension("moduleEnvironment");
        }
        return this.moduleEnvironment;
    }

    public ModuleConfigManager getConfigManager() {
        return this.moduleConfigManager;
    }

    public ModuleDeployer getDeployer() {
        return this.deployer;
    }

    public void setDeployer(ModuleDeployer deployer) {
        this.deployer = deployer;
    }

    @Deprecated
    public void setModuleEnvironment(ModuleEnvironment moduleEnvironment) {
        this.moduleEnvironment = moduleEnvironment;
    }

    public ConsumerModel registerInternalConsumer(Class<?> internalService, URL url) {
        ServiceMetadata serviceMetadata = new ServiceMetadata();
        serviceMetadata.setVersion(url.getVersion());
        serviceMetadata.setGroup(url.getGroup());
        serviceMetadata.setDefaultGroup(url.getGroup());
        serviceMetadata.setServiceInterfaceName(internalService.getName());
        serviceMetadata.setServiceType(internalService);
        String servyceKey = URL.buildKey(internalService.getName(), url.getGroup(), url.getVersion());
        serviceMetadata.setServiceKey(servyceKey);
        ConsumerModel consumerModel = new ConsumerModel(serviceMetadata.getServiceKey(), "jdk", this.serviceRepository.lookupService(serviceMetadata.getServiceInterfaceName()), null, this, serviceMetadata, new HashMap<String, AsyncMethodInfo>());
        logger.info("Dynamically registering consumer model " + servyceKey + " into model " + this.getDesc());
        this.serviceRepository.registerConsumer(consumerModel);
        return consumerModel;
    }
}

