/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common;

import java.io.IOException;
import java.net.URL;
import java.security.CodeSource;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.common.utils.StringUtils;

public final class Version {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(Version.class);
    private static final Pattern PREFIX_DIGITS_PATTERN = Pattern.compile("^([0-9]*).*");
    public static final String DEFAULT_DUBBO_PROTOCOL_VERSION = "2.0.2";
    public static final int LEGACY_DUBBO_PROTOCOL_VERSION = 10000;
    private static final String VERSION = Version.getVersion(Version.class, "");
    public static final int LOWEST_VERSION_FOR_RESPONSE_ATTACHMENT = 2000200;
    public static final int HIGHEST_PROTOCOL_VERSION = 2009900;
    private static final Map<String, Integer> VERSION2INT = new HashMap<String, Integer>();

    private Version() {
    }

    public static String getProtocolVersion() {
        return DEFAULT_DUBBO_PROTOCOL_VERSION;
    }

    public static String getVersion() {
        return VERSION;
    }

    public static int compare(String version1, String version2) {
        return Integer.compare(Version.getIntVersion(version1), Version.getIntVersion(version2));
    }

    public static boolean isRelease270OrHigher(String version) {
        if (StringUtils.isEmpty(version)) {
            return false;
        }
        return Version.getIntVersion(version) >= 2070000;
    }

    public static boolean isRelease263OrHigher(String version) {
        return Version.getIntVersion(version) >= 2060300;
    }

    public static boolean isSupportResponseAttachment(String version) {
        if (StringUtils.isEmpty(version)) {
            return false;
        }
        int iVersion = Version.getIntVersion(version);
        return iVersion >= 2000200 && iVersion <= 2009900;
    }

    public static int getIntVersion(String version) {
        Integer v = VERSION2INT.get(version);
        if (v == null) {
            try {
                v = Version.parseInt(version);
                if (version.split("\\.").length == 3) {
                    v = v * 100;
                }
            }
            catch (Exception e) {
                logger.warn("0-12", "", "", "Please make sure your version value has the right format: \n 1. only contains digital number: 2.0.0; \n 2. with string suffix: 2.6.7-stable. \nIf you are using Dubbo before v2.6.2, the version value is the same with the jar version.");
                v = 10000;
            }
            VERSION2INT.put(version, v);
        }
        return v;
    }

    private static int parseInt(String version) {
        int v = 0;
        String[] vArr = version.split("\\.");
        int len = vArr.length;
        for (int i = 0; i < len; ++i) {
            String subV = Version.getPrefixDigits(vArr[i]);
            if (!StringUtils.isNotEmpty(subV)) continue;
            v = (int)((double)v + (double)Integer.parseInt(subV) * Math.pow(10.0, (len - i - 1) * 2));
        }
        return v;
    }

    private static String getPrefixDigits(String v) {
        Matcher matcher = PREFIX_DIGITS_PATTERN.matcher(v);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    public static String getVersion(Class<?> cls, String defaultVersion) {
        try {
            CodeSource codeSource;
            Package pkg = cls.getPackage();
            String version = null;
            if (pkg != null) {
                version = pkg.getImplementationVersion();
                if (StringUtils.isNotEmpty(version)) {
                    return version;
                }
                version = pkg.getSpecificationVersion();
                if (StringUtils.isNotEmpty(version)) {
                    return version;
                }
            }
            if ((codeSource = cls.getProtectionDomain().getCodeSource()) == null) {
                logger.info("No codeSource for class " + cls.getName() + " when getVersion, use default version " + defaultVersion);
                return defaultVersion;
            }
            URL location = codeSource.getLocation();
            if (location == null) {
                logger.info("No location for class " + cls.getName() + " when getVersion, use default version " + defaultVersion);
                return defaultVersion;
            }
            String file = location.getFile();
            if (!StringUtils.isEmpty(file) && file.endsWith(".jar")) {
                version = Version.getFromFile(file);
            }
            return StringUtils.isEmpty(version) ? defaultVersion : version;
        }
        catch (Throwable e) {
            logger.error("0-12", "", "", "return default version, ignore exception " + e.getMessage(), e);
            return defaultVersion;
        }
    }

    private static String getFromFile(String file) {
        int i = (file = file.substring(0, file.length() - 4)).lastIndexOf(47);
        if (i >= 0) {
            file = file.substring(i + 1);
        }
        if ((i = file.indexOf("-")) >= 0) {
            file = file.substring(i + 1);
        }
        while (file.length() > 0 && !Character.isDigit(file.charAt(0)) && (i = file.indexOf("-")) >= 0) {
            file = file.substring(i + 1);
        }
        return file;
    }

    public static void checkDuplicate(Class<?> cls, boolean failOnError) {
        Version.checkDuplicate(cls.getName().replace('.', '/') + ".class", failOnError);
    }

    public static void checkDuplicate(Class<?> cls) {
        Version.checkDuplicate(cls, false);
    }

    public static void checkDuplicate(String path, boolean failOnError) {
        try {
            Set<String> files = Version.getResources(path);
            if (files.size() > 1) {
                String error = "Duplicate class " + path + " in " + files.size() + " jar " + files;
                if (failOnError) {
                    throw new IllegalStateException(error);
                }
                logger.error("0-12", "", "", error);
            }
        }
        catch (Throwable e) {
            logger.error("0-12", "", "", e.getMessage(), e);
        }
    }

    private static Set<String> getResources(String path) throws IOException {
        Enumeration<URL> urls = ClassUtils.getCallerClassLoader(Version.class).getResources(path);
        HashSet<String> files = new HashSet<String>();
        while (urls.hasMoreElements()) {
            String file;
            URL url = urls.nextElement();
            if (url == null || !StringUtils.isNotEmpty(file = url.getFile())) continue;
            files.add(file);
        }
        return files;
    }

    static {
        Version.checkDuplicate(Version.class);
    }
}

