/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.config;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.config.CompositeConfiguration;
import org.apache.dubbo.common.config.Configuration;
import org.apache.dubbo.common.config.Environment;
import org.apache.dubbo.common.config.EnvironmentConfiguration;
import org.apache.dubbo.common.config.InmemoryConfiguration;
import org.apache.dubbo.common.config.OrderedPropertiesConfiguration;
import org.apache.dubbo.common.config.PrefixedConfiguration;
import org.apache.dubbo.common.config.PropertiesConfiguration;
import org.apache.dubbo.common.config.SystemConfiguration;
import org.apache.dubbo.common.config.configcenter.DynamicConfiguration;
import org.apache.dubbo.common.context.ModuleExt;
import org.apache.dubbo.common.extension.DisableInject;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.rpc.model.ModuleModel;

public class ModuleEnvironment
extends Environment
implements ModuleExt {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(ModuleEnvironment.class);
    public static final String NAME = "moduleEnvironment";
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private final ModuleModel moduleModel;
    private Environment applicationDelegate;
    private OrderedPropertiesConfiguration orderedPropertiesConfiguration;
    private CompositeConfiguration dynamicGlobalConfiguration;
    private DynamicConfiguration dynamicConfiguration;

    public ModuleEnvironment(ModuleModel moduleModel) {
        super(moduleModel);
        this.moduleModel = moduleModel;
        this.applicationDelegate = moduleModel.getApplicationModel().getModelEnvironment();
    }

    @Override
    public void initialize() throws IllegalStateException {
        if (this.initialized.compareAndSet(false, true)) {
            this.orderedPropertiesConfiguration = new OrderedPropertiesConfiguration(this.moduleModel);
        }
    }

    @Override
    public Configuration getPrefixedConfiguration(AbstractConfig config, String prefix) {
        CompositeConfiguration compositeConfiguration = new CompositeConfiguration();
        compositeConfiguration.addConfiguration(this.applicationDelegate.getPrefixedConfiguration(config, prefix));
        compositeConfiguration.addConfiguration(this.orderedPropertiesConfiguration);
        return new PrefixedConfiguration(compositeConfiguration, prefix);
    }

    @Override
    public CompositeConfiguration getConfiguration() {
        if (this.globalConfiguration == null) {
            CompositeConfiguration configuration = new CompositeConfiguration();
            configuration.addConfiguration(this.applicationDelegate.getConfiguration());
            configuration.addConfiguration(this.orderedPropertiesConfiguration);
            this.globalConfiguration = configuration;
        }
        return this.globalConfiguration;
    }

    @Override
    public List<Map<String, String>> getConfigurationMaps(AbstractConfig config, String prefix) {
        List<Map<String, String>> maps = this.applicationDelegate.getConfigurationMaps(config, prefix);
        maps.add(this.orderedPropertiesConfiguration.getProperties());
        return maps;
    }

    @Override
    public Configuration getDynamicGlobalConfiguration() {
        if (this.dynamicConfiguration == null) {
            return this.applicationDelegate.getDynamicGlobalConfiguration();
        }
        if (this.dynamicGlobalConfiguration == null) {
            if (this.dynamicConfiguration == null) {
                if (logger.isWarnEnabled()) {
                    logger.warn("0-12", "", "", "dynamicConfiguration is null , return globalConfiguration.");
                }
                return this.getConfiguration();
            }
            this.dynamicGlobalConfiguration = new CompositeConfiguration();
            this.dynamicGlobalConfiguration.addConfiguration(this.dynamicConfiguration);
            this.dynamicGlobalConfiguration.addConfiguration(this.getConfiguration());
        }
        return this.dynamicGlobalConfiguration;
    }

    @Override
    public Optional<DynamicConfiguration> getDynamicConfiguration() {
        if (this.dynamicConfiguration == null) {
            return this.applicationDelegate.getDynamicConfiguration();
        }
        return Optional.ofNullable(this.dynamicConfiguration);
    }

    @Override
    @DisableInject
    public void setDynamicConfiguration(DynamicConfiguration dynamicConfiguration) {
        this.dynamicConfiguration = dynamicConfiguration;
    }

    @Override
    public void destroy() throws IllegalStateException {
        super.destroy();
        this.orderedPropertiesConfiguration = null;
    }

    @Override
    @DisableInject
    public void setLocalMigrationRule(String localMigrationRule) {
        this.applicationDelegate.setLocalMigrationRule(localMigrationRule);
    }

    @Override
    @DisableInject
    public void setExternalConfigMap(Map<String, String> externalConfiguration) {
        this.applicationDelegate.setExternalConfigMap(externalConfiguration);
    }

    @Override
    @DisableInject
    public void setAppExternalConfigMap(Map<String, String> appExternalConfiguration) {
        this.applicationDelegate.setAppExternalConfigMap(appExternalConfiguration);
    }

    @Override
    @DisableInject
    public void setAppConfigMap(Map<String, String> appConfiguration) {
        this.applicationDelegate.setAppConfigMap(appConfiguration);
    }

    @Override
    public Map<String, String> getExternalConfigMap() {
        return this.applicationDelegate.getExternalConfigMap();
    }

    @Override
    public Map<String, String> getAppExternalConfigMap() {
        return this.applicationDelegate.getAppExternalConfigMap();
    }

    @Override
    public Map<String, String> getAppConfigMap() {
        return this.applicationDelegate.getAppConfigMap();
    }

    @Override
    public void updateExternalConfigMap(Map<String, String> externalMap) {
        this.applicationDelegate.updateExternalConfigMap(externalMap);
    }

    @Override
    public void updateAppExternalConfigMap(Map<String, String> externalMap) {
        this.applicationDelegate.updateAppExternalConfigMap(externalMap);
    }

    @Override
    public void updateAppConfigMap(Map<String, String> map) {
        this.applicationDelegate.updateAppConfigMap(map);
    }

    @Override
    public PropertiesConfiguration getPropertiesConfiguration() {
        return this.applicationDelegate.getPropertiesConfiguration();
    }

    @Override
    public SystemConfiguration getSystemConfiguration() {
        return this.applicationDelegate.getSystemConfiguration();
    }

    @Override
    public EnvironmentConfiguration getEnvironmentConfiguration() {
        return this.applicationDelegate.getEnvironmentConfiguration();
    }

    @Override
    public InmemoryConfiguration getExternalConfiguration() {
        return this.applicationDelegate.getExternalConfiguration();
    }

    @Override
    public InmemoryConfiguration getAppExternalConfiguration() {
        return this.applicationDelegate.getAppExternalConfiguration();
    }

    @Override
    public InmemoryConfiguration getAppConfiguration() {
        return this.applicationDelegate.getAppConfiguration();
    }

    @Override
    public String getLocalMigrationRule() {
        return this.applicationDelegate.getLocalMigrationRule();
    }

    @Override
    public synchronized void refreshClassLoaders() {
        this.orderedPropertiesConfiguration.refresh();
        this.applicationDelegate.refreshClassLoaders();
    }
}

