/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.executor;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.dubbo.common.ServiceKey;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.resource.GlobalResourcesRepository;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.apache.dubbo.common.url.component.ServiceConfigURL;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.executor.ExecutorSupport;

public abstract class AbstractIsolationExecutorSupport
implements ExecutorSupport {
    private final URL url;
    private final ExecutorRepository executorRepository;
    private final Map<String, Executor> executorMap;

    public AbstractIsolationExecutorSupport(URL url) {
        this.url = url;
        this.executorRepository = ExecutorRepository.getInstance(url.getOrDefaultApplicationModel());
        this.executorMap = new HashMap<String, Executor>();
        GlobalResourcesRepository.getInstance().registerDisposable(this::destroy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Executor getExecutor(Object data) {
        ServiceKey serviceKey = this.getServiceKey(data);
        if (!this.isValid(serviceKey)) {
            return null;
        }
        String interfaceName = serviceKey.getInterfaceName();
        String version = serviceKey.getVersion();
        String group = serviceKey.getGroup();
        String cachedKey = URL.buildKey(interfaceName, group, version);
        if (this.executorMap.containsKey(cachedKey)) {
            return this.executorMap.get(cachedKey);
        }
        AbstractIsolationExecutorSupport abstractIsolationExecutorSupport = this;
        synchronized (abstractIsolationExecutorSupport) {
            if (this.executorMap.containsKey(cachedKey)) {
                return this.executorMap.get(cachedKey);
            }
            Map<String, String> parameters = this.url.getParameters();
            parameters.put("group", group);
            parameters.put("interface", interfaceName);
            parameters.put("version", version);
            ServiceConfigURL tmpURL = new ServiceConfigURL(this.url.getProtocol(), this.url.getHost(), this.url.getPort(), interfaceName, parameters);
            ExecutorService executor = this.executorRepository.getExecutor(tmpURL);
            this.executorMap.put(cachedKey, executor);
            return executor;
        }
    }

    public synchronized void destroy() {
        this.executorMap.clear();
    }

    private boolean isValid(ServiceKey serviceKey) {
        return serviceKey != null && StringUtils.isNotEmpty(serviceKey.getInterfaceName());
    }

    protected abstract ServiceKey getServiceKey(Object var1);
}

