/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.metrics.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.dubbo.common.utils.NetUtils;

public class MethodMetric {
    private String applicationName;
    private String interfaceName;
    private String methodName;
    private String group;
    private String version;

    public MethodMetric() {
    }

    public MethodMetric(String applicationName, String interfaceName, String methodName, String group, String version) {
        this.applicationName = applicationName;
        this.interfaceName = interfaceName;
        this.methodName = methodName;
        this.group = group;
        this.version = version;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Map<String, String> getTags() {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("ip", NetUtils.getLocalHost());
        tags.put("hostname", NetUtils.getLocalHostName());
        tags.put("application.name", this.applicationName);
        tags.put("interface", this.interfaceName);
        tags.put("method", this.methodName);
        tags.put("group", this.group);
        tags.put("version", this.version);
        return tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodMetric that = (MethodMetric)o;
        return Objects.equals(this.interfaceName, that.interfaceName) && Objects.equals(this.methodName, that.methodName) && Objects.equals(this.group, that.group) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.interfaceName, this.methodName, this.group, this.version);
    }

    public String toString() {
        return "MethodMetric{interfaceName='" + this.interfaceName + '\'' + ", methodName='" + this.methodName + '\'' + ", group='" + this.group + '\'' + ", version='" + this.version + '\'' + '}';
    }
}

