/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.logger;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.Level;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerAdapter;
import org.apache.dubbo.common.logger.jcl.JclLoggerAdapter;
import org.apache.dubbo.common.logger.jdk.JdkLoggerAdapter;
import org.apache.dubbo.common.logger.log4j.Log4jLoggerAdapter;
import org.apache.dubbo.common.logger.log4j2.Log4j2LoggerAdapter;
import org.apache.dubbo.common.logger.slf4j.Slf4jLoggerAdapter;
import org.apache.dubbo.common.logger.support.FailsafeErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.support.FailsafeLogger;
import org.apache.dubbo.rpc.model.FrameworkModel;

public class LoggerFactory {
    private static final ConcurrentMap<String, FailsafeLogger> LOGGERS;
    private static final ConcurrentMap<String, FailsafeErrorTypeAwareLogger> ERROR_TYPE_AWARE_LOGGERS;
    private static volatile LoggerAdapter loggerAdapter;

    private LoggerFactory() {
    }

    public static void setLoggerAdapter(FrameworkModel frameworkModel, String loggerAdapter) {
        if (loggerAdapter != null && loggerAdapter.length() > 0) {
            LoggerFactory.setLoggerAdapter(frameworkModel.getExtensionLoader(LoggerAdapter.class).getExtension(loggerAdapter));
        }
    }

    public static void setLoggerAdapter(LoggerAdapter loggerAdapter) {
        if (loggerAdapter != null) {
            if (loggerAdapter == LoggerFactory.loggerAdapter) {
                return;
            }
            loggerAdapter.getLogger(LoggerFactory.class.getName());
            LoggerFactory.loggerAdapter = loggerAdapter;
            for (Map.Entry entry : LOGGERS.entrySet()) {
                ((FailsafeLogger)entry.getValue()).setLogger(LoggerFactory.loggerAdapter.getLogger((String)entry.getKey()));
            }
        }
    }

    public static Logger getLogger(Class<?> key) {
        return LOGGERS.computeIfAbsent(key.getName(), name -> new FailsafeLogger(loggerAdapter.getLogger((String)name)));
    }

    public static Logger getLogger(String key) {
        return LOGGERS.computeIfAbsent(key, k -> new FailsafeLogger(loggerAdapter.getLogger((String)k)));
    }

    public static ErrorTypeAwareLogger getErrorTypeAwareLogger(Class<?> key) {
        return ERROR_TYPE_AWARE_LOGGERS.computeIfAbsent(key.getName(), name -> new FailsafeErrorTypeAwareLogger(loggerAdapter.getLogger((String)name)));
    }

    public static ErrorTypeAwareLogger getErrorTypeAwareLogger(String key) {
        return ERROR_TYPE_AWARE_LOGGERS.computeIfAbsent(key, k -> new FailsafeErrorTypeAwareLogger(loggerAdapter.getLogger((String)k)));
    }

    public static Level getLevel() {
        return loggerAdapter.getLevel();
    }

    public static void setLevel(Level level) {
        loggerAdapter.setLevel(level);
    }

    public static File getFile() {
        return loggerAdapter.getFile();
    }

    public static List<String> getAvailableAdapter() {
        HashMap<Class<JdkLoggerAdapter>, String> candidates = new HashMap<Class<JdkLoggerAdapter>, String>();
        candidates.put(Log4jLoggerAdapter.class, "log4j");
        candidates.put(Slf4jLoggerAdapter.class, "slf4j");
        candidates.put(Log4j2LoggerAdapter.class, "log4j2");
        candidates.put(JclLoggerAdapter.class, "jcl");
        candidates.put(JdkLoggerAdapter.class, "jdk");
        LinkedList<String> result = new LinkedList<String>();
        for (Map.Entry entry : candidates.entrySet()) {
            try {
                LoggerAdapter loggerAdapter = (LoggerAdapter)((Class)entry.getKey()).getConstructor(new Class[0]).newInstance(new Object[0]);
                loggerAdapter.getLogger(LoggerFactory.class);
                result.add((String)entry.getValue());
            }
            catch (Exception exception) {}
        }
        return result;
    }

    public static String getCurrentAdapter() {
        HashMap<Class<JdkLoggerAdapter>, String> candidates = new HashMap<Class<JdkLoggerAdapter>, String>();
        candidates.put(Log4jLoggerAdapter.class, "log4j");
        candidates.put(Slf4jLoggerAdapter.class, "slf4j");
        candidates.put(Log4j2LoggerAdapter.class, "log4j2");
        candidates.put(JclLoggerAdapter.class, "jcl");
        candidates.put(JdkLoggerAdapter.class, "jdk");
        String name = (String)candidates.get(loggerAdapter.getClass());
        if (name == null) {
            name = loggerAdapter.getClass().getSimpleName();
        }
        return name;
    }

    static {
        String logger;
        LOGGERS = new ConcurrentHashMap<String, FailsafeLogger>();
        ERROR_TYPE_AWARE_LOGGERS = new ConcurrentHashMap<String, FailsafeErrorTypeAwareLogger>();
        switch (logger = System.getProperty("dubbo.application.logger", "")) {
            case "slf4j": {
                LoggerFactory.setLoggerAdapter(new Slf4jLoggerAdapter());
                break;
            }
            case "jcl": {
                LoggerFactory.setLoggerAdapter(new JclLoggerAdapter());
                break;
            }
            case "log4j": {
                LoggerFactory.setLoggerAdapter(new Log4jLoggerAdapter());
                break;
            }
            case "jdk": {
                LoggerFactory.setLoggerAdapter(new JdkLoggerAdapter());
                break;
            }
            case "log4j2": {
                LoggerFactory.setLoggerAdapter(new Log4j2LoggerAdapter());
                break;
            }
            default: {
                LoggerAdapter loggerAdapter2;
                List<Class> candidates = Arrays.asList(Log4jLoggerAdapter.class, Slf4jLoggerAdapter.class, Log4j2LoggerAdapter.class, JclLoggerAdapter.class, JdkLoggerAdapter.class);
                boolean found = false;
                for (Class clazz : candidates) {
                    try {
                        loggerAdapter2 = (LoggerAdapter)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                        loggerAdapter2.getLogger(LoggerFactory.class);
                        if (!loggerAdapter2.isConfigured()) continue;
                        LoggerFactory.setLoggerAdapter(loggerAdapter2);
                        found = true;
                        break;
                    }
                    catch (Exception | LinkageError loggerAdapter2) {
                    }
                }
                if (found) break;
                System.err.println("Dubbo: Unable to find a proper configured logger to log out.");
                for (Class clazz : candidates) {
                    try {
                        loggerAdapter2 = (LoggerAdapter)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                        loggerAdapter2.getLogger(LoggerFactory.class);
                        LoggerFactory.setLoggerAdapter(loggerAdapter2);
                        found = true;
                        break;
                    }
                    catch (Throwable throwable) {
                    }
                }
                if (found) {
                    System.err.println("Dubbo: Using default logger: " + LoggerFactory.loggerAdapter.getClass().getName() + ". If you cannot see any log, please configure -Ddubbo.application.logger property to your preferred logging framework.");
                    break;
                }
                System.err.println("Dubbo: Unable to find any available logger adapter to log out. Dubbo logs will be ignored. Please configure -Ddubbo.application.logger property and add corresponding logging library to classpath.");
            }
        }
    }
}

