/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.metrics.collector.stat;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAccumulator;
import org.apache.dubbo.common.metrics.collector.DefaultMetricsCollector;
import org.apache.dubbo.common.metrics.collector.stat.DefaultMetricsStatHandler;
import org.apache.dubbo.common.metrics.collector.stat.MetricsStatHandler;
import org.apache.dubbo.common.metrics.event.MetricsEvent;
import org.apache.dubbo.common.metrics.event.RTEvent;
import org.apache.dubbo.common.metrics.event.RequestEvent;
import org.apache.dubbo.common.metrics.listener.MetricsListener;
import org.apache.dubbo.common.metrics.model.MethodMetric;
import org.apache.dubbo.common.utils.ConcurrentHashMapUtils;

public class MetricsStatComposite {
    public Map<RequestEvent.Type, MetricsStatHandler> stats = new ConcurrentHashMap<RequestEvent.Type, MetricsStatHandler>();
    private final ConcurrentMap<MethodMetric, AtomicLong> lastRT = new ConcurrentHashMap<MethodMetric, AtomicLong>();
    private final ConcurrentMap<MethodMetric, LongAccumulator> minRT = new ConcurrentHashMap<MethodMetric, LongAccumulator>();
    private final ConcurrentMap<MethodMetric, LongAccumulator> maxRT = new ConcurrentHashMap<MethodMetric, LongAccumulator>();
    private final ConcurrentMap<MethodMetric, AtomicLong> avgRT = new ConcurrentHashMap<MethodMetric, AtomicLong>();
    private final ConcurrentMap<MethodMetric, AtomicLong> totalRT = new ConcurrentHashMap<MethodMetric, AtomicLong>();
    private final ConcurrentMap<MethodMetric, AtomicLong> rtCount = new ConcurrentHashMap<MethodMetric, AtomicLong>();
    private final String applicationName;
    private final List<MetricsListener> listeners;
    private DefaultMetricsCollector collector;

    public MetricsStatComposite(String applicationName, DefaultMetricsCollector collector) {
        this.applicationName = applicationName;
        this.listeners = collector.getListener();
        this.collector = collector;
        this.init();
    }

    public MetricsStatHandler getHandler(RequestEvent.Type statType) {
        return this.stats.get((Object)statType);
    }

    public Map<MethodMetric, AtomicLong> getLastRT() {
        return this.lastRT;
    }

    public Map<MethodMetric, LongAccumulator> getMinRT() {
        return this.minRT;
    }

    public Map<MethodMetric, LongAccumulator> getMaxRT() {
        return this.maxRT;
    }

    public Map<MethodMetric, AtomicLong> getAvgRT() {
        return this.avgRT;
    }

    public Map<MethodMetric, AtomicLong> getTotalRT() {
        return this.totalRT;
    }

    public Map<MethodMetric, AtomicLong> getRtCount() {
        return this.rtCount;
    }

    public void addRT(String interfaceName, String methodName, String group, String version, Long responseTime) {
        if (this.collector.isCollectEnabled().booleanValue()) {
            MethodMetric metric = new MethodMetric(this.applicationName, interfaceName, methodName, group, version);
            AtomicLong last = ConcurrentHashMapUtils.computeIfAbsent(this.lastRT, metric, k -> new AtomicLong());
            last.set(responseTime);
            LongAccumulator min = ConcurrentHashMapUtils.computeIfAbsent(this.minRT, metric, k -> new LongAccumulator(Long::min, Long.MAX_VALUE));
            min.accumulate(responseTime);
            LongAccumulator max = ConcurrentHashMapUtils.computeIfAbsent(this.maxRT, metric, k -> new LongAccumulator(Long::max, Long.MIN_VALUE));
            max.accumulate(responseTime);
            AtomicLong total = ConcurrentHashMapUtils.computeIfAbsent(this.totalRT, metric, k -> new AtomicLong());
            total.addAndGet(responseTime);
            AtomicLong count = ConcurrentHashMapUtils.computeIfAbsent(this.rtCount, metric, k -> new AtomicLong());
            count.incrementAndGet();
            ConcurrentHashMapUtils.computeIfAbsent(this.avgRT, metric, k -> new AtomicLong());
            this.publishEvent(new RTEvent(metric, responseTime));
        }
    }

    private void init() {
        this.stats.put(RequestEvent.Type.TOTAL, new DefaultMetricsStatHandler(this.applicationName){

            @Override
            public void doNotify(MethodMetric metric) {
                MetricsStatComposite.this.publishEvent(new RequestEvent(metric, RequestEvent.Type.TOTAL));
            }
        });
        this.stats.put(RequestEvent.Type.SUCCEED, new DefaultMetricsStatHandler(this.applicationName){

            @Override
            public void doNotify(MethodMetric metric) {
                MetricsStatComposite.this.publishEvent(new RequestEvent(metric, RequestEvent.Type.SUCCEED));
            }
        });
        this.stats.put(RequestEvent.Type.UNKNOWN_FAILED, new DefaultMetricsStatHandler(this.applicationName){

            @Override
            public void doNotify(MethodMetric metric) {
                MetricsStatComposite.this.publishEvent(new RequestEvent(metric, RequestEvent.Type.UNKNOWN_FAILED));
            }
        });
        this.stats.put(RequestEvent.Type.BUSINESS_FAILED, new DefaultMetricsStatHandler(this.applicationName){

            @Override
            public void doNotify(MethodMetric metric) {
                MetricsStatComposite.this.publishEvent(new RequestEvent(metric, RequestEvent.Type.BUSINESS_FAILED));
            }
        });
        this.stats.put(RequestEvent.Type.PROCESSING, new DefaultMetricsStatHandler(this.applicationName));
        this.stats.put(RequestEvent.Type.REQUEST_LIMIT, new DefaultMetricsStatHandler(this.applicationName){

            @Override
            public void doNotify(MethodMetric metric) {
                MetricsStatComposite.this.publishEvent(new RequestEvent(metric, RequestEvent.Type.REQUEST_LIMIT));
            }
        });
        this.stats.put(RequestEvent.Type.REQUEST_TIMEOUT, new DefaultMetricsStatHandler(this.applicationName){

            @Override
            public void doNotify(MethodMetric metric) {
                MetricsStatComposite.this.publishEvent(new RequestEvent(metric, RequestEvent.Type.REQUEST_TIMEOUT));
            }
        });
        this.stats.put(RequestEvent.Type.TOTAL_FAILED, new DefaultMetricsStatHandler(this.applicationName){

            @Override
            public void doNotify(MethodMetric metric) {
                MetricsStatComposite.this.publishEvent(new RequestEvent(metric, RequestEvent.Type.TOTAL_FAILED));
            }
        });
    }

    private void publishEvent(MetricsEvent event) {
        for (MetricsListener listener : this.listeners) {
            listener.onEvent(event);
        }
    }
}

