/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.store.support;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.dubbo.common.store.DataStore;
import org.apache.dubbo.common.utils.ConcurrentHashMapUtils;

public class SimpleDataStore
implements DataStore {
    private ConcurrentMap<String, ConcurrentMap<String, Object>> data = new ConcurrentHashMap<String, ConcurrentMap<String, Object>>();

    @Override
    public Map<String, Object> get(String componentName) {
        ConcurrentMap value = (ConcurrentMap)this.data.get(componentName);
        if (value == null) {
            return new HashMap<String, Object>();
        }
        return new HashMap<String, Object>(value);
    }

    @Override
    public Object get(String componentName, String key) {
        if (!this.data.containsKey(componentName)) {
            return null;
        }
        return ((ConcurrentMap)this.data.get(componentName)).get(key);
    }

    @Override
    public void put(String componentName, String key, Object value) {
        Map componentData = ConcurrentHashMapUtils.computeIfAbsent(this.data, componentName, k -> new ConcurrentHashMap());
        componentData.put(key, value);
    }

    @Override
    public void remove(String componentName, String key) {
        if (!this.data.containsKey(componentName)) {
            return;
        }
        ((ConcurrentMap)this.data.get(componentName)).remove(key);
    }
}

