/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.AbstractServiceConfig;
import org.apache.dubbo.config.MethodConfig;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.ProviderConfig;
import org.apache.dubbo.config.annotation.Service;
import org.apache.dubbo.config.context.ConfigMode;
import org.apache.dubbo.config.support.Parameter;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.model.ServiceMetadata;
import org.apache.dubbo.rpc.service.GenericService;
import org.apache.dubbo.rpc.support.ProtocolUtils;

public abstract class ServiceConfigBase<T>
extends AbstractServiceConfig {
    private static final long serialVersionUID = 3033787999037024738L;
    protected Class<?> interfaceClass;
    protected T ref;
    protected String path;
    protected ProviderConfig provider;
    protected String providerIds;
    protected volatile String generic;

    public ServiceConfigBase() {
        this.serviceMetadata = new ServiceMetadata();
        this.serviceMetadata.addAttribute("ORIGIN_CONFIG", this);
    }

    public ServiceConfigBase(ModuleModel moduleModel) {
        super(moduleModel);
        this.serviceMetadata = new ServiceMetadata();
        this.serviceMetadata.addAttribute("ORIGIN_CONFIG", this);
    }

    public ServiceConfigBase(Service service) {
        this.serviceMetadata = new ServiceMetadata();
        this.serviceMetadata.addAttribute("ORIGIN_CONFIG", this);
        this.appendAnnotation(Service.class, service);
        this.setMethods(MethodConfig.constructMethodConfig(service.methods()));
    }

    public ServiceConfigBase(ModuleModel moduleModel, Service service) {
        super(moduleModel);
        this.serviceMetadata = new ServiceMetadata();
        this.serviceMetadata.addAttribute("ORIGIN_CONFIG", this);
        this.appendAnnotation(Service.class, service);
        this.setMethods(MethodConfig.constructMethodConfig(service.methods()));
    }

    @Override
    protected void postProcessAfterScopeModelChanged(ScopeModel oldScopeModel, ScopeModel newScopeModel) {
        super.postProcessAfterScopeModelChanged(oldScopeModel, newScopeModel);
        if (this.provider != null && this.provider.getScopeModel() != this.getScopeModel()) {
            this.provider.setScopeModel(this.getScopeModel());
        }
    }

    public boolean shouldExport() {
        Boolean export = this.getExport();
        return export == null ? true : export;
    }

    @Override
    public Boolean getExport() {
        return this.export == null && this.provider != null ? this.provider.getExport() : this.export;
    }

    public boolean shouldDelay() {
        Integer delay = this.getDelay();
        return delay != null && delay > 0;
    }

    @Override
    public Integer getDelay() {
        return this.delay == null && this.provider != null ? this.provider.getDelay() : this.delay;
    }

    protected void checkRef() {
        if (this.ref == null) {
            throw new IllegalStateException("ref not allow null!");
        }
        if (!this.interfaceClass.isInstance(this.ref)) {
            throw new IllegalStateException("The class " + this.getClassDesc(this.ref.getClass()) + " unimplemented interface " + this.getClassDesc(this.interfaceClass) + "!");
        }
    }

    private String getClassDesc(Class clazz) {
        ClassLoader classLoader = clazz.getClassLoader();
        return clazz.getName() + "[classloader=" + classLoader.getClass().getName() + "@" + classLoader.hashCode() + "]";
    }

    public Optional<String> getContextPath(ProtocolConfig protocolConfig) {
        String contextPath = protocolConfig.getContextpath();
        if (StringUtils.isEmpty(contextPath) && this.provider != null) {
            contextPath = this.provider.getContextpath();
        }
        return Optional.ofNullable(contextPath);
    }

    protected Class getServiceClass(T ref) {
        return ref.getClass();
    }

    @Override
    protected void preProcessRefresh() {
        super.preProcessRefresh();
        this.convertProviderIdToProvider();
        if (this.provider == null) {
            this.provider = this.getModuleConfigManager().getDefaultProvider().orElseThrow(() -> new IllegalStateException("Default provider is not initialized"));
        }
        this.refreshWithPrefixes(super.getPrefixes(), ConfigMode.OVERRIDE_IF_ABSENT);
    }

    @Override
    public Map<String, String> getMetaData() {
        return this.getMetaData(null);
    }

    @Override
    public Map<String, String> getMetaData(String prefix) {
        HashMap<String, String> metaData = new HashMap<String, String>();
        ProviderConfig provider = this.getProvider();
        if (this.isRefreshed() && provider == null) {
            throw new IllegalStateException("Provider is not initialized");
        }
        ServiceConfigBase.appendAttributes(metaData, provider, prefix);
        ServiceConfigBase.appendAttributes(metaData, this, prefix);
        return metaData;
    }

    protected void checkProtocol() {
        if (this.provider != null && this.notHasSelfProtocolProperty()) {
            this.setProtocols(this.provider.getProtocols());
            this.setProtocolIds(this.provider.getProtocolIds());
        }
        this.convertProtocolIdsToProtocols();
    }

    private boolean notHasSelfProtocolProperty() {
        return CollectionUtils.isEmpty(this.protocols) && StringUtils.isEmpty(this.protocolIds);
    }

    protected void completeCompoundConfigs() {
        super.completeCompoundConfigs(this.provider);
        if (this.provider != null) {
            if (this.notHasSelfProtocolProperty()) {
                this.setProtocols(this.provider.getProtocols());
                this.setProtocolIds(this.provider.getProtocolIds());
            }
            if (this.configCenter == null) {
                this.setConfigCenter(this.provider.getConfigCenter());
            }
        }
    }

    protected void convertProviderIdToProvider() {
        if (this.provider == null && StringUtils.hasText(this.providerIds)) {
            this.provider = this.getModuleConfigManager().getProvider(this.providerIds).orElseThrow(() -> new IllegalStateException("Provider config not found: " + this.providerIds));
        }
    }

    protected void convertProtocolIdsToProtocols() {
        if (StringUtils.isEmpty(this.protocolIds)) {
            if (CollectionUtils.isEmpty(this.protocols)) {
                List<ProtocolConfig> protocolConfigs = this.getConfigManager().getDefaultProtocols();
                if (protocolConfigs.isEmpty()) {
                    throw new IllegalStateException("The default protocol has not been initialized.");
                }
                this.setProtocols(protocolConfigs);
            }
        } else {
            String[] idsArray = CommonConstants.COMMA_SPLIT_PATTERN.split(this.protocolIds);
            LinkedHashSet<String> idsSet = new LinkedHashSet<String>(Arrays.asList(idsArray));
            ArrayList<ProtocolConfig> tmpProtocols = new ArrayList<ProtocolConfig>();
            for (String id : idsSet) {
                Optional<ProtocolConfig> globalProtocol = this.getConfigManager().getProtocol(id);
                if (globalProtocol.isPresent()) {
                    tmpProtocols.add(globalProtocol.get());
                    continue;
                }
                throw new IllegalStateException("Protocol not found: " + id);
            }
            this.setProtocols(tmpProtocols);
        }
    }

    public Class<?> getInterfaceClass() {
        if (this.interfaceClass != null) {
            return this.interfaceClass;
        }
        if (this.ref instanceof GenericService) {
            return GenericService.class;
        }
        try {
            if (StringUtils.isNotEmpty(this.interfaceName)) {
                this.interfaceClass = Class.forName(this.interfaceName, true, Thread.currentThread().getContextClassLoader());
            }
        }
        catch (ClassNotFoundException t) {
            throw new IllegalStateException(t.getMessage(), t);
        }
        return this.interfaceClass;
    }

    public void setInterfaceClass(Class<?> interfaceClass) {
        this.setInterface(interfaceClass);
    }

    public void setInterface(Class<?> interfaceClass) {
        if (interfaceClass != null && !interfaceClass.isInterface()) {
            throw new IllegalStateException("The interface class " + interfaceClass + " is not a interface!");
        }
        this.interfaceClass = interfaceClass;
        this.setInterface(interfaceClass == null ? null : interfaceClass.getName());
        if (this.getInterfaceClassLoader() == null) {
            this.setInterfaceClassLoader(interfaceClass == null ? null : interfaceClass.getClassLoader());
        }
    }

    public T getRef() {
        return this.ref;
    }

    public void setRef(T ref) {
        this.ref = ref;
    }

    @Parameter(excluded=true)
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public ProviderConfig getProvider() {
        return this.provider;
    }

    public void setProvider(ProviderConfig provider) {
        this.getModuleConfigManager().addProvider(provider);
        this.provider = provider;
    }

    @Parameter(excluded=true)
    public String getProviderIds() {
        return this.providerIds;
    }

    public void setProviderIds(String providerIds) {
        this.providerIds = providerIds;
    }

    public String getGeneric() {
        return this.generic;
    }

    public void setGeneric(String generic) {
        if (StringUtils.isEmpty(generic)) {
            return;
        }
        if (!ProtocolUtils.isValidGenericValue(generic)) {
            throw new IllegalArgumentException("Unsupported generic type " + generic);
        }
        this.generic = generic;
    }

    public ServiceMetadata getServiceMetadata() {
        return this.serviceMetadata;
    }

    @Override
    @Parameter(excluded=true, attribute=false)
    public List<String> getPrefixes() {
        ArrayList<String> prefixes = new ArrayList<String>();
        prefixes.add("dubbo.service." + this.interfaceName);
        return prefixes;
    }

    @Parameter(excluded=true, attribute=false)
    public String getUniqueServiceName() {
        return this.interfaceName != null ? URL.buildKey(this.interfaceName, this.getGroup(), this.getVersion()) : null;
    }

    @Override
    public String getGroup() {
        return StringUtils.isEmpty(this.group) ? (this.provider != null ? this.provider.getGroup() : this.group) : this.group;
    }

    @Override
    public String getVersion() {
        return StringUtils.isEmpty(this.version) ? (this.provider != null ? this.provider.getVersion() : this.version) : this.version;
    }

    @Override
    protected void computeValidRegistryIds() {
        if (this.provider != null && this.notHasSelfRegistryProperty()) {
            this.setRegistries(this.provider.getRegistries());
            this.setRegistryIds(this.provider.getRegistryIds());
        }
        super.computeValidRegistryIds();
    }

    public Boolean shouldExportAsync() {
        Boolean shouldExportAsync = this.getExportAsync();
        if (shouldExportAsync == null) {
            shouldExportAsync = this.provider != null && this.provider.getExportAsync() != null && this.provider.getExportAsync() != false;
        }
        return shouldExportAsync;
    }

    public abstract void export();

    public abstract void unexport();

    public abstract boolean isExported();

    public abstract boolean isUnexported();
}

