/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.threadpool;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.resource.GlobalResourcesRepository;
import org.apache.dubbo.common.utils.NamedThreadFactory;

public class MemoryLimitCalculator {
    private static volatile long maxAvailable;
    private static final AtomicBoolean refreshStarted;

    private static void refresh() {
        maxAvailable = Runtime.getRuntime().freeMemory();
    }

    private static void checkAndScheduleRefresh() {
        if (!refreshStarted.get()) {
            MemoryLimitCalculator.refresh();
            if (refreshStarted.compareAndSet(false, true)) {
                ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("Dubbo-Memory-Calculator"));
                scheduledExecutorService.scheduleWithFixedDelay(MemoryLimitCalculator::refresh, 50L, 50L, TimeUnit.MILLISECONDS);
                GlobalResourcesRepository.registerGlobalDisposable(() -> {
                    refreshStarted.set(false);
                    scheduledExecutorService.shutdown();
                });
            }
        }
    }

    public static long maxAvailable() {
        MemoryLimitCalculator.checkAndScheduleRefresh();
        return maxAvailable;
    }

    public static long calculate(float percentage) {
        if (percentage <= 0.0f || percentage > 1.0f) {
            throw new IllegalArgumentException();
        }
        MemoryLimitCalculator.checkAndScheduleRefresh();
        return (long)((float)MemoryLimitCalculator.maxAvailable() * percentage);
    }

    public static long defaultLimit() {
        MemoryLimitCalculator.checkAndScheduleRefresh();
        return (long)((double)MemoryLimitCalculator.maxAvailable() * 0.8);
    }

    static {
        refreshStarted = new AtomicBoolean(false);
    }
}

