/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.ssl;

import java.net.SocketAddress;
import java.util.List;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.ssl.Cert;
import org.apache.dubbo.common.ssl.CertProvider;
import org.apache.dubbo.common.ssl.ProviderCert;
import org.apache.dubbo.rpc.model.FrameworkModel;

public class CertManager {
    private final List<CertProvider> certProviders;

    public CertManager(FrameworkModel frameworkModel) {
        this.certProviders = frameworkModel.getExtensionLoader(CertProvider.class).getActivateExtensions();
    }

    public ProviderCert getProviderConnectionConfig(URL localAddress, SocketAddress remoteAddress) {
        for (CertProvider certProvider : this.certProviders) {
            ProviderCert cert;
            if (!certProvider.isSupport(localAddress) || (cert = certProvider.getProviderConnectionConfig(localAddress)) == null) continue;
            return cert;
        }
        return null;
    }

    public Cert getConsumerConnectionConfig(URL remoteAddress) {
        for (CertProvider certProvider : this.certProviders) {
            Cert cert;
            if (!certProvider.isSupport(remoteAddress) || (cert = certProvider.getConsumerConnectionConfig(remoteAddress)) == null) continue;
            return cert;
        }
        return null;
    }
}

