/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.threadpool.support;

import java.io.File;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadpool.event.ThreadPoolExhaustedEvent;
import org.apache.dubbo.common.threadpool.event.ThreadPoolExhaustedListener;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.common.utils.JVMUtil;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.model.FrameworkModel;

public class AbortPolicyWithReport
extends ThreadPoolExecutor.AbortPolicy {
    protected static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(AbortPolicyWithReport.class);
    private final String threadName;
    private final URL url;
    protected static volatile long lastPrintTime = 0L;
    private static final long TEN_MINUTES_MILLS = 600000L;
    private static final String WIN_DATETIME_FORMAT = "yyyy-MM-dd_HH-mm-ss";
    private static final String DEFAULT_DATETIME_FORMAT = "yyyy-MM-dd_HH:mm:ss";
    protected static Semaphore guard = new Semaphore(1);
    private static final String USER_HOME = System.getProperty("user.home");
    private final Set<ThreadPoolExhaustedListener> listeners = new ConcurrentHashSet<ThreadPoolExhaustedListener>();

    public AbortPolicyWithReport(String threadName, URL url) {
        this.threadName = threadName;
        this.url = url;
        String threadPoolExhaustedListeners = url.getParameter("thread-pool-exhausted-listeners", (String)url.getAttribute("thread-pool-exhausted-listeners"));
        Set<String> listenerKeys = StringUtils.splitToSet(threadPoolExhaustedListeners, ',', true);
        FrameworkModel frameworkModel = url.getOrDefaultFrameworkModel();
        ExtensionLoader<ThreadPoolExhaustedListener> extensionLoader = frameworkModel.getExtensionLoader(ThreadPoolExhaustedListener.class);
        listenerKeys.forEach(key -> {
            if (extensionLoader.hasExtension((String)key)) {
                this.addThreadPoolExhaustedEventListener((ThreadPoolExhaustedListener)extensionLoader.getExtension((String)key));
            }
        });
    }

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
        String msg = String.format("Thread pool is EXHAUSTED! Thread Name: %s, Pool Size: %d (active: %d, core: %d, max: %d, largest: %d), Task: %d (completed: %d), Executor status:(isShutdown:%s, isTerminated:%s, isTerminating:%s), in %s://%s:%d!", this.threadName, e.getPoolSize(), e.getActiveCount(), e.getCorePoolSize(), e.getMaximumPoolSize(), e.getLargestPoolSize(), e.getTaskCount(), e.getCompletedTaskCount(), e.isShutdown(), e.isTerminated(), e.isTerminating(), this.url.getProtocol(), this.url.getIp(), this.url.getPort());
        logger.warn("0-1", "too much client requesting provider", "", msg);
        if (Boolean.parseBoolean(this.url.getParameter("dump.enable", "true"))) {
            this.dumpJStack();
        }
        this.dispatchThreadPoolExhaustedEvent(msg);
        throw new RejectedExecutionException(msg);
    }

    public void addThreadPoolExhaustedEventListener(ThreadPoolExhaustedListener listener) {
        this.listeners.add(listener);
    }

    public void removeThreadPoolExhaustedEventListener(ThreadPoolExhaustedListener listener) {
        this.listeners.remove(listener);
    }

    public void dispatchThreadPoolExhaustedEvent(String msg) {
        this.listeners.forEach(listener -> listener.onEvent(new ThreadPoolExhaustedEvent(msg)));
    }

    private void dumpJStack() {
        long now = System.currentTimeMillis();
        if (now - lastPrintTime < 600000L) {
            return;
        }
        if (!guard.tryAcquire()) {
            return;
        }
        if (System.currentTimeMillis() - lastPrintTime < 600000L) {
            return;
        }
        ExecutorService pool = Executors.newSingleThreadExecutor();
        pool.execute(() -> {
            String dumpPath = this.getDumpPath();
            String os = System.getProperty("os.name").toLowerCase();
            SimpleDateFormat sdf = os.contains("win") ? new SimpleDateFormat(WIN_DATETIME_FORMAT) : new SimpleDateFormat(DEFAULT_DATETIME_FORMAT);
            String dateStr = sdf.format(new Date());
            try (FileOutputStream jStackStream = new FileOutputStream(new File(dumpPath, "Dubbo_JStack.log." + dateStr));){
                this.jstack(jStackStream);
            }
            catch (Exception t) {
                logger.error("0-20", "", "", "dump jStack error", t);
            }
            finally {
                lastPrintTime = System.currentTimeMillis();
                guard.release();
            }
        });
        pool.shutdown();
    }

    protected void jstack(FileOutputStream jStackStream) throws Exception {
        JVMUtil.jstack(jStackStream);
    }

    protected String getDumpPath() {
        String dumpPath = this.url.getParameter("dump.directory");
        if (StringUtils.isEmpty(dumpPath)) {
            return USER_HOME;
        }
        File dumpDirectory = new File(dumpPath);
        if (!dumpDirectory.exists()) {
            if (dumpDirectory.mkdirs()) {
                logger.info(String.format("Dubbo dump directory[%s] created", dumpDirectory.getAbsolutePath()));
            } else {
                logger.warn("0-20", "", "", String.format("Dubbo dump directory[%s] can't be created, use the 'user.home'[%s]", dumpDirectory.getAbsolutePath(), USER_HOME));
                return USER_HOME;
            }
        }
        return dumpPath;
    }
}

