/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.utils;

import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;

public class JsonCompatibilityUtil {
    private static final Logger logger = LoggerFactory.getLogger(JsonCompatibilityUtil.class);
    private static final Set<String> unsupportedClasses = new HashSet<String>(Arrays.asList("java.util.Optional", "java.util.Calendar", "java.util.Iterator", "java.io.InputStream", "java.io.OutputStream"));

    public static boolean checkClassCompatibility(Class<?> clazz) {
        Method[] methods;
        for (Method method : methods = clazz.getDeclaredMethods()) {
            boolean result = JsonCompatibilityUtil.checkMethodCompatibility(method);
            if (result) continue;
            return false;
        }
        return true;
    }

    public static boolean checkMethodCompatibility(Method method) {
        Type[] types = method.getGenericParameterTypes();
        ArrayList<Type> typeList = new ArrayList<Type>(Arrays.asList(types));
        Type returnType = method.getGenericReturnType();
        typeList.add(returnType);
        for (Type type : typeList) {
            boolean result = JsonCompatibilityUtil.checkType(type);
            if (result) continue;
            return false;
        }
        return true;
    }

    public static List<String> getUnsupportedMethods(Class<?> clazz) {
        Method[] methods;
        ArrayList<String> unsupportedMethods = new ArrayList<String>();
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (JsonCompatibilityUtil.checkMethodCompatibility(method)) continue;
            unsupportedMethods.add(method.getName());
        }
        return unsupportedMethods.size() > 0 ? unsupportedMethods : null;
    }

    private static boolean checkType(Type classType) {
        block11: {
            block10: {
                if (classType instanceof TypeVariable) {
                    return true;
                }
                if (!(classType instanceof ParameterizedType)) break block10;
                Type[] types = ((ParameterizedType)classType).getActualTypeArguments();
                ArrayList<Type> typeList = new ArrayList<Type>(Arrays.asList(types));
                classType = ((ParameterizedType)classType).getRawType();
                typeList.add(classType);
                for (Type type : typeList) {
                    boolean result = JsonCompatibilityUtil.checkType(type);
                    if (result) continue;
                    return false;
                }
                break block11;
            }
            if (classType instanceof GenericArrayType) {
                Type componentType = ((GenericArrayType)classType).getGenericComponentType();
                boolean result = JsonCompatibilityUtil.checkType(componentType);
                return result;
            }
            if (!(classType instanceof Class)) break block11;
            Class clazz = (Class)classType;
            String className = clazz.getName();
            if (clazz.isArray()) {
                Class<?> componentType = clazz.getComponentType();
                boolean result = JsonCompatibilityUtil.checkType(componentType);
                return result;
            }
            if (clazz.isPrimitive()) {
                return !unsupportedClasses.contains(className);
            }
            if (className.startsWith("java") || className.startsWith("javax")) {
                return !unsupportedClasses.contains(className);
            }
            if (clazz.isInterface()) {
                return false;
            }
            if (Modifier.isAbstract(clazz.getModifiers())) {
                return false;
            }
            if (clazz.isEnum()) {
                return true;
            }
            for (Field field : clazz.getDeclaredFields()) {
                Type type = field.getGenericType();
                Class<?> fieldClass = field.getType();
                boolean result = JsonCompatibilityUtil.checkType(type);
                if (result) continue;
                return false;
            }
        }
        return true;
    }
}

