/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.utils;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.common.utils.JsonUtils;
import org.apache.dubbo.config.AbstractConfig;

public class ToStringUtils {
    private ToStringUtils() {
    }

    public static String printToString(Object obj) {
        if (obj == null) {
            return "null";
        }
        try {
            return JsonUtils.toJson(obj);
        }
        catch (Throwable throwable) {
            if (obj instanceof Object[]) {
                return Arrays.toString((Object[])obj);
            }
            return obj.toString();
        }
    }

    public static String toString(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (ClassUtils.isSimpleType(obj.getClass())) {
            return obj.toString();
        }
        if (obj.getClass().isPrimitive()) {
            return obj.toString();
        }
        if (obj instanceof Object[]) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[");
            Object[] objects = (Object[])obj;
            for (int i = 0; i < objects.length; ++i) {
                stringBuilder.append(ToStringUtils.toString(objects[i]));
                if (i == objects.length - 1) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
        if (obj instanceof List) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[");
            List list = (List)obj;
            for (int i = 0; i < list.size(); ++i) {
                stringBuilder.append(ToStringUtils.toString(list.get(i)));
                if (i == list.size() - 1) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
        if (obj instanceof Map) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("{");
            Map map = (Map)obj;
            int i = 0;
            for (Object key : map.keySet()) {
                stringBuilder.append(ToStringUtils.toString(key));
                stringBuilder.append("=");
                stringBuilder.append(ToStringUtils.toString(map.get(key)));
                if (i != map.size() - 1) {
                    stringBuilder.append(", ");
                }
                ++i;
            }
            stringBuilder.append("}");
            return stringBuilder.toString();
        }
        if (obj instanceof AbstractConfig) {
            return obj.toString();
        }
        return obj.getClass() + "@" + Integer.toHexString(System.identityHashCode(obj));
    }
}

