/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.model;

import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.extension.SPI;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ScopeModel;

public class ScopeModelUtil {
    public static <T> ScopeModel getOrDefault(ScopeModel scopeModel, Class<T> type) {
        if (scopeModel != null) {
            return scopeModel;
        }
        return ScopeModelUtil.getDefaultScopeModel(type);
    }

    private static <T> ScopeModel getDefaultScopeModel(Class<T> type) {
        SPI spi = type.getAnnotation(SPI.class);
        if (spi == null) {
            throw new IllegalArgumentException("SPI annotation not found for class: " + type.getName());
        }
        switch (spi.scope()) {
            case FRAMEWORK: {
                return FrameworkModel.defaultModel();
            }
            case APPLICATION: {
                return ApplicationModel.defaultModel();
            }
            case MODULE: {
                return ApplicationModel.defaultModel().getDefaultModule();
            }
        }
        throw new IllegalStateException("Unable to get default scope model for type: " + type.getName());
    }

    public static ModuleModel getModuleModel(ScopeModel scopeModel) {
        if (scopeModel == null) {
            return ApplicationModel.defaultModel().getDefaultModule();
        }
        if (scopeModel instanceof ModuleModel) {
            return (ModuleModel)scopeModel;
        }
        throw new IllegalArgumentException("Unable to get ModuleModel from " + scopeModel);
    }

    public static ApplicationModel getApplicationModel(ScopeModel scopeModel) {
        return ScopeModelUtil.getOrDefaultApplicationModel(scopeModel);
    }

    public static ApplicationModel getOrDefaultApplicationModel(ScopeModel scopeModel) {
        if (scopeModel == null) {
            return ApplicationModel.defaultModel();
        }
        return ScopeModelUtil.getOrNullApplicationModel(scopeModel);
    }

    public static ApplicationModel getOrNullApplicationModel(ScopeModel scopeModel) {
        if (scopeModel == null) {
            return null;
        }
        if (scopeModel instanceof ApplicationModel) {
            return (ApplicationModel)scopeModel;
        }
        if (scopeModel instanceof ModuleModel) {
            ModuleModel moduleModel = (ModuleModel)scopeModel;
            return moduleModel.getApplicationModel();
        }
        throw new IllegalArgumentException("Unable to get ApplicationModel from " + scopeModel);
    }

    public static FrameworkModel getFrameworkModel(ScopeModel scopeModel) {
        if (scopeModel == null) {
            return FrameworkModel.defaultModel();
        }
        if (scopeModel instanceof ApplicationModel) {
            return ((ApplicationModel)scopeModel).getFrameworkModel();
        }
        if (scopeModel instanceof ModuleModel) {
            ModuleModel moduleModel = (ModuleModel)scopeModel;
            return moduleModel.getApplicationModel().getFrameworkModel();
        }
        if (scopeModel instanceof FrameworkModel) {
            return (FrameworkModel)scopeModel;
        }
        throw new IllegalArgumentException("Unable to get FrameworkModel from " + scopeModel);
    }

    public static <T> ExtensionLoader<T> getExtensionLoader(Class<T> type, ScopeModel scopeModel) {
        if (scopeModel != null) {
            return scopeModel.getExtensionLoader(type);
        }
        SPI spi = type.getAnnotation(SPI.class);
        if (spi == null) {
            throw new IllegalArgumentException("SPI annotation not found for class: " + type.getName());
        }
        switch (spi.scope()) {
            case FRAMEWORK: {
                return FrameworkModel.defaultModel().getExtensionLoader(type);
            }
            case APPLICATION: {
                return ApplicationModel.defaultModel().getExtensionLoader(type);
            }
            case MODULE: {
                return ApplicationModel.defaultModel().getDefaultModule().getExtensionLoader(type);
            }
        }
        throw new IllegalArgumentException("Unable to get ExtensionLoader for type: " + type.getName());
    }
}

