/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.utils;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.json.JsonUtil;
import org.apache.dubbo.common.json.impl.AbstractJsonUtilImpl;
import org.apache.dubbo.common.json.impl.FastJson2Impl;
import org.apache.dubbo.common.json.impl.FastJsonImpl;
import org.apache.dubbo.common.json.impl.GsonImpl;
import org.apache.dubbo.common.json.impl.JacksonImpl;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.common.utils.SystemPropertyConfigUtils;

public class JsonUtils {
    private static volatile JsonUtil jsonUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static JsonUtil getJson() {
        if (jsonUtil != null) return jsonUtil;
        Class<JsonUtils> clazz = JsonUtils.class;
        synchronized (JsonUtils.class) {
            if (jsonUtil != null) return jsonUtil;
            String preferJsonFrameworkName = SystemPropertyConfigUtils.getSystemProperty("dubbo.json-framework.prefer");
            if (StringUtils.isNotEmpty(preferJsonFrameworkName)) {
                try {
                    AbstractJsonUtilImpl instance = null;
                    switch (preferJsonFrameworkName) {
                        case "fastjson2": {
                            instance = new FastJson2Impl();
                            break;
                        }
                        case "fastjson": {
                            instance = new FastJsonImpl();
                            break;
                        }
                        case "gson": {
                            instance = new GsonImpl();
                            break;
                        }
                        case "jackson": {
                            instance = new JacksonImpl();
                            break;
                        }
                    }
                    if (instance != null && instance.isSupport()) {
                        jsonUtil = instance;
                    }
                }
                catch (Throwable instance) {
                    // empty catch block
                }
            }
            if (jsonUtil == null) {
                List<Class> jsonClasses = Arrays.asList(FastJson2Impl.class, FastJsonImpl.class, GsonImpl.class, JacksonImpl.class);
                for (Class jsonClass : jsonClasses) {
                    try {
                        JsonUtil instance = (JsonUtil)jsonClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                        if (!instance.isSupport()) continue;
                        jsonUtil = instance;
                        break;
                    }
                    catch (Throwable throwable) {
                    }
                }
            }
            if (jsonUtil != null) return jsonUtil;
            throw new IllegalStateException("Dubbo unable to find out any json framework (e.g. fastjson2, fastjson, gson, jackson) from jvm env. Please import at least one json framework.");
        }
    }

    @Deprecated
    protected static void setJson(JsonUtil json) {
        jsonUtil = json;
    }

    public static <T> T toJavaObject(String json, Type type) {
        return JsonUtils.getJson().toJavaObject(json, type);
    }

    public static <T> List<T> toJavaList(String json, Class<T> clazz) {
        return JsonUtils.getJson().toJavaList(json, clazz);
    }

    public static String toJson(Object obj) {
        return JsonUtils.getJson().toJson(obj);
    }

    public static List<?> getList(Map<String, ?> obj, String key) {
        return JsonUtils.getJson().getList(obj, key);
    }

    public static List<Map<String, ?>> getListOfObjects(Map<String, ?> obj, String key) {
        return JsonUtils.getJson().getListOfObjects(obj, key);
    }

    public static List<String> getListOfStrings(Map<String, ?> obj, String key) {
        return JsonUtils.getJson().getListOfStrings(obj, key);
    }

    public static Map<String, ?> getObject(Map<String, ?> obj, String key) {
        return JsonUtils.getJson().getObject(obj, key);
    }

    public static Object convertObject(Object obj, Type targetType) {
        return JsonUtils.getJson().convertObject(obj, targetType);
    }

    public static Object convertObject(Object obj, Class<?> targetType) {
        return JsonUtils.getJson().convertObject(obj, targetType);
    }

    public static Double getNumberAsDouble(Map<String, ?> obj, String key) {
        return JsonUtils.getJson().getNumberAsDouble(obj, key);
    }

    public static Integer getNumberAsInteger(Map<String, ?> obj, String key) {
        return JsonUtils.getJson().getNumberAsInteger(obj, key);
    }

    public static Long getNumberAsLong(Map<String, ?> obj, String key) {
        return JsonUtils.getJson().getNumberAsLong(obj, key);
    }

    public static String getString(Map<String, ?> obj, String key) {
        return JsonUtils.getJson().getString(obj, key);
    }

    public static List<Map<String, ?>> checkObjectList(List<?> rawList) {
        return JsonUtils.getJson().checkObjectList(rawList);
    }

    public static List<String> checkStringList(List<?> rawList) {
        return JsonUtils.getJson().checkStringList(rawList);
    }

    public static boolean checkJson(String json) {
        return JsonUtils.getJson().isJson(json);
    }
}

