/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.context;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.dubbo.common.config.CompositeConfiguration;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.config.Environment;
import org.apache.dubbo.common.config.PropertiesConfiguration;
import org.apache.dubbo.common.context.LifecycleAdapter;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.MetadataReportConfig;
import org.apache.dubbo.config.MetricsConfig;
import org.apache.dubbo.config.ModuleConfig;
import org.apache.dubbo.config.MonitorConfig;
import org.apache.dubbo.config.ReferenceConfigBase;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.ServiceConfigBase;
import org.apache.dubbo.config.SslConfig;
import org.apache.dubbo.config.TracingConfig;
import org.apache.dubbo.config.context.ConfigMode;
import org.apache.dubbo.config.context.ConfigValidator;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.model.ScopeModelUtil;

public abstract class AbstractConfigManager
extends LifecycleAdapter {
    private static final String CONFIG_NAME_READ_METHOD = "getName";
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(AbstractConfigManager.class);
    private static final Set<Class<? extends AbstractConfig>> uniqueConfigTypes = new ConcurrentHashSet<Class<? extends AbstractConfig>>();
    final Map<String, Map<String, AbstractConfig>> configsCache = new ConcurrentHashMap<String, Map<String, AbstractConfig>>();
    private final Map<String, AtomicInteger> configIdIndexes = new ConcurrentHashMap<String, AtomicInteger>();
    protected Set<AbstractConfig> duplicatedConfigs = new ConcurrentHashSet<AbstractConfig>();
    protected final ScopeModel scopeModel;
    protected final ApplicationModel applicationModel;
    private final Collection<Class<? extends AbstractConfig>> supportedConfigTypes;
    private final Environment environment;
    private ConfigValidator configValidator;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    protected ConfigMode configMode = ConfigMode.STRICT;
    protected boolean ignoreDuplicatedInterface = false;

    public AbstractConfigManager(ScopeModel scopeModel, Collection<Class<? extends AbstractConfig>> supportedConfigTypes) {
        this.scopeModel = scopeModel;
        this.applicationModel = ScopeModelUtil.getApplicationModel(scopeModel);
        this.supportedConfigTypes = supportedConfigTypes;
        this.environment = scopeModel.modelEnvironment();
    }

    @Override
    public void initialize() throws IllegalStateException {
        if (!this.initialized.compareAndSet(false, true)) {
            return;
        }
        CompositeConfiguration configuration = this.scopeModel.modelEnvironment().getConfiguration();
        String configModeStr = (String)configuration.getProperty("dubbo.config.mode");
        try {
            if (StringUtils.hasText(configModeStr)) {
                this.configMode = ConfigMode.valueOf(configModeStr.toUpperCase());
            }
        }
        catch (Exception e) {
            String msg = "Illegal 'dubbo.config.mode' config value [" + configModeStr + "], available values " + Arrays.toString((Object[])ConfigMode.values());
            logger.error("0-2", "", "", msg, e);
            throw new IllegalArgumentException(msg, e);
        }
        String ignoreDuplicatedInterfaceStr = (String)configuration.getProperty("dubbo.config.ignore-duplicated-interface");
        if (ignoreDuplicatedInterfaceStr != null) {
            this.ignoreDuplicatedInterface = Boolean.parseBoolean(ignoreDuplicatedInterfaceStr);
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("dubbo.config.mode", (Object)this.configMode);
        map.put("dubbo.config.ignore-duplicated-interface", this.ignoreDuplicatedInterface);
        logger.info("Config settings: " + map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T extends AbstractConfig> T addConfig(AbstractConfig config) {
        if (config == null) {
            return null;
        }
        if (!this.isSupportConfigType(config.getClass())) {
            throw new IllegalArgumentException("Unsupported config type: " + config);
        }
        if (config.getScopeModel() != this.scopeModel) {
            config.setScopeModel(this.scopeModel);
        }
        Map configsMap = this.configsCache.computeIfAbsent(AbstractConfig.getTagName(config.getClass()), type -> new ConcurrentHashMap());
        if (!(config instanceof ReferenceConfigBase) && !(config instanceof ServiceConfigBase)) {
            for (AbstractConfig value : configsMap.values()) {
                if (!value.equals(config)) continue;
                return (T)value;
            }
        }
        Map map = configsMap;
        synchronized (map) {
            return (T)this.addIfAbsent(config, configsMap);
        }
    }

    protected boolean isSupportConfigType(Class<? extends AbstractConfig> type) {
        for (Class<? extends AbstractConfig> supportedConfigType : this.supportedConfigTypes) {
            if (!supportedConfigType.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    private <C extends AbstractConfig> C addIfAbsent(C config, Map<String, C> configsMap) throws IllegalStateException {
        AbstractConfig existedConfig;
        if (config == null || configsMap == null) {
            return config;
        }
        Optional<C> prevConfig = this.findDuplicatedConfig(configsMap, config);
        if (prevConfig.isPresent()) {
            return (C)((AbstractConfig)prevConfig.get());
        }
        String key = config.getId();
        if (key == null) {
            while (configsMap.containsKey(key = this.generateConfigId(config))) {
            }
        }
        if ((existedConfig = (AbstractConfig)configsMap.get(key)) != null && !this.isEquals(existedConfig, config)) {
            String type = config.getClass().getSimpleName();
            logger.warn("0-12", "", "", String.format("Duplicate %s found, there already has one default %s or more than two %ss have the same id, you can try to give each %s a different id, override previous config with later config. id: %s, prev: %s, later: %s", type, type, type, type, key, existedConfig, config));
        }
        configsMap.put(key, config);
        return config;
    }

    protected <C extends AbstractConfig> boolean removeIfAbsent(C config, Map<String, C> configsMap) {
        if (config.getId() != null) {
            return configsMap.remove(config.getId(), config);
        }
        return configsMap.values().removeIf(c -> config == c);
    }

    protected boolean isUniqueConfig(AbstractConfig config) {
        if (uniqueConfigTypes.contains(config.getClass())) {
            return true;
        }
        for (Class<? extends AbstractConfig> uniqueConfigType : uniqueConfigTypes) {
            if (!uniqueConfigType.isAssignableFrom(config.getClass())) continue;
            return true;
        }
        return false;
    }

    protected <C extends AbstractConfig> C getSingleConfig(String configType) throws IllegalStateException {
        Map<String, C> configsMap = this.getConfigsMap(configType);
        int size = configsMap.size();
        if (size < 1) {
            return null;
        }
        if (size > 1) {
            throw new IllegalStateException("Expected single instance of " + configType + ", but found " + size + " instances, please remove redundant configs. instances: " + configsMap.values());
        }
        return (C)((AbstractConfig)configsMap.values().iterator().next());
    }

    protected <C extends AbstractConfig> Optional<C> findDuplicatedConfig(Map<String, C> configsMap, C config) {
        Optional<C> prevConfig = this.findConfigByValue(configsMap.values(), config);
        if (prevConfig.isPresent()) {
            if (prevConfig.get() == config) {
                return prevConfig;
            }
            if (logger.isInfoEnabled() && this.duplicatedConfigs.add(config)) {
                logger.info("Ignore duplicated config: " + config);
            }
            return prevConfig;
        }
        return this.checkUniqueConfig(configsMap, config);
    }

    public <C extends AbstractConfig> Map<String, C> getConfigsMap(Class<C> cls) {
        return this.getConfigsMap(AbstractConfig.getTagName(cls));
    }

    protected <C extends AbstractConfig> Map<String, C> getConfigsMap(String configType) {
        return this.configsCache.getOrDefault(configType, Collections.emptyMap());
    }

    protected <C extends AbstractConfig> Collection<C> getConfigs(String configType) {
        return this.getConfigsMap(configType).values();
    }

    public <C extends AbstractConfig> Collection<C> getConfigs(Class<C> configType) {
        return this.getConfigsMap(AbstractConfig.getTagName(configType)).values();
    }

    protected <C extends AbstractConfig> C getConfigById(String configType, String id) {
        return (C)((AbstractConfig)this.getConfigsMap(configType).get(id));
    }

    public <T extends AbstractConfig> Optional<T> getConfig(Class<T> cls, String idOrName) {
        Object config = this.getConfigById(AbstractConfig.getTagName(cls), idOrName);
        if (config == null) {
            config = this.getConfigByName(cls, idOrName);
        }
        return Optional.ofNullable(config);
    }

    protected <C extends AbstractConfig> C getConfigByName(Class<? extends C> cls, String name) {
        Map<String, C> configsMap = this.getConfigsMap(cls);
        if (configsMap.isEmpty()) {
            return null;
        }
        if (ReflectUtils.hasMethod(cls, CONFIG_NAME_READ_METHOD)) {
            List list = configsMap.values().stream().filter(cfg -> name.equals(this.getConfigName(cfg))).collect(Collectors.toList());
            if (list.size() > 1) {
                throw new IllegalStateException("Found more than one config by name: " + name + ", instances: " + list + ". Please remove redundant configs or get config by id.");
            }
            if (list.size() == 1) {
                return (C)((AbstractConfig)list.get(0));
            }
        }
        return null;
    }

    private <C extends AbstractConfig> String getConfigName(C config) {
        try {
            return (String)ReflectUtils.getProperty(config, CONFIG_NAME_READ_METHOD);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected <C extends AbstractConfig> Optional<C> findConfigByValue(Collection<C> values, C config) {
        Optional<AbstractConfig> prevConfig = values.stream().filter(val -> val == config).findFirst();
        if (prevConfig.isPresent()) {
            return prevConfig;
        }
        prevConfig = values.stream().filter(val -> this.isEquals((AbstractConfig)val, config)).findFirst();
        return prevConfig;
    }

    protected boolean isEquals(AbstractConfig oldOne, AbstractConfig newOne) {
        if (oldOne == newOne) {
            return true;
        }
        if (oldOne == null || newOne == null) {
            return false;
        }
        if (oldOne.getClass() != newOne.getClass()) {
            return false;
        }
        if (oldOne.isRefreshed() || newOne.isRefreshed()) {
            if (!oldOne.isRefreshed()) {
                oldOne.refresh();
            }
            if (!newOne.isRefreshed()) {
                newOne.refresh();
            }
        }
        return oldOne.equals(newOne);
    }

    protected <C extends AbstractConfig> String generateConfigId(C config) {
        String tagName = AbstractConfig.getTagName(config.getClass());
        int idx = this.configIdIndexes.computeIfAbsent(tagName, clazz -> new AtomicInteger(0)).incrementAndGet();
        return tagName + "#" + idx;
    }

    public <C extends AbstractConfig> List<C> getDefaultConfigs(Class<C> cls) {
        return AbstractConfigManager.getDefaultConfigs(this.getConfigsMap(AbstractConfig.getTagName(cls)));
    }

    static <C extends AbstractConfig> Boolean isDefaultConfig(C config) {
        return config.isDefault();
    }

    static <C extends AbstractConfig> List<C> getDefaultConfigs(Map<String, C> configsMap) {
        List list = configsMap.values().stream().filter(c -> Boolean.TRUE.equals(AbstractConfigManager.isDefaultConfig(c))).collect(Collectors.toList());
        if (!list.isEmpty()) {
            return list;
        }
        list = configsMap.values().stream().filter(c -> AbstractConfigManager.isDefaultConfig(c) == null).collect(Collectors.toList());
        return list;
    }

    protected <C extends AbstractConfig> Optional<C> checkUniqueConfig(Map<String, C> configsMap, C config) {
        if (configsMap.size() > 0 && this.isUniqueConfig(config)) {
            AbstractConfig oldOne = (AbstractConfig)configsMap.values().iterator().next();
            String configName = oldOne.getClass().getSimpleName();
            String msgPrefix = "Duplicate Configs found for " + configName + ", only one unique " + configName + " is allowed for one application. previous: " + oldOne + ", later: " + config + ". According to config mode [" + (Object)((Object)this.configMode) + "], ";
            switch (this.configMode) {
                case STRICT: {
                    if (this.isEquals(oldOne, config)) break;
                    throw new IllegalStateException(msgPrefix + "please remove redundant configs and keep only one.");
                }
                case IGNORE: {
                    if (logger.isWarnEnabled() && this.duplicatedConfigs.add(config)) {
                        logger.warn("0-12", "", "", msgPrefix + "keep previous config and ignore later config");
                    }
                    return Optional.of(oldOne);
                }
                case OVERRIDE: {
                    configsMap.clear();
                    if (!logger.isWarnEnabled() || !this.duplicatedConfigs.add(config)) break;
                    logger.warn("0-12", "", "", msgPrefix + "override previous config with later config");
                    break;
                }
                case OVERRIDE_ALL: {
                    oldOne.overrideWithConfig(config, true);
                    if (logger.isWarnEnabled() && this.duplicatedConfigs.add(config)) {
                        logger.warn("0-12", "", "", msgPrefix + "override previous config with later config");
                    }
                    return Optional.of(oldOne);
                }
                case OVERRIDE_IF_ABSENT: {
                    oldOne.overrideWithConfig(config, false);
                    if (logger.isWarnEnabled() && this.duplicatedConfigs.add(config)) {
                        logger.warn("0-12", "", "", msgPrefix + "override previous config with later config");
                    }
                    return Optional.of(oldOne);
                }
            }
        }
        return Optional.empty();
    }

    public abstract void loadConfigs();

    public <T extends AbstractConfig> List<T> loadConfigsOfTypeFromProps(Class<T> cls) {
        List configurationMaps;
        ArrayList tmpConfigs = new ArrayList();
        PropertiesConfiguration properties = this.environment.getPropertiesConfiguration();
        Set<String> configIds = this.getConfigIdsFromProps(cls);
        configIds.forEach(id -> {
            block9: {
                if (!this.getConfig(cls, (String)id).isPresent()) {
                    Object config;
                    try {
                        config = this.createConfig(cls, this.scopeModel);
                        ((AbstractConfig)config).setId((String)id);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("create config instance failed, id: " + id + ", type:" + cls.getSimpleName());
                    }
                    String key = null;
                    boolean addDefaultNameConfig = false;
                    try {
                        key = "dubbo." + AbstractConfig.getPluralTagName(cls) + "." + id + ".name";
                        if (properties.getProperty(key) == null) {
                            properties.setProperty(key, (String)id);
                            addDefaultNameConfig = true;
                        }
                        ((AbstractConfig)config).refresh();
                        this.addConfig((AbstractConfig)config);
                        tmpConfigs.add(config);
                        if (!addDefaultNameConfig || key == null) break block9;
                        properties.remove(key);
                    }
                    catch (Exception e) {
                        try {
                            logger.error("0-2", "", "", "load config failed, id: " + id + ", type:" + cls.getSimpleName(), e);
                            throw new IllegalStateException("load config failed, id: " + id + ", type:" + cls.getSimpleName());
                        }
                        catch (Throwable throwable) {
                            if (addDefaultNameConfig && key != null) {
                                properties.remove(key);
                            }
                            throw throwable;
                        }
                    }
                }
            }
        });
        if (this.getConfigs(cls).isEmpty() && ConfigurationUtils.hasSubProperties(configurationMaps = this.environment.getConfigurationMaps(), AbstractConfig.getTypePrefix(cls))) {
            T config;
            try {
                config = this.createConfig(cls, this.scopeModel);
                ((AbstractConfig)config).refresh();
            }
            catch (Exception e) {
                throw new IllegalStateException("create default config instance failed, type:" + cls.getSimpleName());
            }
            this.addConfig((AbstractConfig)config);
            tmpConfigs.add(config);
        }
        return tmpConfigs;
    }

    private <T extends AbstractConfig> T createConfig(Class<T> cls, ScopeModel scopeModel) throws ReflectiveOperationException {
        AbstractConfig config = (AbstractConfig)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        config.setScopeModel(scopeModel);
        return (T)config;
    }

    private Set<String> getConfigIdsFromProps(Class<? extends AbstractConfig> clazz) {
        String prefix = "dubbo." + AbstractConfig.getPluralTagName(clazz) + ".";
        return ConfigurationUtils.getSubIds(this.environment.getConfigurationMaps(), prefix);
    }

    protected <T extends AbstractConfig> void checkDefaultAndValidateConfigs(Class<T> configType) {
        try {
            if (this.shouldAddDefaultConfig(configType)) {
                T config = this.createConfig(configType, this.scopeModel);
                ((AbstractConfig)config).refresh();
                if (!this.isNeedValidation(config) || ((AbstractConfig)config).isValid()) {
                    this.addConfig((AbstractConfig)config);
                } else {
                    logger.info("Ignore invalid config: " + config);
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Add default config failed: " + configType.getSimpleName(), e);
        }
        Collection<T> configs = this.getConfigs(configType);
        if (this.getConfigValidator() != null) {
            for (AbstractConfig config : configs) {
                this.getConfigValidator().validate(config);
            }
        }
        if (this.isRequired(configType) && configs.isEmpty()) {
            throw new IllegalStateException("Default config not found for " + configType.getSimpleName());
        }
    }

    protected <T extends AbstractConfig> boolean isNeedValidation(T config) {
        return !(config instanceof MetadataReportConfig);
    }

    private ConfigValidator getConfigValidator() {
        if (this.configValidator == null) {
            this.configValidator = this.applicationModel.getBeanFactory().getBean(ConfigValidator.class);
        }
        return this.configValidator;
    }

    protected <T extends AbstractConfig> boolean isRequired(Class<T> clazz) {
        return clazz != RegistryConfig.class && clazz != MetadataReportConfig.class && clazz != MonitorConfig.class && clazz != MetricsConfig.class && clazz != TracingConfig.class;
    }

    private <T extends AbstractConfig> boolean shouldAddDefaultConfig(Class<T> clazz) {
        if (!this.isRequired(clazz)) {
            return false;
        }
        return this.getDefaultConfigs(clazz).isEmpty();
    }

    public void refreshAll() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeConfig(AbstractConfig config) {
        if (config == null) {
            return false;
        }
        Map<String, AbstractConfig> configs = this.configsCache.get(AbstractConfig.getTagName(config.getClass()));
        if (CollectionUtils.isNotEmptyMap(configs)) {
            Map<String, AbstractConfig> map = configs;
            synchronized (map) {
                return this.removeIfAbsent(config, configs);
            }
        }
        return false;
    }

    @Override
    public void destroy() throws IllegalStateException {
        this.clear();
    }

    public void clear() {
        this.configsCache.clear();
        this.configIdIndexes.clear();
        this.duplicatedConfigs.clear();
    }

    public boolean isInitialized() {
        return this.initialized.get();
    }

    static {
        uniqueConfigTypes.add(ApplicationConfig.class);
        uniqueConfigTypes.add(MonitorConfig.class);
        uniqueConfigTypes.add(MetricsConfig.class);
        uniqueConfigTypes.add(TracingConfig.class);
        uniqueConfigTypes.add(SslConfig.class);
        uniqueConfigTypes.add(ModuleConfig.class);
    }
}

