/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.context;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.context.ApplicationExt;
import org.apache.dubbo.common.extension.DisableInject;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ConfigCenterConfig;
import org.apache.dubbo.config.MetadataReportConfig;
import org.apache.dubbo.config.MetricsConfig;
import org.apache.dubbo.config.MonitorConfig;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.SslConfig;
import org.apache.dubbo.config.TracingConfig;
import org.apache.dubbo.config.context.AbstractConfigManager;
import org.apache.dubbo.config.context.ConfigMode;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class ConfigManager
extends AbstractConfigManager
implements ApplicationExt {
    private static final Logger logger = LoggerFactory.getLogger(ConfigManager.class);
    public static final String NAME = "config";
    public static final String BEAN_NAME = "dubboConfigManager";
    public static final String DUBBO_CONFIG_MODE = "dubbo.config.mode";

    public ConfigManager(ApplicationModel applicationModel) {
        super(applicationModel, Arrays.asList(ApplicationConfig.class, MonitorConfig.class, MetricsConfig.class, SslConfig.class, ProtocolConfig.class, RegistryConfig.class, ConfigCenterConfig.class, MetadataReportConfig.class, TracingConfig.class));
    }

    public static ProtocolConfig getProtocol(URL url) {
        return url.getOrDefaultApplicationModel().getApplicationConfigManager().getOrAddProtocol(url.getProtocol());
    }

    @DisableInject
    public void setApplication(ApplicationConfig application) {
        this.addConfig(application);
    }

    public Optional<ApplicationConfig> getApplication() {
        return Optional.ofNullable((ApplicationConfig)this.getSingleConfig(AbstractConfig.getTagName(ApplicationConfig.class)));
    }

    public ApplicationConfig getApplicationOrElseThrow() {
        return this.getApplication().orElseThrow(() -> new IllegalStateException("There's no ApplicationConfig specified."));
    }

    @DisableInject
    public void setMonitor(MonitorConfig monitor) {
        this.addConfig(monitor);
    }

    public Optional<MonitorConfig> getMonitor() {
        return Optional.ofNullable((MonitorConfig)this.getSingleConfig(AbstractConfig.getTagName(MonitorConfig.class)));
    }

    @DisableInject
    public void setMetrics(MetricsConfig metrics) {
        this.addConfig(metrics);
    }

    public Optional<MetricsConfig> getMetrics() {
        return Optional.ofNullable((MetricsConfig)this.getSingleConfig(AbstractConfig.getTagName(MetricsConfig.class)));
    }

    @DisableInject
    public void setTracing(TracingConfig tracing) {
        this.addConfig(tracing);
    }

    public Optional<TracingConfig> getTracing() {
        return Optional.ofNullable((TracingConfig)this.getSingleConfig(AbstractConfig.getTagName(TracingConfig.class)));
    }

    @DisableInject
    public void setSsl(SslConfig sslConfig) {
        this.addConfig(sslConfig);
    }

    public Optional<SslConfig> getSsl() {
        return Optional.ofNullable((SslConfig)this.getSingleConfig(AbstractConfig.getTagName(SslConfig.class)));
    }

    public void addConfigCenter(ConfigCenterConfig configCenter) {
        this.addConfig(configCenter);
    }

    public void addConfigCenters(Iterable<ConfigCenterConfig> configCenters) {
        configCenters.forEach(this::addConfigCenter);
    }

    public Optional<Collection<ConfigCenterConfig>> getDefaultConfigCenter() {
        Collection<Object> defaults = ConfigManager.getDefaultConfigs(this.getConfigsMap(AbstractConfig.getTagName(ConfigCenterConfig.class)));
        if (CollectionUtils.isEmpty(defaults)) {
            defaults = this.getConfigCenters();
        }
        return Optional.ofNullable(defaults);
    }

    public Optional<ConfigCenterConfig> getConfigCenter(String id) {
        return this.getConfig(ConfigCenterConfig.class, id);
    }

    public Collection<ConfigCenterConfig> getConfigCenters() {
        return this.getConfigs(AbstractConfig.getTagName(ConfigCenterConfig.class));
    }

    public void addMetadataReport(MetadataReportConfig metadataReportConfig) {
        this.addConfig(metadataReportConfig);
    }

    public void addMetadataReports(Iterable<MetadataReportConfig> metadataReportConfigs) {
        metadataReportConfigs.forEach(this::addMetadataReport);
    }

    public Collection<MetadataReportConfig> getMetadataConfigs() {
        return this.getConfigs(AbstractConfig.getTagName(MetadataReportConfig.class));
    }

    public Collection<MetadataReportConfig> getDefaultMetadataConfigs() {
        List<MetadataReportConfig> defaults = ConfigManager.getDefaultConfigs(this.getConfigsMap(AbstractConfig.getTagName(MetadataReportConfig.class)));
        if (CollectionUtils.isEmpty(defaults)) {
            return this.getMetadataConfigs();
        }
        return defaults;
    }

    public void addProtocol(ProtocolConfig protocolConfig) {
        this.addConfig(protocolConfig);
    }

    public void addProtocols(Iterable<ProtocolConfig> protocolConfigs) {
        if (protocolConfigs != null) {
            protocolConfigs.forEach(this::addProtocol);
        }
    }

    public Optional<ProtocolConfig> getProtocol(String idOrName) {
        return this.getConfig(ProtocolConfig.class, idOrName);
    }

    public ProtocolConfig getOrAddProtocol(String idOrName) {
        Optional<ProtocolConfig> protocol = this.getProtocol(idOrName);
        if (protocol.isPresent()) {
            return protocol.get();
        }
        ProtocolConfig protocolConfig = new ProtocolConfig(idOrName);
        this.addProtocol(protocolConfig);
        if (!protocolConfig.isRefreshed()) {
            protocolConfig.refresh();
        }
        return protocolConfig;
    }

    public List<ProtocolConfig> getDefaultProtocols() {
        return this.getDefaultConfigs(ProtocolConfig.class);
    }

    @Override
    public <C extends AbstractConfig> List<C> getDefaultConfigs(Class<C> cls) {
        return ConfigManager.getDefaultConfigs(this.getConfigsMap(AbstractConfig.getTagName(cls)));
    }

    public Collection<ProtocolConfig> getProtocols() {
        return this.getConfigs(AbstractConfig.getTagName(ProtocolConfig.class));
    }

    public void addRegistry(RegistryConfig registryConfig) {
        this.addConfig(registryConfig);
    }

    public void addRegistries(Iterable<RegistryConfig> registryConfigs) {
        if (registryConfigs != null) {
            registryConfigs.forEach(this::addRegistry);
        }
    }

    public Optional<RegistryConfig> getRegistry(String id) {
        return this.getConfig(RegistryConfig.class, id);
    }

    public List<RegistryConfig> getDefaultRegistries() {
        return ConfigManager.getDefaultConfigs(this.getConfigsMap(AbstractConfig.getTagName(RegistryConfig.class)));
    }

    public Collection<RegistryConfig> getRegistries() {
        return this.getConfigs(AbstractConfig.getTagName(RegistryConfig.class));
    }

    @Override
    public void refreshAll() {
        this.getApplication().ifPresent(ApplicationConfig::refresh);
        this.getMonitor().ifPresent(AbstractConfig::refresh);
        this.getMetrics().ifPresent(AbstractConfig::refresh);
        this.getTracing().ifPresent(AbstractConfig::refresh);
        this.getSsl().ifPresent(AbstractConfig::refresh);
        this.getProtocols().forEach(AbstractConfig::refresh);
        this.getRegistries().forEach(AbstractConfig::refresh);
        this.getConfigCenters().forEach(AbstractConfig::refresh);
        this.getMetadataConfigs().forEach(AbstractConfig::refresh);
    }

    @Override
    public void loadConfigs() {
        this.loadConfigsOfTypeFromProps(ApplicationConfig.class);
        this.loadConfigsOfTypeFromProps(MonitorConfig.class);
        this.loadConfigsOfTypeFromProps(MetricsConfig.class);
        this.loadConfigsOfTypeFromProps(TracingConfig.class);
        this.loadConfigsOfTypeFromProps(ProtocolConfig.class);
        this.loadConfigsOfTypeFromProps(RegistryConfig.class);
        this.loadConfigsOfTypeFromProps(MetadataReportConfig.class);
        this.refreshAll();
        this.checkConfigs();
        if (StringUtils.isBlank(this.applicationModel.getModelName())) {
            this.applicationModel.setModelName(this.applicationModel.getApplicationName());
        }
    }

    private void checkConfigs() {
        List<Class> multipleConfigTypes = Arrays.asList(ApplicationConfig.class, ProtocolConfig.class, RegistryConfig.class, MonitorConfig.class, MetricsConfig.class, TracingConfig.class, SslConfig.class);
        for (Class configType : multipleConfigTypes) {
            this.checkDefaultAndValidateConfigs(configType);
        }
        LinkedHashMap<Integer, ProtocolConfig> protocolPortMap = new LinkedHashMap<Integer, ProtocolConfig>();
        for (ProtocolConfig protocol : this.getProtocols()) {
            Integer port = protocol.getPort();
            if (port == null || port == -1) continue;
            ProtocolConfig prevProtocol = (ProtocolConfig)protocolPortMap.get(port);
            if (prevProtocol != null) {
                throw new IllegalStateException("Duplicated port used by protocol configs, port: " + port + ", configs: " + Arrays.asList(prevProtocol, protocol));
            }
            protocolPortMap.put(port, protocol);
        }
        logger.info("The current configurations or effective configurations are as follows:");
        for (Class configType : multipleConfigTypes) {
            this.getConfigs(configType).forEach(config -> logger.info(config.toString()));
        }
    }

    public ConfigMode getConfigMode() {
        return this.configMode;
    }
}

