/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.etcd;

import org.apache.dubbo.remoting.etcd.RetryPolicy;

public abstract class AbstractRetryPolicy
implements RetryPolicy {
    private final int maxRetried;

    protected AbstractRetryPolicy(int maxRetried) {
        this.maxRetried = maxRetried;
    }

    @Override
    public boolean shouldRetry(int retried, long elapsed, boolean sleep) {
        if (retried < this.maxRetried) {
            try {
                if (sleep) {
                    Thread.sleep(this.getSleepTime(retried, elapsed));
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
            return true;
        }
        return false;
    }

    protected abstract long getSleepTime(int var1, long var2);
}

