/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.etcd.jetcd;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.ClientBuilder;
import io.etcd.jetcd.CloseableClient;
import io.etcd.jetcd.KeyValue;
import io.etcd.jetcd.Observers;
import io.etcd.jetcd.common.exception.ErrorCode;
import io.etcd.jetcd.common.exception.EtcdException;
import io.etcd.jetcd.kv.GetResponse;
import io.etcd.jetcd.lease.LeaseGrantResponse;
import io.etcd.jetcd.options.GetOption;
import io.etcd.jetcd.options.PutOption;
import io.grpc.ConnectivityState;
import io.grpc.LoadBalancer;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import io.grpc.util.RoundRobinLoadBalancerFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.etcd.RetryPolicy;
import org.apache.dubbo.remoting.etcd.jetcd.ConnectionStateListener;
import org.apache.dubbo.remoting.etcd.jetcd.RetryLoops;
import org.apache.dubbo.remoting.etcd.jetcd.RetryNTimes;

public class JEtcdClientWrapper {
    private Logger logger = LoggerFactory.getLogger(JEtcdClientWrapper.class);
    private final URL url;
    private volatile Client client;
    private volatile boolean started = false;
    private volatile boolean connectState = false;
    private ScheduledFuture future;
    private ScheduledExecutorService reconnectNotify;
    private AtomicReference<ManagedChannel> channel;
    private ConnectionStateListener connectionStateListener;
    private long expirePeriod;
    private CompletableFuture<Client> completableFuture;
    private RetryPolicy retryPolicy;
    private RuntimeException failed;
    private final ScheduledFuture<?> retryFuture;
    private final ScheduledExecutorService retryExecutor = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("Etcd3RegistryKeepAliveFailedRetryTimer", true));
    private final Set<String> failedRegistered = new ConcurrentHashSet();
    private final Set<String> registeredPaths = new ConcurrentHashSet();
    private volatile CloseableClient keepAlive = null;
    private volatile long globalLeaseId;
    private volatile boolean cancelKeepAlive = false;
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final long DEFAULT_REQUEST_TIMEOUT = JEtcdClientWrapper.obtainRequestTimeout();
    public static final int DEFAULT_INBOUND_SIZE = 0x6400000;
    public static final String GRPC_MAX_INBOUND_SIZE_KEY = "grpc.max.inbound.size";
    public static final String ETCD_REQUEST_TIMEOUT_KEY = "etcd.request.timeout";

    public JEtcdClientWrapper(URL url) {
        this.url = url;
        this.expirePeriod = url.getParameter("session", 30000) / 1000;
        if (this.expirePeriod <= 0L) {
            this.expirePeriod = 30L;
        }
        this.channel = new AtomicReference();
        this.completableFuture = CompletableFuture.supplyAsync(() -> this.prepareClient(url));
        this.reconnectNotify = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("reconnectNotify", true));
        this.retryPolicy = new RetryNTimes(1, 1000, TimeUnit.MILLISECONDS);
        this.failed = new IllegalStateException("Etcd3 registry is not connected yet, url:" + url);
        int retryPeriod = url.getParameter("retry.period", 5000);
        this.retryFuture = this.retryExecutor.scheduleWithFixedDelay(() -> {
            try {
                this.retry();
            }
            catch (Throwable t) {
                this.logger.error("Unexpected error occur at failed retry, cause: " + t.getMessage(), t);
            }
        }, retryPeriod, retryPeriod, TimeUnit.MILLISECONDS);
    }

    private Client prepareClient(URL url) {
        int maxInboundSize = 0x6400000;
        if (StringUtils.isNotEmpty((String)System.getProperty(GRPC_MAX_INBOUND_SIZE_KEY))) {
            maxInboundSize = Integer.valueOf(System.getProperty(GRPC_MAX_INBOUND_SIZE_KEY));
        }
        ClientBuilder clientBuilder = Client.builder().loadBalancerFactory((LoadBalancer.Factory)RoundRobinLoadBalancerFactory.getInstance()).endpoints(this.endPoints(url.getBackupAddress())).maxInboundMessageSize(Integer.valueOf(maxInboundSize));
        return clientBuilder.build();
    }

    public Client getClient() {
        return this.client;
    }

    public ManagedChannel getChannel() {
        if (this.channel.get() == null || this.channel.get().isShutdown() || this.channel.get().isTerminated()) {
            this.channel.set(this.newChannel(this.client));
        }
        return this.channel.get();
    }

    public List<String> getChildren(String path) {
        try {
            return RetryLoops.invokeWithRetry(() -> {
                JEtcdClientWrapper.requiredNotNull(this.client, this.failed);
                int len = path.length();
                return ((Stream)((GetResponse)this.client.getKVClient().get(ByteSequence.from((String)path, (Charset)UTF_8), GetOption.newBuilder().withPrefix(ByteSequence.from((String)path, (Charset)UTF_8)).build()).get(DEFAULT_REQUEST_TIMEOUT, TimeUnit.MILLISECONDS)).getKvs().stream().parallel()).filter(pair -> {
                    String key = pair.getKey().toString(UTF_8);
                    int index = len;
                    int count = 0;
                    if (key.length() > len) {
                        while ((index = key.indexOf("/", index)) != -1 && count++ <= 1) {
                            ++index;
                        }
                    }
                    return count == 1;
                }).map(pair -> pair.getKey().toString(UTF_8)).collect(Collectors.toList());
            }, this.retryPolicy);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public boolean isConnected() {
        return ConnectivityState.READY == this.getChannel().getState(false) || ConnectivityState.IDLE == this.getChannel().getState(false);
    }

    public long createLease(long second) {
        try {
            return RetryLoops.invokeWithRetry(() -> {
                JEtcdClientWrapper.requiredNotNull(this.client, this.failed);
                return ((LeaseGrantResponse)this.client.getLeaseClient().grant(second).get(DEFAULT_REQUEST_TIMEOUT, TimeUnit.MILLISECONDS)).getID();
            }, this.retryPolicy);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public void revokeLease(long lease) {
        try {
            RetryLoops.invokeWithRetry(() -> {
                JEtcdClientWrapper.requiredNotNull(this.client, this.failed);
                this.client.getLeaseClient().revoke(lease).get(DEFAULT_REQUEST_TIMEOUT, TimeUnit.MILLISECONDS);
                return null;
            }, this.retryPolicy);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public long createLease(long ttl, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (timeout <= 0L) {
            return this.createLease(ttl);
        }
        JEtcdClientWrapper.requiredNotNull(this.client, this.failed);
        return ((LeaseGrantResponse)this.client.getLeaseClient().grant(ttl).get(timeout, unit)).getID();
    }

    public boolean checkExists(String path) {
        try {
            return RetryLoops.invokeWithRetry(() -> {
                JEtcdClientWrapper.requiredNotNull(this.client, this.failed);
                return ((GetResponse)this.client.getKVClient().get(ByteSequence.from((String)path, (Charset)UTF_8), GetOption.newBuilder().withCountOnly(true).build()).get(DEFAULT_REQUEST_TIMEOUT, TimeUnit.MILLISECONDS)).getCount() > 0L;
            }, this.retryPolicy);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    protected Long find(String path) {
        try {
            return RetryLoops.invokeWithRetry(() -> {
                JEtcdClientWrapper.requiredNotNull(this.client, this.failed);
                return ((GetResponse)this.client.getKVClient().get(ByteSequence.from((String)path, (Charset)UTF_8)).get(DEFAULT_REQUEST_TIMEOUT, TimeUnit.MILLISECONDS)).getKvs().stream().mapToLong(keyValue -> Long.valueOf(keyValue.getValue().toString(UTF_8))).findFirst().getAsLong();
            }, this.retryPolicy);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public void createPersistent(String path) {
        try {
            RetryLoops.invokeWithRetry(() -> {
                JEtcdClientWrapper.requiredNotNull(this.client, this.failed);
                this.client.getKVClient().put(ByteSequence.from((String)path, (Charset)UTF_8), ByteSequence.from((String)String.valueOf(path.hashCode()), (Charset)UTF_8)).get(DEFAULT_REQUEST_TIMEOUT, TimeUnit.MILLISECONDS);
                return null;
            }, this.retryPolicy);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public long createEphemeral(String path) {
        try {
            return RetryLoops.invokeWithRetry(() -> {
                JEtcdClientWrapper.requiredNotNull(this.client, this.failed);
                this.registeredPaths.add(path);
                this.keepAlive();
                long leaseId = this.globalLeaseId;
                this.client.getKVClient().put(ByteSequence.from((String)path, (Charset)UTF_8), ByteSequence.from((String)String.valueOf(leaseId), (Charset)UTF_8), PutOption.newBuilder().withLeaseId(leaseId).build()).get(DEFAULT_REQUEST_TIMEOUT, TimeUnit.MILLISECONDS);
                return leaseId;
            }, this.retryPolicy);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public void keepAlive(long lease) {
        this.keepAlive(lease, null);
    }

    private <T> void keepAlive(long lease, Consumer<T> onFailed) {
        StreamObserver observer = new Observers.Builder().onError(e -> {
            EtcdException error;
            if (e instanceof EtcdException && (error = (EtcdException)e).getErrorCode() == ErrorCode.NOT_FOUND) {
                this.keepAlive0(onFailed);
            }
        }).onCompleted(() -> this.keepAlive0(onFailed)).build();
        this.cancelKeepAlive();
        this.keepAlive = this.client.getLeaseClient().keepAlive(lease, observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void keepAlive() throws Exception {
        if (this.keepAlive == null) {
            JEtcdClientWrapper jEtcdClientWrapper = this;
            synchronized (jEtcdClientWrapper) {
                if (this.keepAlive == null) {
                    this.globalLeaseId = ((LeaseGrantResponse)this.client.getLeaseClient().grant(this.expirePeriod).get(DEFAULT_REQUEST_TIMEOUT, TimeUnit.MILLISECONDS)).getID();
                    this.keepAlive(this.globalLeaseId, NULL -> this.recovery());
                }
            }
        }
    }

    private <T> void keepAlive0(Consumer<T> onFailed) {
        if (onFailed != null) {
            long leaseId = this.globalLeaseId;
            try {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Failed to keep alive for global lease '" + leaseId + "', waiting for retry again.");
                }
                onFailed.accept(null);
            }
            catch (Exception ignored) {
                this.logger.warn("Failed to recover from global lease expired or lease deadline exceeded. lease '" + leaseId + "'", (Throwable)ignored);
            }
        }
    }

    private void recovery() {
        try {
            if (this.cancelKeepAlive) {
                return;
            }
            this.cancelKeepAlive();
            HashSet<String> ephemeralPaths = new HashSet<String>(this.registeredPaths);
            if (!ephemeralPaths.isEmpty()) {
                for (String path : ephemeralPaths) {
                    try {
                        if (this.cancelKeepAlive) {
                            return;
                        }
                        this.createEphemeral(path);
                        this.failedRegistered.remove(path);
                    }
                    catch (Exception e) {
                        this.failedRegistered.add(path);
                        Status status = Status.fromThrowable((Throwable)e);
                        if (status.getCode() != Status.Code.NOT_FOUND) continue;
                        this.cancelKeepAlive();
                    }
                }
            }
        }
        catch (Throwable t) {
            this.logger.warn("Unexpected error, failed to recover from global lease expired or deadline exceeded.", t);
        }
    }

    public void delete(String path) {
        try {
            RetryLoops.invokeWithRetry(() -> {
                JEtcdClientWrapper.requiredNotNull(this.client, this.failed);
                this.client.getKVClient().delete(ByteSequence.from((String)path, (Charset)UTF_8)).get(DEFAULT_REQUEST_TIMEOUT, TimeUnit.MILLISECONDS);
                this.registeredPaths.remove(path);
                return null;
            }, this.retryPolicy);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        finally {
            this.failedRegistered.remove(path);
        }
    }

    public String[] endPoints(String backupAddress) {
        String[] endpoints = backupAddress.split(",");
        List<String> addresses = Arrays.stream(endpoints).map(address -> address.contains("://") ? address : "http://" + address).collect(Collectors.toList());
        Collections.shuffle(addresses);
        return addresses.toArray(new String[0]);
    }

    public void start() {
        if (!this.started) {
            try {
                this.client = this.completableFuture.get(this.expirePeriod, TimeUnit.SECONDS);
                this.connectState = this.isConnected();
                this.started = true;
            }
            catch (Throwable t) {
                this.logger.error("Timeout! etcd3 server can not be connected in : " + this.expirePeriod + " seconds! url: " + this.url, t);
                this.completableFuture.whenComplete((c, e) -> {
                    this.client = c;
                    if (e != null) {
                        this.logger.error("Got an exception when trying to create etcd3 instance, can not connect to etcd3 server, url: " + this.url, e);
                    }
                });
            }
            try {
                this.future = this.reconnectNotify.scheduleWithFixedDelay(() -> {
                    boolean connected = this.isConnected();
                    if (this.connectState != connected) {
                        int notifyState;
                        int n = notifyState = connected ? 1 : 0;
                        if (this.connectionStateListener != null) {
                            try {
                                if (connected) {
                                    this.clearKeepAlive();
                                }
                                this.connectionStateListener.stateChanged(this.getClient(), notifyState);
                            }
                            finally {
                                this.cancelKeepAlive = false;
                            }
                        }
                        this.connectState = connected;
                    }
                }, 3000L, 3000L, TimeUnit.MILLISECONDS);
            }
            catch (Throwable t) {
                this.logger.error("monitor reconnect status failed.", t);
            }
        }
    }

    private void cancelKeepAlive() {
        try {
            if (this.keepAlive != null) {
                this.keepAlive.close();
            }
        }
        finally {
            this.keepAlive = null;
        }
    }

    private void clearKeepAlive() {
        this.cancelKeepAlive = true;
        this.failedRegistered.clear();
        this.cancelKeepAlive();
    }

    protected void doClose() {
        try {
            this.cancelKeepAlive = true;
            if (this.globalLeaseId > 0L) {
                this.revokeLease(this.globalLeaseId);
            }
        }
        catch (Exception e) {
            this.logger.warn("revoke global lease '" + this.globalLeaseId + "' failed, registry: " + this.url, (Throwable)e);
        }
        try {
            if (this.started && this.future != null) {
                this.started = false;
                this.future.cancel(true);
                this.reconnectNotify.shutdownNow();
            }
        }
        catch (Exception e) {
            this.logger.warn("stop reconnect Notify failed, registry: " + this.url, (Throwable)e);
        }
        try {
            this.retryFuture.cancel(true);
            this.retryExecutor.shutdownNow();
        }
        catch (Throwable t) {
            this.logger.warn(t.getMessage(), t);
        }
        if (this.getClient() != null) {
            this.getClient().close();
        }
    }

    private ManagedChannel newChannel(Client client) {
        try {
            Object connection;
            Method channel;
            Field connectionField = client.getClass().getDeclaredField("connectionManager");
            if (!connectionField.isAccessible()) {
                connectionField.setAccessible(true);
            }
            if (!(channel = (connection = connectionField.get(client)).getClass().getDeclaredMethod("getChannel", new Class[0])).isAccessible()) {
                channel.setAccessible(true);
            }
            return (ManagedChannel)channel.invoke(connection, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to obtain connection channel from " + this.url.getBackupAddress(), e);
        }
    }

    public ConnectionStateListener getConnectionStateListener() {
        return this.connectionStateListener;
    }

    public void setConnectionStateListener(ConnectionStateListener connectionStateListener) {
        this.connectionStateListener = connectionStateListener;
    }

    public static void requiredNotNull(Object obj, RuntimeException exeception) {
        if (obj == null) {
            throw exeception;
        }
    }

    public String getKVValue(String key) {
        if (null == key) {
            return null;
        }
        CompletableFuture responseFuture = this.client.getKVClient().get(ByteSequence.from((String)key, (Charset)UTF_8));
        try {
            List result = ((GetResponse)responseFuture.get(DEFAULT_REQUEST_TIMEOUT, TimeUnit.MILLISECONDS)).getKvs();
            if (!result.isEmpty()) {
                return ((KeyValue)result.get(0)).getValue().toString(UTF_8);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public boolean put(String key, String value) {
        if (key == null || value == null) {
            return false;
        }
        CompletableFuture putFuture = this.client.getKVClient().put(ByteSequence.from((String)key, (Charset)UTF_8), ByteSequence.from((String)value, (Charset)UTF_8));
        try {
            putFuture.get(DEFAULT_REQUEST_TIMEOUT, TimeUnit.MILLISECONDS);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void retry() {
        HashSet<String> failed;
        if (!this.failedRegistered.isEmpty() && !(failed = new HashSet<String>(this.failedRegistered)).isEmpty()) {
            if (this.cancelKeepAlive) {
                return;
            }
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Retry failed register(keep alive) for path '" + failed + "', path size: " + failed.size());
            }
            try {
                for (String path : failed) {
                    try {
                        if (this.cancelKeepAlive) {
                            return;
                        }
                        this.createEphemeral(path);
                        this.failedRegistered.remove(path);
                    }
                    catch (Throwable e) {
                        this.failedRegistered.add(path);
                        Status status = Status.fromThrowable((Throwable)e);
                        if (status.getCode() == Status.Code.NOT_FOUND) {
                            this.cancelKeepAlive();
                        }
                        this.logger.warn("Failed to retry register(keep alive) for path '" + path + "', waiting for again, cause: " + e.getMessage(), e);
                    }
                }
            }
            catch (Throwable t) {
                this.logger.warn("Failed to retry register(keep alive) for path '" + failed + "', waiting for again, cause: " + t.getMessage(), t);
            }
        }
    }

    private static int obtainRequestTimeout() {
        if (StringUtils.isNotEmpty((String)System.getProperty(ETCD_REQUEST_TIMEOUT_KEY))) {
            return Integer.valueOf(System.getProperty(ETCD_REQUEST_TIMEOUT_KEY));
        }
        return 10000;
    }
}

