/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.etcd.support;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.etcd.ChildListener;
import org.apache.dubbo.remoting.etcd.EtcdClient;
import org.apache.dubbo.remoting.etcd.StateListener;

public abstract class AbstractEtcdClient<WatcherListener>
implements EtcdClient {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractEtcdClient.class);
    private final URL url;
    private final Set<StateListener> stateListeners = new ConcurrentHashSet();
    private final ConcurrentMap<String, ConcurrentMap<ChildListener, WatcherListener>> childListeners = new ConcurrentHashMap<String, ConcurrentMap<ChildListener, WatcherListener>>();
    private final List<String> categroies = Arrays.asList("providers", "consumers", "routers", "configurators");
    private volatile boolean closed = false;

    public AbstractEtcdClient(URL url) {
        this.url = url;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public void create(String path) {
        String fixedPath = this.fixNamespace(path);
        this.createParentIfAbsent(fixedPath);
        this.doCreatePersistent(fixedPath);
    }

    @Override
    public long createEphemeral(String path) {
        String fixedPath = this.fixNamespace(path);
        this.createParentIfAbsent(fixedPath);
        return this.doCreateEphemeral(path);
    }

    @Override
    public void addStateListener(StateListener listener) {
        this.stateListeners.add(listener);
    }

    @Override
    public void removeStateListener(StateListener listener) {
        this.stateListeners.remove(listener);
    }

    public Set<StateListener> getSessionListeners() {
        return this.stateListeners;
    }

    @Override
    public List<String> addChildListener(String path, ChildListener listener) {
        Object targetListener;
        ConcurrentMap listeners = (ConcurrentMap)this.childListeners.get(path);
        if (listeners == null) {
            this.childListeners.putIfAbsent(path, new ConcurrentHashMap());
            listeners = (ConcurrentMap)this.childListeners.get(path);
        }
        if ((targetListener = listeners.get(listener)) == null) {
            listeners.putIfAbsent(listener, this.createChildWatcherListener(path, listener));
            targetListener = listeners.get(listener);
        }
        return this.addChildWatcherListener(path, targetListener);
    }

    public WatcherListener getChildListener(String path, ChildListener listener) {
        ConcurrentMap listeners = (ConcurrentMap)this.childListeners.get(path);
        if (listeners == null) {
            return null;
        }
        Object targetListener = listeners.get(listener);
        if (targetListener == null) {
            listeners.putIfAbsent(listener, this.createChildWatcherListener(path, listener));
            targetListener = listeners.get(listener);
        }
        return (WatcherListener)targetListener;
    }

    @Override
    public void removeChildListener(String path, ChildListener listener) {
        Object targetListener;
        ConcurrentMap listeners = (ConcurrentMap)this.childListeners.get(path);
        if (listeners != null && (targetListener = listeners.remove(listener)) != null) {
            this.removeChildWatcherListener(path, targetListener);
        }
    }

    protected void stateChanged(int state) {
        for (StateListener sessionListener : this.getSessionListeners()) {
            sessionListener.stateChanged(state);
        }
    }

    protected String fixNamespace(String path) {
        if (StringUtils.isEmpty((String)path)) {
            throw new IllegalArgumentException("path is required, actual null or ''");
        }
        return path.charAt(0) != '/' ? "/" + path : path;
    }

    protected void createParentIfAbsent(String fixedPath) {
        int i = fixedPath.lastIndexOf(47);
        if (i > 0) {
            String grandfather;
            String parentPath = fixedPath.substring(0, i);
            if (this.categroies.stream().anyMatch(c -> fixedPath.endsWith((String)c))) {
                if (!this.checkExists(parentPath)) {
                    this.doCreatePersistent(parentPath);
                }
            } else if (this.categroies.stream().anyMatch(c -> parentPath.endsWith((String)c)) && !this.checkExists(grandfather = parentPath.substring(0, parentPath.lastIndexOf(47)))) {
                this.doCreatePersistent(grandfather);
            }
        }
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.doClose();
        }
        catch (Throwable t) {
            logger.warn(t.getMessage(), t);
        }
    }

    public abstract void doClose();

    public abstract void doCreatePersistent(String var1);

    public abstract long doCreateEphemeral(String var1);

    @Override
    public abstract void delete(String var1);

    public abstract boolean checkExists(String var1);

    public abstract WatcherListener createChildWatcherListener(String var1, ChildListener var2);

    public abstract List<String> addChildWatcherListener(String var1, WatcherListener var2);

    public abstract void removeChildWatcherListener(String var1, WatcherListener var2);
}

