/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.util.Utf8;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class AvroRowSerializationSchema
implements SerializationSchema<Row> {
    private Class<? extends SpecificRecord> recordClazz;
    private transient Schema schema;
    private transient DatumWriter<GenericRecord> datumWriter;
    private transient ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
    private transient Encoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)this.arrayOutputStream, null);

    public AvroRowSerializationSchema(Class<? extends SpecificRecord> recordClazz) {
        Preconditions.checkNotNull(recordClazz, (String)"Avro record class must not be null.");
        this.recordClazz = recordClazz;
        this.schema = SpecificData.get().getSchema(recordClazz);
        this.datumWriter = new SpecificDatumWriter(this.schema);
    }

    public byte[] serialize(Row row) {
        Object record = AvroRowSerializationSchema.convertToRecord(this.schema, row);
        try {
            this.arrayOutputStream.reset();
            this.datumWriter.write((Object)((GenericRecord)record), this.encoder);
            this.encoder.flush();
            return this.arrayOutputStream.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to serialize Row.", e);
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.recordClazz);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        this.recordClazz = (Class)ois.readObject();
        this.schema = SpecificData.get().getSchema(this.recordClazz);
        this.datumWriter = new SpecificDatumWriter(this.schema);
        this.arrayOutputStream = new ByteArrayOutputStream();
        this.encoder = EncoderFactory.get().binaryEncoder((OutputStream)this.arrayOutputStream, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object convertToRecord(Schema schema, Object rowObj) {
        if (rowObj instanceof Row) {
            if (schema.getType() == Schema.Type.UNION) {
                List types = schema.getTypes();
                if (types.size() == 2 && ((Schema)types.get(0)).getType() == Schema.Type.NULL && ((Schema)types.get(1)).getType() == Schema.Type.RECORD) {
                    schema = (Schema)types.get(1);
                } else {
                    if (types.size() != 2 || ((Schema)types.get(0)).getType() != Schema.Type.RECORD || ((Schema)types.get(1)).getType() != Schema.Type.NULL) throw new RuntimeException("Currently we only support schemas of the following form: UNION[null, RECORD] or UNION[RECORD, NULL] Given: " + schema);
                    schema = (Schema)types.get(0);
                }
            } else if (schema.getType() != Schema.Type.RECORD) {
                throw new RuntimeException("Record type for row type expected. But is: " + schema);
            }
            List fields = schema.getFields();
            GenericData.Record record = new GenericData.Record(schema);
            Row row = (Row)rowObj;
            for (int i = 0; i < fields.size(); ++i) {
                Schema.Field field = (Schema.Field)fields.get(i);
                record.put(field.pos(), AvroRowSerializationSchema.convertToRecord(field.schema(), row.getField(i)));
            }
            return record;
        }
        if (!(rowObj instanceof String)) return rowObj;
        return new Utf8((String)rowObj);
    }
}

