/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.erasurecode.rawcoder;

import java.nio.ByteBuffer;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.erasurecode.rawcoder.ByteBufferEncodingState;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.erasurecode.rawcoder.CoderUtil;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.erasurecode.rawcoder.EncodingState;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.erasurecode.rawcoder.RawErasureEncoder;

@InterfaceAudience.Private
class ByteArrayEncodingState
extends EncodingState {
    byte[][] inputs;
    byte[][] outputs;
    int[] inputOffsets;
    int[] outputOffsets;

    ByteArrayEncodingState(RawErasureEncoder encoder, byte[][] inputs, byte[][] outputs) {
        this.encoder = encoder;
        byte[] validInput = (byte[])CoderUtil.findFirstValidInput(inputs);
        this.encodeLength = validInput.length;
        this.inputs = inputs;
        this.outputs = outputs;
        this.checkParameters((T[])inputs, (T[])outputs);
        this.checkBuffers(inputs);
        this.checkBuffers(outputs);
        this.inputOffsets = new int[inputs.length];
        this.outputOffsets = new int[outputs.length];
    }

    ByteArrayEncodingState(RawErasureEncoder encoder, int encodeLength, byte[][] inputs, int[] inputOffsets, byte[][] outputs, int[] outputOffsets) {
        this.encoder = encoder;
        this.encodeLength = encodeLength;
        this.inputs = inputs;
        this.outputs = outputs;
        this.inputOffsets = inputOffsets;
        this.outputOffsets = outputOffsets;
    }

    ByteBufferEncodingState convertToByteBufferState() {
        int i;
        ByteBuffer[] newInputs = new ByteBuffer[this.inputs.length];
        ByteBuffer[] newOutputs = new ByteBuffer[this.outputs.length];
        for (i = 0; i < this.inputs.length; ++i) {
            newInputs[i] = CoderUtil.cloneAsDirectByteBuffer(this.inputs[i], this.inputOffsets[i], this.encodeLength);
        }
        for (i = 0; i < this.outputs.length; ++i) {
            newOutputs[i] = ByteBuffer.allocateDirect(this.encodeLength);
        }
        ByteBufferEncodingState bbeState = new ByteBufferEncodingState(this.encoder, this.encodeLength, newInputs, newOutputs);
        return bbeState;
    }

    void checkBuffers(byte[][] buffers) {
        for (byte[] buffer : buffers) {
            if (buffer == null) {
                throw new HadoopIllegalArgumentException("Invalid buffer found, not allowing null");
            }
            if (buffer.length == this.encodeLength) continue;
            throw new HadoopIllegalArgumentException("Invalid buffer not of length " + this.encodeLength);
        }
    }
}

