/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.ipc;

import java.util.HashMap;
import java.util.Map;
import javax.net.SocketFactory;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.ObjectWritable;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.Writable;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.ipc.Client;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class ClientCache {
    private Map<SocketFactory, Client> clients = new HashMap<SocketFactory, Client>();

    public synchronized Client getClient(Configuration conf, SocketFactory factory, Class<? extends Writable> valueClass) {
        Client client = this.clients.get(factory);
        if (client == null) {
            client = new Client(valueClass, conf, factory);
            this.clients.put(factory, client);
        } else {
            client.incCount();
        }
        if (Client.LOG.isDebugEnabled()) {
            Client.LOG.debug("getting client out of cache: " + client);
        }
        return client;
    }

    public synchronized Client getClient(Configuration conf) {
        return this.getClient(conf, SocketFactory.getDefault(), ObjectWritable.class);
    }

    public synchronized Client getClient(Configuration conf, SocketFactory factory) {
        return this.getClient(conf, factory, ObjectWritable.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopClient(Client client) {
        int count;
        if (Client.LOG.isDebugEnabled()) {
            Client.LOG.debug("stopping client from cache: " + client);
        }
        ClientCache clientCache = this;
        synchronized (clientCache) {
            count = client.decAndGetCount();
            if (count == 0) {
                if (Client.LOG.isDebugEnabled()) {
                    Client.LOG.debug("removing client from cache: " + client);
                }
                this.clients.remove(client.getSocketFactory());
            }
        }
        if (count == 0) {
            if (Client.LOG.isDebugEnabled()) {
                Client.LOG.debug("stopping actual client because no more references remain: " + client);
            }
            client.stop();
        }
    }
}

