/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.concurrent.HadoopExecutors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class ShutdownHookManager {
    private static final ShutdownHookManager MGR = new ShutdownHookManager();
    private static final Logger LOG = LoggerFactory.getLogger(ShutdownHookManager.class);
    public static final long TIMEOUT_MINIMUM = 1L;
    public static final TimeUnit TIME_UNIT_DEFAULT = TimeUnit.SECONDS;
    private static final ExecutorService EXECUTOR = HadoopExecutors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("shutdown-hook-%01d").build());
    private final Set<HookEntry> hooks = Collections.synchronizedSet(new HashSet());
    private AtomicBoolean shutdownInProgress = new AtomicBoolean(false);

    @InterfaceAudience.Private
    @VisibleForTesting
    int executeShutdown() {
        int timeouts = 0;
        for (HookEntry entry : this.getShutdownHooksInOrder()) {
            Future<?> future = EXECUTOR.submit(entry.getHook());
            try {
                future.get(entry.getTimeout(), entry.getTimeUnit());
            }
            catch (TimeoutException ex) {
                ++timeouts;
                future.cancel(true);
                LOG.warn("ShutdownHook '" + entry.getHook().getClass().getSimpleName() + "' timeout, " + ex.toString(), (Throwable)ex);
            }
            catch (Throwable ex) {
                LOG.warn("ShutdownHook '" + entry.getHook().getClass().getSimpleName() + "' failed, " + ex.toString(), ex);
            }
        }
        return timeouts;
    }

    private static void shutdownExecutor(Configuration conf) {
        try {
            EXECUTOR.shutdown();
            long shutdownTimeout = ShutdownHookManager.getShutdownTimeout(conf);
            if (!EXECUTOR.awaitTermination(shutdownTimeout, TIME_UNIT_DEFAULT)) {
                LOG.error("ShutdownHookManger shutdown forcefully after {} seconds.", (Object)shutdownTimeout);
                EXECUTOR.shutdownNow();
            }
            LOG.debug("ShutdownHookManger completed shutdown.");
        }
        catch (InterruptedException ex) {
            LOG.error("ShutdownHookManger interrupted while waiting for termination.", (Throwable)ex);
            EXECUTOR.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    @InterfaceAudience.Public
    public static ShutdownHookManager get() {
        return MGR;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    static long getShutdownTimeout(Configuration conf) {
        long duration = conf.getTimeDuration("hadoop.service.shutdown.timeout", 30L, TIME_UNIT_DEFAULT);
        if (duration < 1L) {
            duration = 1L;
        }
        return duration;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    ShutdownHookManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    @VisibleForTesting
    List<HookEntry> getShutdownHooksInOrder() {
        ArrayList<HookEntry> list;
        Set<HookEntry> set = this.hooks;
        synchronized (set) {
            list = new ArrayList<HookEntry>(this.hooks);
        }
        Collections.sort(list, new Comparator<HookEntry>(){

            @Override
            public int compare(HookEntry o1, HookEntry o2) {
                return o2.priority - o1.priority;
            }
        });
        return list;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public void addShutdownHook(Runnable shutdownHook, int priority) {
        if (shutdownHook == null) {
            throw new IllegalArgumentException("shutdownHook cannot be NULL");
        }
        if (this.shutdownInProgress.get()) {
            throw new IllegalStateException("Shutdown in progress, cannot add a shutdownHook");
        }
        this.hooks.add(new HookEntry(shutdownHook, priority));
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public void addShutdownHook(Runnable shutdownHook, int priority, long timeout, TimeUnit unit) {
        if (shutdownHook == null) {
            throw new IllegalArgumentException("shutdownHook cannot be NULL");
        }
        if (this.shutdownInProgress.get()) {
            throw new IllegalStateException("Shutdown in progress, cannot add a shutdownHook");
        }
        this.hooks.add(new HookEntry(shutdownHook, priority, timeout, unit));
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public boolean removeShutdownHook(Runnable shutdownHook) {
        if (this.shutdownInProgress.get()) {
            throw new IllegalStateException("Shutdown in progress, cannot remove a shutdownHook");
        }
        return this.hooks.remove(new HookEntry(shutdownHook, 0, 1L, TIME_UNIT_DEFAULT));
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public boolean hasShutdownHook(Runnable shutdownHook) {
        return this.hooks.contains(new HookEntry(shutdownHook, 0, 1L, TIME_UNIT_DEFAULT));
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public boolean isShutdownInProgress() {
        return this.shutdownInProgress.get();
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public void clearShutdownHooks() {
        this.hooks.clear();
    }

    static {
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    if (MGR.shutdownInProgress.getAndSet(true)) {
                        LOG.info("Shutdown process invoked a second time: ignoring");
                        return;
                    }
                    long started = System.currentTimeMillis();
                    int timeoutCount = MGR.executeShutdown();
                    long ended = System.currentTimeMillis();
                    LOG.debug(String.format("Completed shutdown in %.3f seconds; Timeouts: %d", (double)(ended - started) / 1000.0, timeoutCount));
                    ShutdownHookManager.shutdownExecutor(new Configuration());
                }
            });
        }
        catch (IllegalStateException ex) {
            LOG.warn("Failed to add the ShutdownHook", (Throwable)ex);
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    static class HookEntry {
        private final Runnable hook;
        private final int priority;
        private final long timeout;
        private final TimeUnit unit;

        HookEntry(Runnable hook, int priority) {
            this(hook, priority, ShutdownHookManager.getShutdownTimeout(new Configuration()), TIME_UNIT_DEFAULT);
        }

        HookEntry(Runnable hook, int priority, long timeout, TimeUnit unit) {
            this.hook = hook;
            this.priority = priority;
            this.timeout = timeout;
            this.unit = unit;
        }

        public int hashCode() {
            return this.hook.hashCode();
        }

        public boolean equals(Object obj) {
            boolean eq = false;
            if (obj != null && obj instanceof HookEntry) {
                eq = this.hook == ((HookEntry)obj).hook;
            }
            return eq;
        }

        Runnable getHook() {
            return this.hook;
        }

        int getPriority() {
            return this.priority;
        }

        long getTimeout() {
            return this.timeout;
        }

        TimeUnit getTimeUnit() {
            return this.unit;
        }
    }
}

