/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.nn;

import breeze.generic.UFunc;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Vector$;
import breeze.linalg.package;
import org.apache.flink.ml.math.Breeze$;
import org.apache.flink.ml.math.Vector;
import org.apache.flink.ml.metrics.distances.DistanceMetric;
import org.apache.flink.ml.metrics.distances.EuclideanDistanceMetric;
import org.apache.flink.ml.metrics.distances.SquaredEuclideanDistanceMetric;
import org.apache.flink.ml.nn.QuadTree$$anonfun$org$apache$flink$ml$nn$QuadTree$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.PriorityQueue;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005md\u0001B\u0001\u0003\u00015\u0011\u0001\"U;bIR\u0013X-\u001a\u0006\u0003\u0007\u0011\t!A\u001c8\u000b\u0005\u00151\u0011AA7m\u0015\t9\u0001\"A\u0003gY&t7N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0003\u00019\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007\u0002C\u000b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\f\u0002\r5LgNV3d!\t9\"$D\u0001\u0019\u0015\tIB!\u0001\u0003nCRD\u0017BA\u000e\u0019\u0005\u00191Vm\u0019;pe\"AQ\u0004\u0001B\u0001B\u0003%a#\u0001\u0004nCb4Vm\u0019\u0005\t?\u0001\u0011\t\u0011)A\u0005A\u0005QA-[:u\u001b\u0016$(/[2\u0011\u0005\u00052S\"\u0001\u0012\u000b\u0005\r\"\u0013!\u00033jgR\fgnY3t\u0015\t)C!A\u0004nKR\u0014\u0018nY:\n\u0005\u001d\u0012#A\u0004#jgR\fgnY3NKR\u0014\u0018n\u0019\u0005\tS\u0001\u0011\t\u0011)A\u0005U\u0005IQ.\u0019=QKJ\u0014u\u000e\u001f\t\u0003\u001f-J!\u0001\f\t\u0003\u0007%sG\u000fC\u0003/\u0001\u0011\u0005q&\u0001\u0004=S:LGO\u0010\u000b\u0006aI\u001aD'\u000e\t\u0003c\u0001i\u0011A\u0001\u0005\u0006+5\u0002\rA\u0006\u0005\u0006;5\u0002\rA\u0006\u0005\u0006?5\u0002\r\u0001\t\u0005\u0006S5\u0002\rA\u000b\u0004\u0005o\u0001\u0001\u0001H\u0001\u0003O_\u0012,7C\u0001\u001c\u000f\u0011!QdG!A!\u0002\u00131\u0012AB2f]R,'\u000f\u0003\u0005=m\t\u0005\t\u0015!\u0003\u0017\u0003\u00159\u0018\u000e\u001a;i\u0011!qdG!a\u0001\n\u0003y\u0014\u0001C2iS2$'/\u001a8\u0016\u0003\u0001\u00032!Q%M\u001d\t\u0011uI\u0004\u0002D\r6\tAI\u0003\u0002F\u0019\u00051AH]8pizJ\u0011!E\u0005\u0003\u0011B\tq\u0001]1dW\u0006<W-\u0003\u0002K\u0017\n\u00191+Z9\u000b\u0005!\u0003\u0002CA'7\u001b\u0005\u0001\u0001\u0002C(7\u0005\u0003\u0007I\u0011\u0001)\u0002\u0019\rD\u0017\u000e\u001c3sK:|F%Z9\u0015\u0005E#\u0006CA\bS\u0013\t\u0019\u0006C\u0001\u0003V]&$\bbB+O\u0003\u0003\u0005\r\u0001Q\u0001\u0004q\u0012\n\u0004\u0002C,7\u0005\u0003\u0005\u000b\u0015\u0002!\u0002\u0013\rD\u0017\u000e\u001c3sK:\u0004\u0003\"\u0002\u00187\t\u0003IF\u0003\u0002'[7rCQA\u000f-A\u0002YAQ\u0001\u0010-A\u0002YAQA\u0010-A\u0002\u0001CqA\u0018\u001cC\u0002\u0013\u0005q,\u0001\u0007o_\u0012,W\t\\3nK:$8/F\u0001a!\r\tgMF\u0007\u0002E*\u00111\rZ\u0001\b[V$\u0018M\u00197f\u0015\t)\u0007#\u0001\u0006d_2dWm\u0019;j_:L!a\u001a2\u0003\u00151K7\u000f\u001e\"vM\u001a,'\u000f\u0003\u0004jm\u0001\u0006I\u0001Y\u0001\u000e]>$W-\u00127f[\u0016tGo\u001d\u0011\t\u000b-4D\u0011\u00017\u0002\u001d\u001d,GoQ3oi\u0016\u0014x+\u001b3uQR\tQ\u000e\u0005\u0003\u0010]Z1\u0012BA8\u0011\u0005\u0019!V\u000f\u001d7fe!)\u0011O\u000eC\u0001e\u0006A1m\u001c8uC&t7\u000f\u0006\u0002tmB\u0011q\u0002^\u0005\u0003kB\u0011qAQ8pY\u0016\fg\u000eC\u0003xa\u0002\u0007a#\u0001\u0006rk\u0016\u0014\u0018\u0010U8j]RDQ!\u001f\u001c\u0005\u0002i\fqa\u001c<fe2\f\u0007\u000fF\u0002twrDQa\u001e=A\u0002YAQ! =A\u0002y\faA]1eSV\u001c\bCA\b\u0000\u0013\r\t\t\u0001\u0005\u0002\u0007\t>,(\r\\3\t\u000f\u0005\u0015a\u0007\"\u0001\u0002\b\u00051\u0011n\u001d(fCJ$Ra]A\u0005\u0003\u0017Aaa^A\u0002\u0001\u00041\u0002BB?\u0002\u0004\u0001\u0007a\u0010C\u0004\u0002\u0010Y\"\t!!\u0005\u0002\u000f5Lg\u000eR5tiR\u0019a0a\u0005\t\r]\fi\u00011\u0001\u0017\u0011\u001d\t9B\u000eC\u0001\u00033\t!b\u001e5jG\"\u001c\u0005.\u001b7e)\rQ\u00131\u0004\u0005\u0007o\u0006U\u0001\u0019\u0001\f\t\u000f\u0005}a\u0007\"\u0001\u0002\"\u0005aQ.Y6f\u0007\"LG\u000e\u001a:f]R\t\u0011\u000bC\u0004\u0002&Y\"\t!a\n\u0002\u0019A\f'\u000f^5uS>t'i\u001c=\u0015\r\u0005%\u00121FA\u0017!\r\t\u0015J\u0006\u0005\u0007u\u0005\r\u0002\u0019\u0001\f\t\rq\n\u0019\u00031\u0001\u0017\u0011%\t\t\u0004\u0001b\u0001\n\u0003\t\u0019$\u0001\u0003s_>$X#\u0001'\t\u000f\u0005]\u0002\u0001)A\u0005\u0019\u0006)!o\\8uA!9\u00111\b\u0001\u0005\u0002\u0005\u0005\u0012!\u00039sS:$HK]3f\u0011\u001d\ty\u0004\u0001C\u0001\u0003\u0003\na!\u001b8tKJ$HcA)\u0002D!1q/!\u0010A\u0002YAq!a\u0012\u0001\t\u0003\tI%A\u000etK\u0006\u00148\r\u001b(fS\u001eD'm\u001c:t'&\u0014G.\u001b8h#V,W/\u001a\u000b\u0004A\u0006-\u0003BB<\u0002F\u0001\u0007a\u0003C\u0004\u0002P\u0001!I!!\u0015\u0002/M,\u0017M]2i%\u0016\u001cWO]*jE2LgnZ)vKV,GcB)\u0002T\u0005U\u0013\u0011\f\u0005\u0007o\u00065\u0003\u0019\u0001\f\t\u000f\u0005]\u0013Q\na\u0001\u0019\u0006!an\u001c3f\u0011!\tY&!\u0014A\u0002\u0005u\u0013!\u00038pI\u0016\fV/Z;f!\u0015\t\u0017qLA2\u0013\r\t\tG\u0019\u0002\u000e!JLwN]5usF+X-^3\u0011\t=qg\u0010\u0014\u0005\b\u0003O\u0002A\u0011BA5\u0003!i\u0017N\u001c(pI\u0016\u001cHcB)\u0002l\u00055\u0014q\u000e\u0005\u0007o\u0006\u0015\u0004\u0019\u0001\f\t\u000f\u0005]\u0013Q\ra\u0001\u0019\"A\u00111LA3\u0001\u0004\ti\u0006C\u0004\u0002t\u0001!\t!!\u001e\u0002\u001fM,\u0017M]2i\u001d\u0016Lw\r\u001b2peN$R\u0001YA<\u0003sBaa^A9\u0001\u00041\u0002BB?\u0002r\u0001\u0007a\u0010")
public class QuadTree {
    public final DistanceMetric org$apache$flink$ml$nn$QuadTree$$distMetric;
    private final int maxPerBox;
    private final Node root;

    public Node root() {
        return this.root;
    }

    public void printTree() {
        this.org$apache$flink$ml$nn$QuadTree$$printTreeRecur$1(this.root());
    }

    public void insert(Vector queryPoint) {
        this.org$apache$flink$ml$nn$QuadTree$$insertRecur$1(queryPoint, this.root());
    }

    public ListBuffer<Vector> searchNeighborsSiblingQueue(Vector queryPoint) {
        ListBuffer listBuffer;
        ListBuffer ret = new ListBuffer();
        if (this.root().children() == null) {
            listBuffer = this.root().nodeElements().clone();
        } else {
            PriorityQueue nodeQueue = new PriorityQueue(scala.package$.MODULE$.Ordering().by((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final double apply(Tuple2<Object, Node> x) {
                    return x._1$mcD$sp();
                }
            }, (Ordering)Ordering.Double$.MODULE$));
            this.org$apache$flink$ml$nn$QuadTree$$searchRecurSiblingQueue(queryPoint, this.root(), (PriorityQueue<Tuple2<Object, Node>>)nodeQueue);
            int count = 0;
            while (count < this.maxPerBox) {
                Tuple2 dq = (Tuple2)nodeQueue.dequeue();
                if (!((Node)dq._2()).nodeElements().nonEmpty()) continue;
                ret.$plus$plus$eq(((Node)dq._2()).nodeElements());
                count += ((Node)dq._2()).nodeElements().length();
            }
            listBuffer = ret;
        }
        return listBuffer;
    }

    public void org$apache$flink$ml$nn$QuadTree$$searchRecurSiblingQueue(Vector queryPoint, Node node, PriorityQueue<Tuple2<Object, Node>> nodeQueue) {
        if (node.children() != null) {
            node.children().withFilter((Function1)new Serializable(this, queryPoint){
                public static final long serialVersionUID = 0L;
                private final Vector queryPoint$4;

                public final boolean apply(Node child) {
                    return child.contains(this.queryPoint$4);
                }
                {
                    this.queryPoint$4 = queryPoint$4;
                }
            }).foreach((Function1)new Serializable(this, queryPoint, node, nodeQueue){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ QuadTree $outer;
                public final Vector queryPoint$4;
                private final Node node$2;
                public final PriorityQueue nodeQueue$1;

                public final void apply(Node child) {
                    if (child.children() == null) {
                        this.node$2.children().foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$org$apache$flink$ml$nn$QuadTree$$searchRecurSiblingQueue$2 $outer;

                            public final void apply(Node c) {
                                this.$outer.org$apache$flink$ml$nn$QuadTree$$anonfun$$$outer().org$apache$flink$ml$nn$QuadTree$$minNodes(this.$outer.queryPoint$4, c, (PriorityQueue<Tuple2<Object, Node>>)this.$outer.nodeQueue$1);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    } else {
                        this.$outer.org$apache$flink$ml$nn$QuadTree$$searchRecurSiblingQueue(this.queryPoint$4, child, (PriorityQueue<Tuple2<Object, Node>>)this.nodeQueue$1);
                    }
                }

                public /* synthetic */ QuadTree org$apache$flink$ml$nn$QuadTree$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.queryPoint$4 = queryPoint$4;
                    this.node$2 = node$2;
                    this.nodeQueue$1 = nodeQueue$1;
                }
            });
        }
    }

    public void org$apache$flink$ml$nn$QuadTree$$minNodes(Vector queryPoint, Node node, PriorityQueue<Tuple2<Object, Node>> nodeQueue) {
        if (node.children() == null) {
            nodeQueue.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToDouble((double)(-node.minDist(queryPoint))), (Object)node));
        } else {
            node.children().foreach((Function1)new Serializable(this, queryPoint, nodeQueue){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ QuadTree $outer;
                private final Vector queryPoint$5;
                private final PriorityQueue nodeQueue$2;

                public final void apply(Node c) {
                    this.$outer.org$apache$flink$ml$nn$QuadTree$$minNodes(this.queryPoint$5, c, (PriorityQueue<Tuple2<Object, Node>>)this.nodeQueue$2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.queryPoint$5 = queryPoint$5;
                    this.nodeQueue$2 = nodeQueue$2;
                }
            });
        }
    }

    public ListBuffer<Vector> searchNeighbors(Vector queryPoint, double radius) {
        ListBuffer ret = new ListBuffer();
        this.org$apache$flink$ml$nn$QuadTree$$searchRecur$1(queryPoint, radius, this.root(), ret);
        return ret;
    }

    public final void org$apache$flink$ml$nn$QuadTree$$printTreeRecur$1(Node node) {
        if (node.children() == null) {
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"printing tree: n.nodeElements ").append(node.nodeElements()).toString());
        } else {
            node.children().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ QuadTree $outer;

                public final void apply(Node c) {
                    this.$outer.org$apache$flink$ml$nn$QuadTree$$printTreeRecur$1(c);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
    }

    public final void org$apache$flink$ml$nn$QuadTree$$insertRecur$1(Vector queryPoint, Node node) {
        while (true) {
            if (node.children() == null) {
                if (node.nodeElements().length() < this.maxPerBox) {
                    node.nodeElements().$plus$eq((Object)queryPoint);
                    return;
                }
                node.makeChildren();
                node.nodeElements().foreach((Function1)new Serializable(this, node){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ QuadTree $outer;
                    private final Node node$1;

                    public final void apply(Vector o) {
                        this.$outer.org$apache$flink$ml$nn$QuadTree$$insertRecur$1(o, (Node)this.node$1.children().apply(this.node$1.whichChild(o)));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.node$1 = node$1;
                    }
                });
                node.nodeElements().clear();
                node = (Node)node.children().apply(node.whichChild(queryPoint));
                continue;
            }
            node = (Node)node.children().apply(node.whichChild(queryPoint));
        }
    }

    public final void org$apache$flink$ml$nn$QuadTree$$searchRecur$1(Vector queryPoint, double radius, Node node, ListBuffer ret) {
        if (node.children() == null) {
            ret.$plus$plus$eq(node.nodeElements());
        } else {
            node.children().withFilter((Function1)new Serializable(this, queryPoint, radius){
                public static final long serialVersionUID = 0L;
                private final Vector queryPoint$6;
                private final double radius$2;

                public final boolean apply(Node child) {
                    return child.isNear(this.queryPoint$6, this.radius$2);
                }
                {
                    this.queryPoint$6 = queryPoint$6;
                    this.radius$2 = radius$2;
                }
            }).foreach((Function1)new Serializable(this, queryPoint, radius, ret){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ QuadTree $outer;
                private final Vector queryPoint$6;
                private final double radius$2;
                private final ListBuffer ret$1;

                public final void apply(Node child) {
                    this.$outer.org$apache$flink$ml$nn$QuadTree$$searchRecur$1(this.queryPoint$6, this.radius$2, child, this.ret$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.queryPoint$6 = queryPoint$6;
                    this.radius$2 = radius$2;
                    this.ret$1 = ret$1;
                }
            });
        }
    }

    public QuadTree(Vector minVec, Vector maxVec, DistanceMetric distMetric, int maxPerBox) {
        this.org$apache$flink$ml$nn$QuadTree$$distMetric = distMetric;
        this.maxPerBox = maxPerBox;
        this.root = new Node(this, (Vector)Breeze$.MODULE$.Breeze2VectorConverter((breeze.linalg.Vector<Object>)((breeze.linalg.Vector)((ImmutableNumericOps)Breeze$.MODULE$.Vector2BreezeConverter(minVec).asBreeze().$plus(Breeze$.MODULE$.Vector2BreezeConverter(maxVec).asBreeze(), (UFunc.UImpl2)Vector$.MODULE$.v_v_Idempotent_Op_Double_OpAdd())).$times((Object)BoxesRunTime.boxToDouble((double)0.5), (UFunc.UImpl2)Vector$.MODULE$.v_s_Op_Double_OpMulMatrix()))).fromBreeze(org.apache.flink.ml.math.Vector$.MODULE$.vectorConverter()), (Vector)Breeze$.MODULE$.Breeze2VectorConverter((breeze.linalg.Vector<Object>)((breeze.linalg.Vector)Breeze$.MODULE$.Vector2BreezeConverter(maxVec).asBreeze().$minus(Breeze$.MODULE$.Vector2BreezeConverter(minVec).asBreeze(), (UFunc.UImpl2)Vector$.MODULE$.v_v_Idempotent_Op_Double_OpSub()))).fromBreeze(org.apache.flink.ml.math.Vector$.MODULE$.vectorConverter()), null);
    }

    public class Node {
        public final Vector org$apache$flink$ml$nn$QuadTree$Node$$center;
        public final Vector org$apache$flink$ml$nn$QuadTree$Node$$width;
        private Seq<Node> children;
        private final ListBuffer<Vector> nodeElements;
        public final /* synthetic */ QuadTree $outer;

        public Seq<Node> children() {
            return this.children;
        }

        public void children_$eq(Seq<Node> x$1) {
            this.children = x$1;
        }

        public ListBuffer<Vector> nodeElements() {
            return this.nodeElements;
        }

        public Tuple2<Vector, Vector> getCenterWidth() {
            return new Tuple2((Object)this.org$apache$flink$ml$nn$QuadTree$Node$$center, (Object)this.org$apache$flink$ml$nn$QuadTree$Node$$width);
        }

        public boolean contains(Vector queryPoint) {
            return this.overlap(queryPoint, 0.0);
        }

        public boolean overlap(Vector queryPoint, double radius) {
            return RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), queryPoint.size()).forall((Function1)new Serializable(this, queryPoint, radius){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Node $outer;
                private final Vector queryPoint$2;
                private final double radius$1;

                public final boolean apply(int i) {
                    return this.apply$mcZI$sp(i);
                }

                public boolean apply$mcZI$sp(int i) {
                    return this.queryPoint$2.apply(i) - this.radius$1 < this.$outer.org$apache$flink$ml$nn$QuadTree$Node$$center.apply(i) + this.$outer.org$apache$flink$ml$nn$QuadTree$Node$$width.apply(i) / (double)2 && this.queryPoint$2.apply(i) + this.radius$1 > this.$outer.org$apache$flink$ml$nn$QuadTree$Node$$center.apply(i) - this.$outer.org$apache$flink$ml$nn$QuadTree$Node$$width.apply(i) / (double)2;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.queryPoint$2 = queryPoint$2;
                    this.radius$1 = radius$1;
                }
            });
        }

        public boolean isNear(Vector queryPoint, double radius) {
            return this.minDist(queryPoint) < radius;
        }

        public double minDist(Vector queryPoint) {
            block4: {
                double d;
                block3: {
                    DistanceMetric distanceMetric;
                    double minDist;
                    block2: {
                        minDist = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), queryPoint.size()).map((Function1)new Serializable(this, queryPoint){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ Node $outer;
                            private final Vector queryPoint$3;

                            public final double apply(int i) {
                                return this.apply$mcDI$sp(i);
                            }

                            public double apply$mcDI$sp(int i) {
                                return this.queryPoint$3.apply(i) < this.$outer.org$apache$flink$ml$nn$QuadTree$Node$$center.apply(i) - this.$outer.org$apache$flink$ml$nn$QuadTree$Node$$width.apply(i) / (double)2 ? package$.MODULE$.pow(this.queryPoint$3.apply(i) - this.$outer.org$apache$flink$ml$nn$QuadTree$Node$$center.apply(i) + this.$outer.org$apache$flink$ml$nn$QuadTree$Node$$width.apply(i) / (double)2, 2.0) : (this.queryPoint$3.apply(i) > this.$outer.org$apache$flink$ml$nn$QuadTree$Node$$center.apply(i) + this.$outer.org$apache$flink$ml$nn$QuadTree$Node$$width.apply(i) / (double)2 ? package$.MODULE$.pow(this.queryPoint$3.apply(i) - this.$outer.org$apache$flink$ml$nn$QuadTree$Node$$center.apply(i) - this.$outer.org$apache$flink$ml$nn$QuadTree$Node$$width.apply(i) / (double)2, 2.0) : 0.0);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.queryPoint$3 = queryPoint$3;
                            }
                        }, IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
                        distanceMetric = this.org$apache$flink$ml$nn$QuadTree$Node$$$outer().org$apache$flink$ml$nn$QuadTree$$distMetric;
                        if (!(distanceMetric instanceof EuclideanDistanceMetric)) break block2;
                        d = package$.MODULE$.sqrt(minDist);
                        break block3;
                    }
                    if (!(distanceMetric instanceof SquaredEuclideanDistanceMetric)) break block4;
                    d = minDist;
                }
                return d;
            }
            throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" Error: metric must be"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" Euclidean or SquaredEuclidean!"})).s((Seq)Nil$.MODULE$)).toString());
        }

        public int whichChild(Vector queryPoint) {
            return BoxesRunTime.unboxToInt((Object)((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), queryPoint.size()).map((Function1)new Serializable(this, queryPoint){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Node $outer;
                private final Vector queryPoint$1;

                public final int apply(int i) {
                    return this.apply$mcII$sp(i);
                }

                public int apply$mcII$sp(int i) {
                    return this.queryPoint$1.apply(i) > this.$outer.org$apache$flink$ml$nn$QuadTree$Node$$center.apply(i) ? (int)package$.MODULE$.pow(2.0, (double)(this.queryPoint$1.size() - 1 - i)) : 0;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.queryPoint$1 = queryPoint$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        }

        public void makeChildren() {
            Vector centerClone = this.org$apache$flink$ml$nn$QuadTree$Node$$center.copy();
            Seq<Vector> cPart = this.partitionBox(centerClone, this.org$apache$flink$ml$nn$QuadTree$Node$$width);
            breeze.linalg.Vector mappedWidth = (breeze.linalg.Vector)new package.InjectNumericOps(breeze.linalg.package$.MODULE$.InjectNumericOps((Object)BoxesRunTime.boxToDouble((double)0.5))).$times(Breeze$.MODULE$.Vector2BreezeConverter(this.org$apache$flink$ml$nn$QuadTree$Node$$width).asBreeze(), (UFunc.UImpl2)Vector$.MODULE$.s_v_Op_Double_OpMulMatrix());
            this.children_$eq((Seq<Node>)((Seq)cPart.map((Function1)new Serializable(this, mappedWidth){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Node $outer;
                private final breeze.linalg.Vector mappedWidth$1;

                public final Node apply(Vector p) {
                    return new Node(this.$outer.org$apache$flink$ml$nn$QuadTree$Node$$$outer(), p, (Vector)Breeze$.MODULE$.Breeze2VectorConverter((breeze.linalg.Vector<Object>)this.mappedWidth$1).fromBreeze(org.apache.flink.ml.math.Vector$.MODULE$.vectorConverter()), null);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.mappedWidth$1 = mappedWidth$1;
                }
            }, Seq$.MODULE$.canBuildFrom())));
        }

        public Seq<Vector> partitionBox(Vector center, Vector width) {
            return this.partitionHelper$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{center})), 0, width);
        }

        public /* synthetic */ QuadTree org$apache$flink$ml$nn$QuadTree$Node$$$outer() {
            return this.$outer;
        }

        private final Seq partitionHelper$1(Seq box, int dim, Vector width$1) {
            while (dim < width$1.size()) {
                Seq newBox = (Seq)box.flatMap((Function1)new Serializable(this, width$1, dim){
                    public static final long serialVersionUID = 0L;
                    private final Vector width$1;
                    private final int dim$1;

                    public final Seq<Vector> apply(Vector vector) {
                        Tuple2 tuple2 = new Tuple2((Object)vector.copy(), (Object)vector);
                        if (tuple2 != null) {
                            Tuple2 tuple22;
                            Vector up = (Vector)tuple2._1();
                            Vector down = (Vector)tuple2._2();
                            Tuple2 tuple23 = tuple22 = new Tuple2((Object)up, (Object)down);
                            Vector up2 = (Vector)tuple23._1();
                            Vector down2 = (Vector)tuple23._2();
                            up2.update(this.dim$1, up2.apply(this.dim$1) - this.width$1.apply(this.dim$1) / (double)4);
                            down2.update(this.dim$1, down2.apply(this.dim$1) + this.width$1.apply(this.dim$1) / (double)4);
                            return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{up2, down2}));
                        }
                        throw new MatchError((Object)tuple2);
                    }
                    {
                        this.width$1 = width$1;
                        this.dim$1 = dim$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                ++dim;
                box = newBox;
            }
            return box;
        }

        public Node(QuadTree $outer, Vector center, Vector width, Seq<Node> children) {
            this.org$apache$flink$ml$nn$QuadTree$Node$$center = center;
            this.org$apache$flink$ml$nn$QuadTree$Node$$width = width;
            this.children = children;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.nodeElements = new ListBuffer();
        }
    }
}

