/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.regression;

import breeze.generic.UFunc;
import breeze.linalg.Vector$;
import org.apache.flink.api.scala.DataSet;
import org.apache.flink.ml.common.LabeledVector;
import org.apache.flink.ml.common.ParameterMap;
import org.apache.flink.ml.common.WeightVector;
import org.apache.flink.ml.math.Breeze$;
import org.apache.flink.ml.math.Vector;
import org.apache.flink.ml.optimization.GenericLossFunction;
import org.apache.flink.ml.optimization.GradientDescent;
import org.apache.flink.ml.optimization.GradientDescent$;
import org.apache.flink.ml.optimization.LearningRateMethod;
import org.apache.flink.ml.optimization.LinearPrediction$;
import org.apache.flink.ml.optimization.SquaredLoss$;
import org.apache.flink.ml.pipeline.FitOperation;
import org.apache.flink.ml.pipeline.PredictOperation;
import org.apache.flink.ml.regression.MultipleLinearRegression;
import org.apache.flink.ml.regression.MultipleLinearRegression$ConvergenceThreshold$;
import org.apache.flink.ml.regression.MultipleLinearRegression$Iterations$;
import org.apache.flink.ml.regression.MultipleLinearRegression$LearningRateMethodValue$;
import org.apache.flink.ml.regression.MultipleLinearRegression$Stepsize$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class MultipleLinearRegression$ {
    public static final MultipleLinearRegression$ MODULE$;
    private final String WEIGHTVECTOR_BROADCAST;
    private final GenericLossFunction lossFunction;
    private final Object fitMLR;

    static {
        new MultipleLinearRegression$();
    }

    public String WEIGHTVECTOR_BROADCAST() {
        return this.WEIGHTVECTOR_BROADCAST;
    }

    public GenericLossFunction lossFunction() {
        return this.lossFunction;
    }

    public MultipleLinearRegression apply() {
        return new MultipleLinearRegression();
    }

    public Object fitMLR() {
        return this.fitMLR;
    }

    public <T extends Vector> Object predictVectors() {
        return new PredictOperation<MultipleLinearRegression, WeightVector, T, Object>(){

            public DataSet<WeightVector> getModel(MultipleLinearRegression self, ParameterMap predictParameters) {
                Option<DataSet<WeightVector>> option = self.weightsOption();
                if (option instanceof Some) {
                    DataSet weights;
                    Some some = (Some)option;
                    DataSet dataSet = weights = (DataSet)some.x();
                    return dataSet;
                }
                if (None$.MODULE$.equals(option)) {
                    throw new RuntimeException("The MultipleLinearRegression has not been fitted to the data. This is necessary to learn the weight vector of the linear function.");
                }
                throw new MatchError(option);
            }

            public double predict(T value, WeightVector model) {
                WeightVector weightVector = model;
                if (weightVector != null) {
                    Tuple2 tuple2;
                    Vector weights = weightVector.weights();
                    double weight0 = weightVector.intercept();
                    Tuple2 tuple22 = tuple2 = new Tuple2((Object)weights, (Object)BoxesRunTime.boxToDouble((double)weight0));
                    Vector weights2 = (Vector)tuple22._1();
                    double weight02 = tuple22._2$mcD$sp();
                    double dotProduct = BoxesRunTime.unboxToDouble((Object)Breeze$.MODULE$.Vector2BreezeConverter((Vector)value).asBreeze().dot(Breeze$.MODULE$.Vector2BreezeConverter(weights2).asBreeze(), (UFunc.UImpl2)Vector$.MODULE$.canDot_V_V_Double()));
                    return dotProduct + weight02;
                }
                throw new MatchError((Object)weightVector);
            }
        };
    }

    private MultipleLinearRegression$() {
        MODULE$ = this;
        this.WEIGHTVECTOR_BROADCAST = "weights_broadcast";
        this.lossFunction = new GenericLossFunction(SquaredLoss$.MODULE$, LinearPrediction$.MODULE$);
        this.fitMLR = new FitOperation<MultipleLinearRegression, LabeledVector>(){

            public void fit(MultipleLinearRegression instance, ParameterMap fitParameters, DataSet<LabeledVector> input) {
                Option<Object> option;
                block4: {
                    Option<LearningRateMethod.LearningRateMethodTrait> option2;
                    block7: {
                        GradientDescent optimizer;
                        block6: {
                            Object object;
                            block5: {
                                Option<LearningRateMethod.LearningRateMethodTrait> learningRateMethod;
                                block3: {
                                    Object object2;
                                    block2: {
                                        ParameterMap map2 = instance.parameters().$plus$plus(fitParameters);
                                        int numberOfIterations = BoxesRunTime.unboxToInt((Object)map2.apply(MultipleLinearRegression$Iterations$.MODULE$));
                                        double stepsize = BoxesRunTime.unboxToDouble((Object)map2.apply(MultipleLinearRegression$Stepsize$.MODULE$));
                                        Option<Object> convergenceThreshold = map2.get(MultipleLinearRegression$ConvergenceThreshold$.MODULE$);
                                        learningRateMethod = map2.get(MultipleLinearRegression$LearningRateMethodValue$.MODULE$);
                                        GenericLossFunction lossFunction = new GenericLossFunction(SquaredLoss$.MODULE$, LinearPrediction$.MODULE$);
                                        optimizer = (GradientDescent)GradientDescent$.MODULE$.apply().setIterations(numberOfIterations).setStepsize(stepsize).setLossFunction(lossFunction);
                                        option = convergenceThreshold;
                                        if (!(option instanceof Some)) break block2;
                                        Some some = (Some)option;
                                        double threshold = BoxesRunTime.unboxToDouble((Object)some.x());
                                        object2 = optimizer.setConvergenceThreshold(threshold);
                                        break block3;
                                    }
                                    if (!None$.MODULE$.equals(option)) break block4;
                                    object2 = BoxedUnit.UNIT;
                                }
                                option2 = learningRateMethod;
                                if (!(option2 instanceof Some)) break block5;
                                Some some = (Some)option2;
                                LearningRateMethod.LearningRateMethodTrait method = (LearningRateMethod.LearningRateMethodTrait)some.x();
                                object = optimizer.setLearningRateMethod(method);
                                break block6;
                            }
                            if (!None$.MODULE$.equals(option2)) break block7;
                            object = BoxedUnit.UNIT;
                        }
                        instance.weightsOption_$eq((Option<DataSet<WeightVector>>)new Some(optimizer.optimize(input, (Option<DataSet<WeightVector>>)None$.MODULE$)));
                        return;
                    }
                    throw new MatchError(option2);
                }
                throw new MatchError(option);
            }
        };
    }
}

