/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.operators;

import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.operators.util.FieldList;
import org.apache.flink.optimizer.CompilerException;
import org.apache.flink.optimizer.dag.TwoInputNode;
import org.apache.flink.optimizer.dataproperties.LocalProperties;
import org.apache.flink.optimizer.dataproperties.RequestedLocalProperties;
import org.apache.flink.optimizer.operators.AbstractJoinDescriptor;
import org.apache.flink.optimizer.operators.OperatorDescriptorDual;
import org.apache.flink.optimizer.plan.Channel;
import org.apache.flink.optimizer.plan.DualInputPlanNode;
import org.apache.flink.optimizer.util.Utils;

public abstract class AbstractSortMergeJoinDescriptor
extends AbstractJoinDescriptor {
    public AbstractSortMergeJoinDescriptor(FieldList keys1, FieldList keys2) {
        super(keys1, keys2);
    }

    public AbstractSortMergeJoinDescriptor(FieldList keys1, FieldList keys2, boolean broadcastFirstAllowed, boolean broadcastSecondAllowed, boolean repartitionAllowed) {
        super(keys1, keys2, broadcastFirstAllowed, broadcastSecondAllowed, repartitionAllowed);
    }

    @Override
    protected List<OperatorDescriptorDual.LocalPropertiesPair> createPossibleLocalProperties() {
        RequestedLocalProperties sort1 = new RequestedLocalProperties(Utils.createOrdering(this.keys1));
        RequestedLocalProperties sort2 = new RequestedLocalProperties(Utils.createOrdering(this.keys2));
        return Collections.singletonList(new OperatorDescriptorDual.LocalPropertiesPair(sort1, sort2));
    }

    @Override
    public boolean areCoFulfilled(RequestedLocalProperties requested1, RequestedLocalProperties requested2, LocalProperties produced1, LocalProperties produced2) {
        int numRelevantFields = this.keys1.size();
        return this.checkSameOrdering(produced1, produced2, numRelevantFields);
    }

    @Override
    public DualInputPlanNode instantiate(Channel in1, Channel in2, TwoInputNode node) {
        boolean[] inputOrders = in1.getLocalProperties().getOrdering().getFieldSortDirections();
        if (inputOrders == null || inputOrders.length < this.keys1.size()) {
            throw new CompilerException("BUG: The input strategy does not sufficiently describe the sort orders for a merge operator.");
        }
        if (inputOrders.length > this.keys1.size()) {
            boolean[] tmp = new boolean[this.keys1.size()];
            System.arraycopy(inputOrders, 0, tmp, 0, tmp.length);
            inputOrders = tmp;
        }
        String nodeName = String.format("%s(%s)", this.getNodeName(), node.getOperator().getName());
        return new DualInputPlanNode(node, nodeName, in1, in2, this.getStrategy(), this.keys1, this.keys2, inputOrders);
    }

    @Override
    public LocalProperties computeLocalProperties(LocalProperties in1, LocalProperties in2) {
        LocalProperties comb = LocalProperties.combine(in1, in2);
        return comb.clearUniqueFieldSets();
    }

    protected abstract String getNodeName();
}

