/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.client;

import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.util.Iterator;
import java.util.Map;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.accumulators.AccumulatorHelper;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.accumulators.AccumulatorEvent;
import org.apache.flink.runtime.client.AbstractJobResult;
import org.apache.flink.runtime.client.JobCancelResult;
import org.apache.flink.runtime.client.JobExecutionException;
import org.apache.flink.runtime.client.JobProgressResult;
import org.apache.flink.runtime.client.JobSubmissionResult;
import org.apache.flink.runtime.event.job.AbstractEvent;
import org.apache.flink.runtime.event.job.JobEvent;
import org.apache.flink.runtime.ipc.RPC;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.runtime.net.NetUtils;
import org.apache.flink.runtime.protocols.AccumulatorProtocol;
import org.apache.flink.runtime.protocols.JobManagementProtocol;
import org.apache.flink.runtime.types.IntegerRecord;
import org.apache.flink.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobClient {
    private static final Logger LOG = LoggerFactory.getLogger(JobClient.class);
    private final JobManagementProtocol jobSubmitClient;
    private AccumulatorProtocol accumulatorProtocolProxy;
    private final JobGraph jobGraph;
    private final Configuration configuration;
    private final JobCleanUp jobCleanUp;
    private final ClassLoader userCodeClassLoader;
    private long lastProcessedEventSequenceNumber = -1L;
    private PrintStream console;

    public JobClient(JobGraph jobGraph, ClassLoader userCodeClassLoader) throws IOException {
        this(jobGraph, new Configuration(), userCodeClassLoader);
    }

    public JobClient(JobGraph jobGraph, Configuration configuration, ClassLoader userCodeClassLoader) throws IOException {
        String address = configuration.getString("jobmanager.rpc.address", null);
        int port = configuration.getInteger("jobmanager.rpc.port", 6123);
        InetSocketAddress inetaddr = new InetSocketAddress(address, port);
        this.jobSubmitClient = RPC.getProxy(JobManagementProtocol.class, inetaddr, NetUtils.getSocketFactory());
        this.accumulatorProtocolProxy = RPC.getProxy(AccumulatorProtocol.class, inetaddr, NetUtils.getSocketFactory());
        this.jobGraph = jobGraph;
        this.configuration = configuration;
        this.jobCleanUp = new JobCleanUp(this);
        this.userCodeClassLoader = userCodeClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.jobSubmitClient;
        synchronized (object) {
            RPC.stopProxy(this.jobSubmitClient);
        }
        object = this.accumulatorProtocolProxy;
        synchronized (object) {
            RPC.stopProxy(this.accumulatorProtocolProxy);
        }
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobSubmissionResult submitJob() throws IOException {
        JobManagementProtocol jobManagementProtocol = this.jobSubmitClient;
        synchronized (jobManagementProtocol) {
            int port = this.jobSubmitClient.getBlobServerPort();
            if (port == -1) {
                throw new IOException("Unable to upload user jars: BLOB server not running");
            }
            String jobManagerAddress = this.configuration.getString("jobmanager.rpc.address", null);
            if (jobManagerAddress == null) {
                throw new IOException("Unable to find job manager address from configuration.");
            }
            InetSocketAddress blobManagerAddress = new InetSocketAddress(jobManagerAddress, port);
            this.jobGraph.uploadRequiredJarFiles(blobManagerAddress);
            return this.jobSubmitClient.submitJob(this.jobGraph);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobCancelResult cancelJob() throws IOException {
        JobManagementProtocol jobManagementProtocol = this.jobSubmitClient;
        synchronized (jobManagementProtocol) {
            return this.jobSubmitClient.cancelJob(this.jobGraph.getJobID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobProgressResult getJobProgress() throws IOException {
        JobManagementProtocol jobManagementProtocol = this.jobSubmitClient;
        synchronized (jobManagementProtocol) {
            return this.jobSubmitClient.getJobProgress(this.jobGraph.getJobID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobExecutionResult submitJobAndWait() throws IOException, JobExecutionException {
        JobManagementProtocol jobManagementProtocol = this.jobSubmitClient;
        synchronized (jobManagementProtocol) {
            JobSubmissionResult submissionResult = this.submitJob();
            if (submissionResult.getReturnCode() == AbstractJobResult.ReturnCode.ERROR) {
                LOG.error("ERROR: " + submissionResult.getDescription());
                throw new JobExecutionException(submissionResult.getDescription(), false);
            }
            Runtime.getRuntime().addShutdownHook(this.jobCleanUp);
        }
        long sleep = 0L;
        try {
            IntegerRecord interval = this.jobSubmitClient.getRecommendedPollingInterval();
            sleep = interval.getValue() * 1000;
        }
        catch (IOException ioe) {
            Runtime.getRuntime().removeShutdownHook(this.jobCleanUp);
            throw ioe;
        }
        try {
            Thread.sleep(sleep / 2L);
        }
        catch (InterruptedException e) {
            Runtime.getRuntime().removeShutdownHook(this.jobCleanUp);
            this.logErrorAndRethrow(StringUtils.stringifyException((Throwable)e));
        }
        long startTimestamp = -1L;
        while (true) {
            if (Thread.interrupted()) {
                this.logErrorAndRethrow("Job client has been interrupted");
            }
            JobProgressResult jobProgressResult = null;
            try {
                jobProgressResult = this.getJobProgress();
            }
            catch (IOException ioe) {
                Runtime.getRuntime().removeShutdownHook(this.jobCleanUp);
                throw ioe;
            }
            if (jobProgressResult == null) {
                this.logErrorAndRethrow("Returned job progress is unexpectedly null!");
            }
            if (jobProgressResult.getReturnCode() == AbstractJobResult.ReturnCode.ERROR) {
                this.logErrorAndRethrow("Could not retrieve job progress: " + jobProgressResult.getDescription());
            }
            Iterator<AbstractEvent> it = jobProgressResult.getEvents();
            while (it.hasNext()) {
                AbstractEvent event = it.next();
                if (this.lastProcessedEventSequenceNumber >= event.getSequenceNumber()) continue;
                LOG.info(event.toString());
                if (this.console != null) {
                    this.console.println(event.toString());
                }
                this.lastProcessedEventSequenceNumber = event.getSequenceNumber();
                if (!(event instanceof JobEvent)) continue;
                JobEvent jobEvent = (JobEvent)event;
                JobStatus jobStatus = jobEvent.getCurrentJobStatus();
                if (jobStatus == JobStatus.RUNNING) {
                    startTimestamp = jobEvent.getTimestamp();
                }
                if (jobStatus == JobStatus.FINISHED) {
                    Runtime.getRuntime().removeShutdownHook(this.jobCleanUp);
                    long jobDuration = jobEvent.getTimestamp() - startTimestamp;
                    Map accumulators = null;
                    try {
                        accumulators = AccumulatorHelper.toResultMap(this.getAccumulators().getAccumulators(this.userCodeClassLoader));
                    }
                    catch (IOException ioe) {
                        Runtime.getRuntime().removeShutdownHook(this.jobCleanUp);
                        throw ioe;
                    }
                    return new JobExecutionResult(jobDuration, accumulators);
                }
                if (jobStatus != JobStatus.CANCELED && jobStatus != JobStatus.FAILED) continue;
                Runtime.getRuntime().removeShutdownHook(this.jobCleanUp);
                LOG.info(jobEvent.getOptionalMessage());
                if (jobStatus == JobStatus.CANCELED) {
                    throw new JobExecutionException(jobEvent.getOptionalMessage(), true);
                }
                throw new JobExecutionException(jobEvent.getOptionalMessage(), false);
            }
            try {
                Thread.sleep(sleep);
                continue;
            }
            catch (InterruptedException e) {
                this.logErrorAndRethrow(StringUtils.stringifyException((Throwable)e));
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRecommendedPollingInterval() throws IOException {
        JobManagementProtocol jobManagementProtocol = this.jobSubmitClient;
        synchronized (jobManagementProtocol) {
            return this.jobSubmitClient.getRecommendedPollingInterval().getValue();
        }
    }

    private void logErrorAndRethrow(String errorMessage) throws IOException {
        LOG.error(errorMessage);
        throw new IOException(errorMessage);
    }

    public void setConsoleStreamForReporting(PrintStream stream) {
        this.console = stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AccumulatorEvent getAccumulators() throws IOException {
        JobManagementProtocol jobManagementProtocol = this.jobSubmitClient;
        synchronized (jobManagementProtocol) {
            return this.accumulatorProtocolProxy.getAccumulatorResults(this.jobGraph.getJobID());
        }
    }

    public static class JobCleanUp
    extends Thread {
        private final JobClient jobClient;

        public JobCleanUp(JobClient jobClient) {
            this.jobClient = jobClient;
        }

        @Override
        public void run() {
            this.jobClient.close();
        }
    }
}

