/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.deployment;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.deployment.ChannelDeploymentDescriptor;
import org.apache.flink.runtime.executiongraph.ExecutionEdge;

public final class GateDeploymentDescriptor
implements IOReadableWritable {
    private final List<ChannelDeploymentDescriptor> channels;

    public GateDeploymentDescriptor(List<ChannelDeploymentDescriptor> channels) {
        if (channels == null) {
            throw new NullPointerException();
        }
        this.channels = channels;
    }

    public GateDeploymentDescriptor() {
        this.channels = new ArrayList<ChannelDeploymentDescriptor>();
    }

    public List<ChannelDeploymentDescriptor> getChannels() {
        return this.channels;
    }

    public void write(DataOutputView out) throws IOException {
        out.writeInt(this.channels.size());
        for (ChannelDeploymentDescriptor cdd : this.channels) {
            cdd.write(out);
        }
    }

    public void read(DataInputView in) throws IOException {
        int nocdd = in.readInt();
        for (int i = 0; i < nocdd; ++i) {
            ChannelDeploymentDescriptor cdd = new ChannelDeploymentDescriptor();
            cdd.read(in);
            this.channels.add(cdd);
        }
    }

    public static GateDeploymentDescriptor fromEdges(List<ExecutionEdge> edges) {
        ArrayList<ChannelDeploymentDescriptor> channels = new ArrayList<ChannelDeploymentDescriptor>(edges.size());
        for (ExecutionEdge edge : edges) {
            channels.add(ChannelDeploymentDescriptor.fromExecutionEdge(edge));
        }
        return new GateDeploymentDescriptor(channels);
    }

    public static GateDeploymentDescriptor fromEdges(ExecutionEdge[] edges) {
        ArrayList<ChannelDeploymentDescriptor> channels = new ArrayList<ChannelDeploymentDescriptor>(edges.length);
        for (ExecutionEdge edge : edges) {
            channels.add(ChannelDeploymentDescriptor.fromExecutionEdge(edge));
        }
        return new GateDeploymentDescriptor(channels);
    }
}

