/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.execution.librarycache;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.execution.librarycache.LibraryCacheManager;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.jobgraph.JobID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FallbackLibraryCacheManager
implements LibraryCacheManager {
    private static Logger LOG = LoggerFactory.getLogger(FallbackLibraryCacheManager.class);

    @Override
    public ClassLoader getClassLoader(JobID id) {
        return this.getClass().getClassLoader();
    }

    @Override
    public File getFile(BlobKey blobKey) throws IOException {
        throw new IOException("There is no file associated to the blob key " + blobKey);
    }

    @Override
    public void registerJob(JobID id, Collection<BlobKey> requiredJarFiles) {
        LOG.warn("FallbackLibraryCacheManager cannot download files associated with blob keys.");
    }

    @Override
    public void registerTask(JobID id, ExecutionAttemptID execution, Collection<BlobKey> requiredJarFiles) {
        LOG.warn("FallbackLibraryCacheManager cannot download files associated with blob keys.");
    }

    @Override
    public void unregisterJob(JobID id) {
        LOG.warn("FallbackLibraryCacheManager does not book keeping of job IDs.");
    }

    @Override
    public void unregisterTask(JobID id, ExecutionAttemptID execution) {
        LOG.warn("FallbackLibraryCacheManager does not book keeping of job IDs.");
    }

    @Override
    public void shutdown() {
    }
}

