/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.instance;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.instance.Instance;
import org.apache.flink.runtime.jobgraph.JobID;
import org.apache.flink.runtime.jobmanager.scheduler.Locality;

public class AllocatedSlot {
    private static final AtomicIntegerFieldUpdater<AllocatedSlot> STATUS_UPDATER = AtomicIntegerFieldUpdater.newUpdater(AllocatedSlot.class, "status");
    private static final AtomicReferenceFieldUpdater<AllocatedSlot, Execution> VERTEX_UPDATER = AtomicReferenceFieldUpdater.newUpdater(AllocatedSlot.class, Execution.class, "executedTask");
    private static final int ALLOCATED_AND_ALIVE = 0;
    private static final int CANCELLED = 1;
    private static final int RELEASED = 2;
    private final JobID jobID;
    private final Instance instance;
    private final int slotNumber;
    private volatile Execution executedTask;
    private volatile int status = 0;
    private Locality locality = Locality.UNCONSTRAINED;

    public AllocatedSlot(JobID jobID, Instance instance, int slotNumber) {
        if (jobID == null || instance == null || slotNumber < 0) {
            throw new IllegalArgumentException();
        }
        this.jobID = jobID;
        this.instance = instance;
        this.slotNumber = slotNumber;
    }

    public JobID getJobID() {
        return this.jobID;
    }

    public Instance getInstance() {
        return this.instance;
    }

    public int getSlotNumber() {
        return this.slotNumber;
    }

    public Execution getExecutedVertex() {
        return this.executedTask;
    }

    public Locality getLocality() {
        return this.locality;
    }

    public void setLocality(Locality locality) {
        this.locality = locality;
    }

    public boolean setExecutedVertex(Execution executedVertex) {
        if (executedVertex == null) {
            throw new NullPointerException();
        }
        if (this.status != 0) {
            return false;
        }
        if (!VERTEX_UPDATER.compareAndSet(this, null, executedVertex)) {
            return false;
        }
        if (this.status != 0) {
            this.executedTask = null;
            return false;
        }
        return true;
    }

    public boolean isAlive() {
        return this.status == 0;
    }

    public boolean isCanceled() {
        return this.status != 0;
    }

    public boolean isReleased() {
        return this.status == 2;
    }

    public void cancel() {
        Execution exec;
        if (STATUS_UPDATER.compareAndSet(this, 0, 1) && (exec = this.executedTask) != null && !exec.isFinished()) {
            exec.fail(new Exception("The slot in which the task was scheduled has been killed (probably loss of TaskManager)."));
        }
    }

    public void releaseSlot() {
        try {
            this.cancel();
        }
        finally {
            this.instance.returnAllocatedSlot(this);
        }
    }

    protected boolean markReleased() {
        return STATUS_UPDATER.compareAndSet(this, 1, 2);
    }

    public String toString() {
        return this.instance.getId() + " (" + this.slotNumber + ") - " + AllocatedSlot.getStateName(this.status);
    }

    private static final String getStateName(int state) {
        switch (state) {
            case 0: {
                return "ALLOCATED/ALIVE";
            }
            case 1: {
                return "CANCELLED";
            }
            case 2: {
                return "RELEASED";
            }
        }
        return "(unknown)";
    }
}

