/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.network.BufferRecycler;

public class Buffer {
    private final MemorySegment memorySegment;
    private final BufferRecycler recycler;
    private final AtomicInteger referenceCounter;
    private int size;

    public Buffer(MemorySegment memorySegment, int size, BufferRecycler recycler) {
        this.memorySegment = memorySegment;
        this.size = size;
        this.recycler = recycler;
        this.referenceCounter = new AtomicInteger(1);
    }

    private Buffer(Buffer toDuplicate) {
        if (toDuplicate.referenceCounter.getAndIncrement() == 0) {
            throw new IllegalStateException("Buffer was released before duplication.");
        }
        this.memorySegment = toDuplicate.memorySegment;
        this.size = toDuplicate.size;
        this.recycler = toDuplicate.recycler;
        this.referenceCounter = toDuplicate.referenceCounter;
    }

    public MemorySegment getMemorySegment() {
        return this.memorySegment;
    }

    public int size() {
        return this.size;
    }

    public void limitSize(int size) {
        if (size < 0 || size > this.memorySegment.size()) {
            throw new IllegalArgumentException();
        }
        this.size = size;
    }

    public void recycleBuffer() {
        int refCount = this.referenceCounter.decrementAndGet();
        if (refCount == 0) {
            this.recycler.recycle(this.memorySegment);
        }
    }

    public Buffer duplicate() {
        return new Buffer(this);
    }

    public void copyToBuffer(Buffer destinationBuffer) {
        if (this.size() > destinationBuffer.size()) {
            throw new IllegalArgumentException("Destination buffer is too small to store content of source buffer.");
        }
        this.memorySegment.copyTo(0, destinationBuffer.memorySegment, 0, this.size);
    }
}

