/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.ipc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.io.StringRecord;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.InputViewDataInputStreamWrapper;
import org.apache.flink.core.memory.OutputViewDataOutputStreamWrapper;
import org.apache.flink.core.protocols.VersionedProtocol;
import org.apache.flink.runtime.ipc.ConnectionHeader;
import org.apache.flink.runtime.ipc.Status;
import org.apache.flink.util.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Server {
    public static final Logger LOG = LoggerFactory.getLogger(Server.class);
    private static final Class<?>[] EMPTY_ARRAY = new Class[0];
    public static final ByteBuffer HEADER = ByteBuffer.wrap("crpc".getBytes());
    public static final String IPC_THREAD_NAME_PREFIX = "Flink-IPC";
    private static final int MAX_QUEUE_SIZE_PER_HANDLER = 100;
    private static final ThreadLocal<Server> SERVER = new ThreadLocal();
    private static final Map<String, Class<? extends VersionedProtocol>> PROTOCOL_CACHE = new ConcurrentHashMap<String, Class<? extends VersionedProtocol>>();
    private static final ThreadLocal<Call> CurCall = new ThreadLocal();
    private String bindAddress;
    private int port;
    private int handlerCount;
    private Class<? extends IOReadableWritable> invocationClass;
    private int maxIdleTime;
    private int thresholdIdleConnections;
    int maxConnectionsToNuke;
    private int maxQueueSize;
    private int socketSendBufferSize;
    private final boolean tcpNoDelay;
    private volatile boolean running = true;
    private BlockingQueue<Call> callQueue;
    private List<Connection> connectionList = Collections.synchronizedList(new LinkedList());
    private Listener listener = null;
    private Responder responder = null;
    private int numConnections = 0;
    private Handler[] handlers = null;
    private static int NIO_BUFFER_LIMIT = 8192;

    static Class<? extends VersionedProtocol> getProtocolClass(String protocolName) throws ClassNotFoundException {
        Class protocol = PROTOCOL_CACHE.get(protocolName);
        if (protocol == null) {
            protocol = ClassUtils.getProtocolByName((String)protocolName);
            PROTOCOL_CACHE.put(protocolName, protocol);
        }
        return protocol;
    }

    public static Server get() {
        return SERVER.get();
    }

    public static InetAddress getRemoteIp() {
        Call call = CurCall.get();
        if (call != null) {
            return call.connection.socket.getInetAddress();
        }
        return null;
    }

    public static String getRemoteAddress() {
        InetAddress addr = Server.getRemoteIp();
        return addr == null ? null : addr.getHostAddress();
    }

    public static void bind(ServerSocket socket, InetSocketAddress address, int backlog) throws IOException {
        try {
            socket.bind(address, backlog);
        }
        catch (BindException e) {
            BindException bindException = new BindException("Problem binding to " + address + " : " + e.getMessage());
            bindException.initCause(e);
            throw bindException;
        }
        catch (SocketException e) {
            if ("Unresolved address".equals(e.getMessage())) {
                throw new UnknownHostException("Invalid hostname for server: " + address.getHostName());
            }
            throw e;
        }
    }

    protected Server(String bindAddress, int port, Class<? extends IOReadableWritable> paramClass, int handlerCount) throws IOException {
        this(bindAddress, port, paramClass, handlerCount, Integer.toString(port));
    }

    protected Server(String bindAddress, int port, Class<? extends IOReadableWritable> invocationClass, int handlerCount, String serverName) throws IOException {
        this.bindAddress = bindAddress;
        this.port = port;
        this.invocationClass = invocationClass;
        this.handlerCount = handlerCount;
        this.socketSendBufferSize = 0;
        this.maxQueueSize = handlerCount * 100;
        this.callQueue = new LinkedBlockingQueue<Call>(this.maxQueueSize);
        this.maxIdleTime = 2000;
        this.maxConnectionsToNuke = 10;
        this.thresholdIdleConnections = 4000;
        this.listener = new Listener();
        this.port = this.listener.getAddress().getPort();
        this.tcpNoDelay = false;
        this.responder = new Responder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnection(Connection connection) {
        List<Connection> list = this.connectionList;
        synchronized (list) {
            if (this.connectionList.remove(connection)) {
                --this.numConnections;
            }
        }
        try {
            connection.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void setupResponse(ByteArrayOutputStream response, Call call, Status status, IOReadableWritable rv, String errorClass, String error) throws IOException {
        response.reset();
        DataOutputStream out = new DataOutputStream(response);
        out.writeInt(call.id);
        out.writeInt(status.state);
        if (status == Status.SUCCESS) {
            if (rv == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                StringRecord.writeString((DataOutput)out, (String)rv.getClass().getName());
                rv.write((DataOutputView)new OutputViewDataOutputStreamWrapper(out));
            }
        } else {
            StringRecord.writeString((DataOutput)out, (String)errorClass);
            StringRecord.writeString((DataOutput)out, (String)error);
        }
        call.setResponse(ByteBuffer.wrap(response.toByteArray()));
    }

    public void setSocketSendBufSize(int size) {
        this.socketSendBufferSize = size;
    }

    public synchronized void start() throws IOException {
        this.responder.start();
        this.listener.start();
        this.handlers = new Handler[this.handlerCount];
        for (int i = 0; i < this.handlerCount; ++i) {
            this.handlers[i] = new Handler(i);
            this.handlers[i].start();
        }
    }

    public synchronized void stop() {
        int i;
        LOG.debug("Stopping server on {}", (Object)this.port);
        this.running = false;
        if (this.handlers != null) {
            for (i = 0; i < this.handlerCount; ++i) {
                if (this.handlers[i] == null) continue;
                this.handlers[i].interrupt();
            }
        }
        this.listener.interrupt();
        this.listener.doStop();
        this.responder.interrupt();
        this.notifyAll();
        if (this.handlers != null) {
            while (true) {
                for (i = 0; i < this.handlerCount && (this.handlers[i] == null || this.handlers[i].isShutDown()); ++i) {
                }
                if (i >= this.handlerCount) break;
                try {
                    this.wait(100L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
        while (!this.responder.isShutDown()) {
            try {
                this.wait(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        while (!this.listener.isShutDown()) {
            try {
                this.wait(100L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    public synchronized void join() throws InterruptedException {
        while (this.running) {
            this.wait();
        }
    }

    public synchronized InetSocketAddress getListenerAddress() {
        return this.listener.getAddress();
    }

    public abstract IOReadableWritable call(Class<?> var1, IOReadableWritable var2, long var3) throws IOException;

    public int getNumOpenConnections() {
        return this.numConnections;
    }

    public int getCallQueueLen() {
        return this.callQueue.size();
    }

    private static int channelWrite(WritableByteChannel channel, ByteBuffer buffer) throws IOException {
        return buffer.remaining() <= NIO_BUFFER_LIMIT ? channel.write(buffer) : Server.channelIO(null, channel, buffer);
    }

    private static int channelRead(ReadableByteChannel channel, ByteBuffer buffer) throws IOException {
        return buffer.remaining() <= NIO_BUFFER_LIMIT ? channel.read(buffer) : Server.channelIO(channel, null, buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int channelIO(ReadableByteChannel readCh, WritableByteChannel writeCh, ByteBuffer buf) throws IOException {
        int nBytes;
        int originalLimit = buf.limit();
        int initialRemaining = buf.remaining();
        int ret = 0;
        while (buf.remaining() > 0) {
            try {
                int ioSize = Math.min(buf.remaining(), NIO_BUFFER_LIMIT);
                buf.limit(buf.position() + ioSize);
                ret = readCh == null ? writeCh.write(buf) : readCh.read(buf);
                if (ret >= ioSize) continue;
                break;
            }
            finally {
                buf.limit(originalLimit);
            }
        }
        return (nBytes = initialRemaining - buf.remaining()) > 0 ? nBytes : ret;
    }

    public static <T> T newInstance(Class<T> theClass) {
        T result;
        Constructor<T> meth = null;
        try {
            meth = theClass.getDeclaredConstructor(EMPTY_ARRAY);
            meth.setAccessible(true);
            result = meth.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private class Handler
    extends Thread {
        private volatile boolean shutDown = false;

        public Handler(int instanceNumber) {
            this.setDaemon(true);
            this.setName("Flink-IPC Server handler " + instanceNumber + " on " + Server.this.port);
        }

        @Override
        public void run() {
            LOG.debug("{} : starting", (Object)this.getName());
            SERVER.set(Server.this);
            ByteArrayOutputStream buf = new ByteArrayOutputStream(10240);
            while (Server.this.running) {
                try {
                    Call call = (Call)Server.this.callQueue.take();
                    String errorClass = null;
                    String error = null;
                    IOReadableWritable value = null;
                    CurCall.set(call);
                    value = Server.this.call(((Call)call).connection.protocol, call.param, call.timestamp);
                    CurCall.set(null);
                    Server.this.setupResponse(buf, call, error == null ? Status.SUCCESS : Status.ERROR, value, errorClass, error);
                    Server.this.responder.doRespond(call);
                }
                catch (InterruptedException e) {
                    if (!Server.this.running) continue;
                    LOG.error(this.getName() + " caught: ", (Throwable)e);
                }
                catch (Exception e) {
                    LOG.error(this.getName() + " caught: ", (Throwable)e);
                }
            }
            LOG.debug("{} : exiting", (Object)this.getName());
            this.shutDown = true;
        }

        public boolean isShutDown() {
            return this.shutDown;
        }
    }

    private class Connection {
        private boolean headerRead = false;
        private boolean protocolRead = false;
        private SocketChannel channel;
        private ByteBuffer data;
        private ByteBuffer dataLengthBuffer;
        private LinkedList<Call> responseQueue;
        private volatile int rpcCount = 0;
        private long lastContact;
        private int dataLength;
        private Socket socket;
        private String hostAddress;
        private int remotePort;
        ConnectionHeader header = new ConnectionHeader();
        Class<? extends VersionedProtocol> protocol;

        public Connection(SelectionKey key, SocketChannel channel, long lastContact) {
            this.channel = channel;
            this.lastContact = lastContact;
            this.data = null;
            this.dataLengthBuffer = ByteBuffer.allocate(4);
            this.socket = channel.socket();
            InetAddress addr = this.socket.getInetAddress();
            this.hostAddress = addr == null ? "*Unknown*" : addr.getHostAddress();
            this.remotePort = this.socket.getPort();
            this.responseQueue = new LinkedList();
            if (Server.this.socketSendBufferSize != 0) {
                try {
                    this.socket.setSendBufferSize(Server.this.socketSendBufferSize);
                }
                catch (IOException e) {
                    LOG.warn("Connection: unable to set socket send buffer size to " + Server.this.socketSendBufferSize);
                }
            }
        }

        public String toString() {
            return this.getHostAddress() + ":" + this.remotePort;
        }

        public String getHostAddress() {
            return this.hostAddress;
        }

        public void setLastContact(long lastContact) {
            this.lastContact = lastContact;
        }

        private boolean isIdle() {
            return this.rpcCount == 0;
        }

        private void decRpcCount() {
            --this.rpcCount;
        }

        private void incRpcCount() {
            ++this.rpcCount;
        }

        private boolean timedOut(long currentTime) {
            return this.isIdle() && currentTime - this.lastContact > (long)Server.this.maxIdleTime;
        }

        public int readAndProcess() throws IOException, InterruptedException {
            int count;
            while (true) {
                count = -1;
                if (this.dataLengthBuffer.remaining() > 0 && ((count = Server.channelRead(this.channel, this.dataLengthBuffer)) < 0 || this.dataLengthBuffer.remaining() > 0)) {
                    return count;
                }
                if (!this.headerRead) {
                    this.dataLengthBuffer.flip();
                    if (!HEADER.equals(this.dataLengthBuffer)) {
                        LOG.warn("Incorrect header from " + this.hostAddress + ":" + this.remotePort);
                        return -1;
                    }
                    this.dataLengthBuffer.clear();
                    this.headerRead = true;
                    continue;
                }
                if (this.data == null) {
                    this.dataLengthBuffer.flip();
                    this.dataLength = this.dataLengthBuffer.getInt();
                    if (this.dataLength == -1) {
                        this.dataLengthBuffer.clear();
                        return 0;
                    }
                    this.data = ByteBuffer.allocate(this.dataLength);
                    this.incRpcCount();
                }
                count = Server.channelRead(this.channel, this.data);
                if (this.data.remaining() != 0) break;
                this.dataLengthBuffer.clear();
                this.data.flip();
                if (this.protocolRead) {
                    this.processData();
                    this.data = null;
                    return count;
                }
                this.processProtocol();
                this.protocolRead = true;
                this.data = null;
            }
            return count;
        }

        private void processProtocol() throws IOException {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(this.data.array()));
            this.header.read((DataInputView)new InputViewDataInputStreamWrapper(in));
            try {
                String protocolClassName = this.header.getProtocol();
                if (protocolClassName != null) {
                    this.protocol = Server.getProtocolClass(this.header.getProtocol());
                }
            }
            catch (ClassNotFoundException cnfe) {
                LOG.error("Could not find class " + this.header.getProtocol() + ".", (Throwable)cnfe);
                throw new IOException("Unknown protocol: " + this.header.getProtocol());
            }
        }

        private void processData() throws IOException, InterruptedException {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(this.data.array()));
            int id = dis.readInt();
            IOReadableWritable invocation = (IOReadableWritable)Server.newInstance(Server.this.invocationClass);
            invocation.read((DataInputView)new InputViewDataInputStreamWrapper(dis));
            Call call = new Call(id, invocation, this);
            Server.this.callQueue.put(call);
        }

        private synchronized void close() throws IOException {
            this.data = null;
            this.dataLengthBuffer = null;
            if (!this.channel.isOpen()) {
                return;
            }
            try {
                this.socket.shutdownOutput();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.channel.isOpen()) {
                try {
                    this.channel.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class Responder
    extends Thread {
        private Selector writeSelector;
        private int pending;
        static final int PURGE_INTERVAL = 900000;
        private volatile boolean shutDown = false;

        Responder() throws IOException {
            this.setName("Flink-IPC Server Responder");
            this.setDaemon(true);
            this.writeSelector = Selector.open();
            this.pending = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.debug("{} : starting", (Object)this.getName());
            SERVER.set(Server.this);
            long lastPurgeTime = 0L;
            while (Server.this.running) {
                try {
                    ArrayList<Call> calls;
                    this.waitPending();
                    this.writeSelector.select(900000L);
                    Iterator<SelectionKey> iter = this.writeSelector.selectedKeys().iterator();
                    while (iter.hasNext()) {
                        SelectionKey key = iter.next();
                        iter.remove();
                        try {
                            if (!key.isValid() || !key.isWritable()) continue;
                            this.doAsyncWrite(key);
                        }
                        catch (IOException e) {
                            LOG.info(this.getName() + ": doAsyncWrite threw exception " + e);
                        }
                    }
                    long now = System.currentTimeMillis();
                    if (now < lastPurgeTime + 900000L) continue;
                    lastPurgeTime = now;
                    Set<SelectionKey> set = this.writeSelector.keys();
                    synchronized (set) {
                        calls = new ArrayList<Call>(this.writeSelector.keys().size());
                        for (SelectionKey key : this.writeSelector.keys()) {
                            Call call = (Call)key.attachment();
                            if (call == null || key.channel() != call.connection.channel) continue;
                            calls.add(call);
                        }
                    }
                    for (Call call : calls) {
                        try {
                            this.doPurge(call, now);
                        }
                        catch (IOException e) {
                            LOG.warn("Error in purging old calls " + e);
                        }
                    }
                }
                catch (OutOfMemoryError e) {
                    LOG.warn("Out of Memory in server select", (Throwable)e);
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (Exception ie) {}
                }
                catch (Exception e) {
                    LOG.warn("Exception in Responder " + e.toString());
                }
            }
            LOG.debug("Stopping {}", (Object)this.getName());
            this.shutDown = true;
        }

        public boolean isShutDown() {
            return this.shutDown;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doAsyncWrite(SelectionKey key) throws IOException {
            Call call = (Call)key.attachment();
            if (call == null) {
                return;
            }
            if (key.channel() != call.connection.channel) {
                throw new IOException("doAsyncWrite: bad channel");
            }
            LinkedList linkedList = call.connection.responseQueue;
            synchronized (linkedList) {
                if (this.processResponse(call.connection.responseQueue, false)) {
                    try {
                        key.interestOps(0);
                    }
                    catch (CancelledKeyException e) {
                        LOG.warn("Exception while changing ops : " + e);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doPurge(Call call, long now) throws IOException {
            LinkedList responseQueue;
            LinkedList linkedList = responseQueue = call.connection.responseQueue;
            synchronized (linkedList) {
                ListIterator iter = responseQueue.listIterator(0);
                while (iter.hasNext()) {
                    call = (Call)iter.next();
                    if (now <= call.timestamp + 900000L) continue;
                    Server.this.closeConnection(call.connection);
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private boolean processResponse(LinkedList<Call> responseQueue, boolean inHandler) throws IOException {
            Call call;
            int numElements;
            boolean done;
            boolean error;
            block18: {
                error = true;
                done = false;
                numElements = 0;
                call = null;
                LinkedList<Call> linkedList = responseQueue;
                // MONITORENTER : linkedList
                numElements = responseQueue.size();
                if (numElements != 0) break block18;
                error = false;
                boolean bl = true;
                // MONITOREXIT : linkedList
                if (!error) return bl;
                if (call == null) return bl;
                LOG.warn(this.getName() + ", call " + call + ": output error");
                done = true;
                Server.this.closeConnection(call.connection);
                return bl;
            }
            call = responseQueue.removeFirst();
            SocketChannel channel = call.connection.channel;
            int numBytes = Server.channelWrite(channel, call.response);
            if (numBytes < 0) {
                boolean bl = true;
                // MONITOREXIT : linkedList
                if (!error) return bl;
                if (call == null) return bl;
                LOG.warn(this.getName() + ", call " + call + ": output error");
                done = true;
                Server.this.closeConnection(call.connection);
                return bl;
            }
            try {
                if (!call.response.hasRemaining()) {
                    call.connection.decRpcCount();
                    done = numElements == 1;
                } else {
                    call.connection.responseQueue.addFirst(call);
                    if (inHandler) {
                        call.timestamp = System.currentTimeMillis();
                        this.incPending();
                        try {
                            this.writeSelector.wakeup();
                            channel.register(this.writeSelector, 4, call);
                        }
                        catch (ClosedChannelException e) {
                            done = true;
                        }
                        finally {
                            this.decPending();
                        }
                    }
                }
                error = false;
                // MONITOREXIT : linkedList
                return done;
            }
            finally {
                if (error && call != null) {
                    LOG.warn(this.getName() + ", call " + call + ": output error");
                    done = true;
                    Server.this.closeConnection(call.connection);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doRespond(Call call) throws IOException {
            LinkedList linkedList = call.connection.responseQueue;
            synchronized (linkedList) {
                call.connection.responseQueue.addLast(call);
                if (call.connection.responseQueue.size() == 1) {
                    this.processResponse(call.connection.responseQueue, true);
                }
            }
        }

        private synchronized void incPending() {
            ++this.pending;
        }

        private synchronized void decPending() {
            --this.pending;
            this.notify();
        }

        private synchronized void waitPending() throws InterruptedException {
            while (this.pending > 0) {
                this.wait();
            }
        }
    }

    private class Listener
    extends Thread {
        private ServerSocketChannel acceptChannel = null;
        private Selector selector = null;
        private InetSocketAddress address;
        private Random rand = new Random();
        private long lastCleanupRunTime = 0L;
        private long cleanupInterval = 10000L;
        private int backlogLength = 128;
        private volatile boolean shutDown = false;

        public Listener() throws IOException {
            this.address = new InetSocketAddress(Server.this.bindAddress, Server.this.port);
            this.acceptChannel = ServerSocketChannel.open();
            this.acceptChannel.configureBlocking(false);
            Server.bind(this.acceptChannel.socket(), this.address, this.backlogLength);
            Server.this.port = this.acceptChannel.socket().getLocalPort();
            this.selector = Selector.open();
            this.acceptChannel.register(this.selector, 16);
            this.setName("Flink-IPC Server listener on " + Server.this.port);
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanupConnections(boolean force) {
            if (force || Server.this.numConnections > Server.this.thresholdIdleConnections) {
                long currentTime = System.currentTimeMillis();
                if (!force && currentTime - this.lastCleanupRunTime < this.cleanupInterval) {
                    return;
                }
                int start = 0;
                int end = Server.this.numConnections - 1;
                if (!force) {
                    start = this.rand.nextInt() % Server.this.numConnections;
                    end = this.rand.nextInt() % Server.this.numConnections;
                    if (end < start) {
                        int temp = start;
                        start = end;
                        end = temp;
                    }
                }
                int i = start;
                int numNuked = 0;
                while (i <= end) {
                    Connection c;
                    List list = Server.this.connectionList;
                    synchronized (list) {
                        try {
                            c = (Connection)Server.this.connectionList.get(i);
                        }
                        catch (Exception e) {
                            return;
                        }
                    }
                    if (c.timedOut(currentTime)) {
                        Server.this.closeConnection(c);
                        --end;
                        c = null;
                        if (force || ++numNuked != Server.this.maxConnectionsToNuke) continue;
                        break;
                    }
                    ++i;
                }
                this.lastCleanupRunTime = System.currentTimeMillis();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.debug("{} : starting", (Object)this.getName());
            SERVER.set(Server.this);
            while (Server.this.running) {
                SelectionKey key = null;
                try {
                    this.selector.select();
                    Iterator<SelectionKey> iter = this.selector.selectedKeys().iterator();
                    while (iter.hasNext()) {
                        key = iter.next();
                        iter.remove();
                        try {
                            if (key.isValid()) {
                                if (key.isAcceptable()) {
                                    this.doAccept(key);
                                } else if (key.isReadable()) {
                                    this.doRead(key);
                                }
                            }
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        key = null;
                    }
                }
                catch (OutOfMemoryError e) {
                    LOG.warn("Out of Memory in server select", (Throwable)e);
                    this.closeCurrentConnection(key, e);
                    this.cleanupConnections(true);
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (Exception exception) {}
                }
                catch (InterruptedException e) {
                    if (Server.this.running) {
                        LOG.info(this.getName() + " caught: " + e.toString());
                    }
                }
                catch (Exception e) {
                    this.closeCurrentConnection(key, e);
                }
                this.cleanupConnections(false);
            }
            LOG.debug("Stopping {}", (Object)this.getName());
            Listener listener = this;
            synchronized (listener) {
                try {
                    this.acceptChannel.close();
                    this.selector.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.selector = null;
                this.acceptChannel = null;
                while (!Server.this.connectionList.isEmpty()) {
                    Server.this.closeConnection((Connection)Server.this.connectionList.remove(0));
                }
            }
            this.shutDown = true;
        }

        public boolean isShutDown() {
            return this.shutDown;
        }

        private void closeCurrentConnection(SelectionKey key, Throwable e) {
            Connection c;
            if (key != null && (c = (Connection)key.attachment()) != null) {
                Server.this.closeConnection(c);
                Object var3_3 = null;
            }
        }

        InetSocketAddress getAddress() {
            return (InetSocketAddress)this.acceptChannel.socket().getLocalSocketAddress();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doAccept(SelectionKey key) throws IOException, OutOfMemoryError {
            Connection c = null;
            ServerSocketChannel server = (ServerSocketChannel)key.channel();
            for (int i = 0; i < 10; ++i) {
                SocketChannel channel = server.accept();
                if (channel == null) {
                    return;
                }
                channel.configureBlocking(false);
                channel.socket().setTcpNoDelay(Server.this.tcpNoDelay);
                SelectionKey readKey = channel.register(this.selector, 1);
                c = new Connection(readKey, channel, System.currentTimeMillis());
                readKey.attach(c);
                List list = Server.this.connectionList;
                synchronized (list) {
                    Server.this.connectionList.add(Server.this.numConnections, c);
                    Server.this.numConnections++;
                    continue;
                }
            }
        }

        void doRead(SelectionKey key) throws InterruptedException {
            int count = 0;
            Connection c = (Connection)key.attachment();
            if (c == null) {
                return;
            }
            c.setLastContact(System.currentTimeMillis());
            try {
                count = c.readAndProcess();
            }
            catch (InterruptedException ieo) {
                LOG.info(this.getName() + ": readAndProcess caught InterruptedException", (Throwable)ieo);
                throw ieo;
            }
            catch (Exception e) {
                LOG.info(this.getName() + ": readAndProcess threw exception " + e + ". Count of bytes read: " + count, (Throwable)e);
                count = -1;
            }
            if (count < 0) {
                Server.this.closeConnection(c);
                c = null;
            } else {
                c.setLastContact(System.currentTimeMillis());
            }
        }

        synchronized void doStop() {
            if (this.selector != null) {
                this.selector.wakeup();
                Thread.yield();
            }
            if (this.acceptChannel != null) {
                try {
                    this.acceptChannel.socket().close();
                }
                catch (IOException e) {
                    LOG.info(this.getName() + ":Exception in closing listener socket. " + e);
                }
            }
        }
    }

    private static class Call {
        private int id;
        private IOReadableWritable param;
        private Connection connection;
        private long timestamp;
        private ByteBuffer response;

        public Call(int id, IOReadableWritable param, Connection connection) {
            this.id = id;
            this.param = param;
            this.connection = connection;
            this.timestamp = System.currentTimeMillis();
            this.response = null;
        }

        public String toString() {
            return this.param.toString() + " from " + this.connection.toString();
        }

        public void setResponse(ByteBuffer response) {
            this.response = response;
        }
    }
}

