/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.resettable;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.memorymanager.MemoryAllocationException;
import org.apache.flink.runtime.memorymanager.MemoryManager;
import org.apache.flink.runtime.operators.resettable.AbstractBlockResettableIterator;
import org.apache.flink.runtime.util.ResettableIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockResettableIterator<T>
extends AbstractBlockResettableIterator<T>
implements ResettableIterator<T> {
    public static final Logger LOG = LoggerFactory.getLogger(BlockResettableIterator.class);
    protected Iterator<T> input;
    private T nextElement;
    private final T reuseElement;
    private T leftOverElement;
    private boolean readPhase;
    private boolean noMoreBlocks;

    public BlockResettableIterator(MemoryManager memoryManager, Iterator<T> input, TypeSerializer<T> serializer, int numPages, AbstractInvokable ownerTask) throws MemoryAllocationException {
        this(memoryManager, serializer, numPages, ownerTask);
        this.input = input;
    }

    public BlockResettableIterator(MemoryManager memoryManager, TypeSerializer<T> serializer, int numPages, AbstractInvokable ownerTask) throws MemoryAllocationException {
        super(serializer, memoryManager, numPages, ownerTask);
        this.reuseElement = serializer.createInstance();
    }

    public void reopen(Iterator<T> input) throws IOException {
        this.input = input;
        this.noMoreBlocks = false;
        this.closed = false;
        this.nextBlock();
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.nextElement == null) {
                if (this.readPhase) {
                    T tmp = this.getNextRecord(this.reuseElement);
                    if (tmp != null) {
                        this.nextElement = tmp;
                        return true;
                    }
                    return false;
                }
                if (this.input.hasNext()) {
                    T next = this.input.next();
                    if (this.writeNextRecord(next)) {
                        this.nextElement = next;
                        return true;
                    }
                    this.leftOverElement = next;
                    return false;
                }
                this.noMoreBlocks = true;
                return false;
            }
            return true;
        }
        catch (IOException ioex) {
            throw new RuntimeException("Error (de)serializing record in block resettable iterator.", ioex);
        }
    }

    @Override
    public T next() {
        if (this.nextElement == null && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        T out = this.nextElement;
        this.nextElement = null;
        return out;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset() {
        this.readPhase = true;
        super.reset();
    }

    @Override
    public boolean nextBlock() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Iterator has been closed.");
        }
        if (this.noMoreBlocks) {
            return false;
        }
        super.nextBlock();
        T next = this.leftOverElement;
        this.leftOverElement = null;
        if (next == null) {
            if (this.input.hasNext()) {
                next = this.input.next();
            } else {
                this.noMoreBlocks = true;
                return false;
            }
        }
        if (!this.writeNextRecord(next)) {
            throw new IOException("BlockResettableIterator could not serialize record into fresh memory block: Record is too large.");
        }
        this.nextElement = next;
        this.readPhase = false;
        return true;
    }

    public boolean hasFurtherInput() {
        return !this.noMoreBlocks;
    }

    @Override
    public void close() {
        this.readPhase = true;
        super.close();
    }
}

