/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.fs.maprfs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.util.ArrayList;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.fs.hdfs.HadoopBlockLocation;
import org.apache.flink.runtime.fs.hdfs.HadoopDataInputStream;
import org.apache.flink.runtime.fs.hdfs.HadoopDataOutputStream;
import org.apache.flink.runtime.fs.hdfs.HadoopFileStatus;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MapRFileSystem
extends FileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(MapRFileSystem.class);
    private static final String MAPR_FS_IMPL_CLASS = "com.mapr.fs.MapRFileSystem";
    private static final String MAPR_HOME_ENV = "MAPR_HOME";
    private static final String DEFAULT_MAPR_HOME = "/opt/mapr/";
    private static final String MAPR_CLUSTER_CONF_FILE = "/conf/mapr-clusters.conf";
    private final Configuration conf = new Configuration();
    private final Class<? extends org.apache.hadoop.fs.FileSystem> fsClass;
    private org.apache.hadoop.fs.FileSystem fs;

    public MapRFileSystem() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Trying to load class %s to access the MapR file system", MAPR_FS_IMPL_CLASS));
        }
        try {
            this.fsClass = Class.forName(MAPR_FS_IMPL_CLASS);
        }
        catch (Exception e) {
            throw new IOException(String.format("Cannot find class %s, probably the runtime was not compiled against the MapR Hadoop libraries", MAPR_FS_IMPL_CLASS), e);
        }
    }

    public Path getWorkingDirectory() {
        return new Path(this.fs.getWorkingDirectory().toUri());
    }

    public URI getUri() {
        return this.fs.getUri();
    }

    public void initialize(URI path) throws IOException {
        Constructor<? extends org.apache.hadoop.fs.FileSystem> constructor;
        String authority;
        if (LOG.isInfoEnabled()) {
            LOG.info(String.format("Initializing MapR file system for path %s", path.toString()));
        }
        if ((authority = path.getAuthority()) == null || authority.isEmpty()) {
            try {
                this.fs = this.fsClass.newInstance();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        String[] cldbLocations = MapRFileSystem.getCLDBLocations(authority);
        try {
            constructor = this.fsClass.getConstructor(String.class, String[].class);
        }
        catch (NoSuchMethodException e) {
            throw new IOException(e);
        }
        try {
            this.fs = constructor.newInstance(authority, cldbLocations);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        this.fs.initialize(path, this.conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] getCLDBLocations(String authority) throws IOException {
        String maprHome = System.getenv(MAPR_HOME_ENV);
        if (maprHome == null) {
            maprHome = DEFAULT_MAPR_HOME;
        }
        File maprClusterConf = new File(maprHome, MAPR_CLUSTER_CONF_FILE);
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Trying to retrieve MapR cluster configuration from %s", maprClusterConf));
        }
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(maprClusterConf));
            while ((line = br.readLine()) != null) {
                String clusterName;
                line = line.trim();
                String[] fields = (line = line.replace('\t', ' ')).split(" ");
                if (fields == null || fields.length < 1 || !(clusterName = fields[0]).equals(authority)) continue;
                ArrayList<String> cldbLocations = new ArrayList<String>();
                for (int i = 1; i < fields.length; ++i) {
                    if (fields[i].isEmpty() || fields[i].contains("=")) continue;
                    cldbLocations.add(fields[i]);
                }
                if (cldbLocations.isEmpty()) {
                    throw new IOException(String.format("%s contains entry for cluster %s but no CLDB locations.", maprClusterConf, authority));
                }
                String[] stringArray = cldbLocations.toArray(new String[0]);
                return stringArray;
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        throw new IOException(String.format("Unable to find CLDB locations for cluster %s", authority));
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        org.apache.hadoop.fs.FileStatus status = this.fs.getFileStatus(new org.apache.hadoop.fs.Path(f.toString()));
        return new HadoopFileStatus(status);
    }

    public org.apache.flink.core.fs.BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        if (!(file instanceof HadoopFileStatus)) {
            throw new IOException("file is not an instance of DistributedFileStatus");
        }
        HadoopFileStatus f = (HadoopFileStatus)file;
        BlockLocation[] blkLocations = this.fs.getFileBlockLocations(f.getInternalFileStatus(), start, len);
        org.apache.flink.core.fs.BlockLocation[] distBlkLocations = new HadoopBlockLocation[blkLocations.length];
        for (int i = 0; i < distBlkLocations.length; ++i) {
            distBlkLocations[i] = new HadoopBlockLocation(blkLocations[i]);
        }
        return distBlkLocations;
    }

    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        org.apache.hadoop.fs.Path path = new org.apache.hadoop.fs.Path(f.toString());
        org.apache.hadoop.fs.FSDataInputStream fdis = this.fs.open(path, bufferSize);
        return new HadoopDataInputStream(fdis);
    }

    public FSDataInputStream open(Path f) throws IOException {
        org.apache.hadoop.fs.Path path = new org.apache.hadoop.fs.Path(f.toString());
        org.apache.hadoop.fs.FSDataInputStream fdis = this.fs.open(path);
        return new HadoopDataInputStream(fdis);
    }

    public org.apache.flink.core.fs.FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, short replication, long blockSize) throws IOException {
        FSDataOutputStream fdos = this.fs.create(new org.apache.hadoop.fs.Path(f.toString()), overwrite, bufferSize, replication, blockSize);
        return new HadoopDataOutputStream(fdos);
    }

    public org.apache.flink.core.fs.FSDataOutputStream create(Path f, boolean overwrite) throws IOException {
        FSDataOutputStream fdos = this.fs.create(new org.apache.hadoop.fs.Path(f.toString()), overwrite);
        return new HadoopDataOutputStream(fdos);
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        return this.fs.delete(new org.apache.hadoop.fs.Path(f.toString()), recursive);
    }

    public FileStatus[] listStatus(Path f) throws IOException {
        org.apache.hadoop.fs.FileStatus[] hadoopFiles = this.fs.listStatus(new org.apache.hadoop.fs.Path(f.toString()));
        FileStatus[] files = new FileStatus[hadoopFiles.length];
        for (int i = 0; i < files.length; ++i) {
            files[i] = new HadoopFileStatus(hadoopFiles[i]);
        }
        return files;
    }

    public boolean mkdirs(Path f) throws IOException {
        return this.fs.mkdirs(new org.apache.hadoop.fs.Path(f.toString()));
    }

    public boolean rename(Path src, Path dst) throws IOException {
        return this.fs.rename(new org.apache.hadoop.fs.Path(src.toString()), new org.apache.hadoop.fs.Path(dst.toString()));
    }

    public long getDefaultBlockSize() {
        return this.fs.getDefaultBlockSize();
    }

    public boolean isDistributedFS() {
        return true;
    }
}

