/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.instance;

import java.io.IOException;
import java.io.Serializable;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.instance.Hardware;

public final class HardwareDescription
implements IOReadableWritable,
Serializable {
    private static final long serialVersionUID = 3380016608300325361L;
    private int numberOfCPUCores;
    private long sizeOfPhysicalMemory;
    private long sizeOfJvmHeap;
    private long sizeOfManagedMemory;

    public HardwareDescription() {
    }

    public HardwareDescription(int numberOfCPUCores, long sizeOfPhysicalMemory, long sizeOfJvmHeap, long sizeOfManagedMemory) {
        this.numberOfCPUCores = numberOfCPUCores;
        this.sizeOfPhysicalMemory = sizeOfPhysicalMemory;
        this.sizeOfJvmHeap = sizeOfJvmHeap;
        this.sizeOfManagedMemory = sizeOfManagedMemory;
    }

    public int getNumberOfCPUCores() {
        return this.numberOfCPUCores;
    }

    public long getSizeOfPhysicalMemory() {
        return this.sizeOfPhysicalMemory;
    }

    public long getSizeOfJvmHeap() {
        return this.sizeOfJvmHeap;
    }

    public long getSizeOfManagedMemory() {
        return this.sizeOfManagedMemory;
    }

    public void write(DataOutputView out) throws IOException {
        out.writeInt(this.numberOfCPUCores);
        out.writeLong(this.sizeOfPhysicalMemory);
        out.writeLong(this.sizeOfJvmHeap);
        out.writeLong(this.sizeOfManagedMemory);
    }

    public void read(DataInputView in) throws IOException {
        this.numberOfCPUCores = in.readInt();
        this.sizeOfPhysicalMemory = in.readLong();
        this.sizeOfJvmHeap = in.readLong();
        this.sizeOfManagedMemory = in.readLong();
    }

    public String toString() {
        return String.format("cores=%d, physMem=%d, heap=%d, managed=%d", this.numberOfCPUCores, this.sizeOfPhysicalMemory, this.sizeOfJvmHeap, this.sizeOfManagedMemory);
    }

    public static HardwareDescription extractFromSystem(long managedMemory) {
        int numberOfCPUCores = Hardware.getNumberCPUCores();
        long sizeOfJvmHeap = Runtime.getRuntime().maxMemory();
        long sizeOfPhysicalMemory = Hardware.getSizeOfPhysicalMemory();
        return new HardwareDescription(numberOfCPUCores, sizeOfPhysicalMemory, sizeOfJvmHeap, managedMemory);
    }
}

