/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.instance;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.flink.runtime.AbstractID;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.instance.Instance;
import org.apache.flink.runtime.instance.SharedSlot;
import org.apache.flink.runtime.instance.Slot;
import org.apache.flink.runtime.jobgraph.JobID;
import org.apache.flink.runtime.jobmanager.scheduler.Locality;

public class SimpleSlot
extends Slot {
    private static final AtomicReferenceFieldUpdater<SimpleSlot, Execution> VERTEX_UPDATER = AtomicReferenceFieldUpdater.newUpdater(SimpleSlot.class, Execution.class, "executedTask");
    private volatile Execution executedTask;
    private Locality locality = Locality.UNCONSTRAINED;

    public SimpleSlot(JobID jobID, Instance instance, int slotNumber, SharedSlot parent, AbstractID groupID) {
        super(jobID, instance, slotNumber, parent, groupID);
    }

    @Override
    public int getNumberLeaves() {
        return 1;
    }

    public Execution getExecution() {
        return this.executedTask;
    }

    public Locality getLocality() {
        return this.locality;
    }

    public void setLocality(Locality locality) {
        this.locality = locality;
    }

    public boolean setExecutedVertex(Execution executedVertex) {
        if (executedVertex == null) {
            throw new NullPointerException();
        }
        if (this.status != 0) {
            return false;
        }
        if (!VERTEX_UPDATER.compareAndSet(this, null, executedVertex)) {
            return false;
        }
        if (this.status != 0) {
            this.executedTask = null;
            return false;
        }
        return true;
    }

    @Override
    public void cancel() {
        Execution exec;
        if (this.markCancelled() && (exec = this.executedTask) != null && !exec.isFinished()) {
            exec.fail(new Exception("The slot in which the task was scheduled has been killed (probably loss of TaskManager)."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseSlot() {
        try {
            this.cancel();
        }
        finally {
            if (this.getParent() != null) {
                this.getParent().disposeChild(this);
            } else {
                this.instance.returnAllocatedSlot(this);
            }
        }
    }

    @Override
    public String toString() {
        return "SimpleSlot " + super.toString();
    }
}

