/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.instance;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.flink.runtime.AbstractID;
import org.apache.flink.runtime.instance.Instance;
import org.apache.flink.runtime.instance.SharedSlot;
import org.apache.flink.runtime.jobgraph.JobID;

public abstract class Slot {
    protected static final AtomicIntegerFieldUpdater<Slot> STATUS_UPDATER = AtomicIntegerFieldUpdater.newUpdater(Slot.class, "status");
    protected static final int ALLOCATED_AND_ALIVE = 0;
    protected static final int CANCELLED = 1;
    protected static final int RELEASED = 2;
    protected final JobID jobID;
    protected final Instance instance;
    protected final int slotNumber;
    protected volatile int status = 0;
    private boolean dead = false;
    private final AbstractID groupID;
    private final SharedSlot parent;
    private boolean disposed = false;

    public Slot(JobID jobID, Instance instance, int slotNumber, SharedSlot parent, AbstractID groupID) {
        if (jobID == null || instance == null || slotNumber < 0) {
            throw new IllegalArgumentException();
        }
        this.jobID = jobID;
        this.instance = instance;
        this.slotNumber = slotNumber;
        this.parent = parent;
        this.groupID = groupID;
    }

    public JobID getJobID() {
        return this.jobID;
    }

    public Instance getInstance() {
        return this.instance;
    }

    public int getSlotNumber() {
        return this.slotNumber;
    }

    public AbstractID getGroupID() {
        return this.groupID;
    }

    public SharedSlot getParent() {
        return this.parent;
    }

    public Slot getRoot() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRoot();
    }

    public abstract int getNumberLeaves();

    public boolean isAlive() {
        return this.status == 0;
    }

    public boolean isCanceled() {
        return this.status != 0;
    }

    public boolean isReleased() {
        return this.status == 2;
    }

    public abstract void cancel();

    public abstract void releaseSlot();

    public boolean markReleased() {
        return STATUS_UPDATER.compareAndSet(this, 1, 2);
    }

    public boolean markCancelled() {
        return STATUS_UPDATER.compareAndSet(this, 0, 1);
    }

    public boolean markDead() {
        boolean result = !this.dead;
        this.dead = true;
        return result;
    }

    public boolean isDead() {
        return this.dead;
    }

    public boolean markDisposed() {
        boolean result = !this.disposed;
        this.disposed = true;
        return result;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public String toString() {
        return this.hierarchy() + " - " + this.instance.getId() + " - " + Slot.getStateName(this.status);
    }

    protected String hierarchy() {
        return "(" + this.slotNumber + ")" + (this.getParent() != null ? this.getParent().hierarchy() : "");
    }

    private static final String getStateName(int state) {
        switch (state) {
            case 0: {
                return "ALLOCATED/ALIVE";
            }
            case 1: {
                return "CANCELLED";
            }
            case 2: {
                return "RELEASED";
            }
        }
        return "(unknown)";
    }
}

