/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api;

import java.io.IOException;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.runtime.event.task.AbstractTaskEvent;
import org.apache.flink.runtime.io.network.api.AbstractRecordReader;
import org.apache.flink.runtime.io.network.gates.InputGate;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;

public abstract class AbstractSingleGateRecordReader<T extends IOReadableWritable>
extends AbstractRecordReader {
    protected final InputGate<T> inputGate;

    protected AbstractSingleGateRecordReader(AbstractInvokable invokable) {
        this.inputGate = invokable.getEnvironment().createAndRegisterInputGate();
    }

    public int getNumberOfInputChannels() {
        return this.inputGate.getNumberOfInputChannels();
    }

    @Override
    public void publishEvent(AbstractTaskEvent event) throws IOException, InterruptedException {
        this.inputGate.publishEvent(event);
    }

    @Override
    public void publishEvent(AbstractTaskEvent event, int inputNumber) throws IOException, InterruptedException {
        if (inputNumber != 0) {
            throw new IOException("RecordReader has only 1 input");
        }
        this.publishEvent(event);
    }

    public InputGate<T> getInputGate() {
        return this.inputGate;
    }
}

