/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.ipc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.SocketFactory;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.io.StringRecord;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.InputViewDataInputStreamWrapper;
import org.apache.flink.runtime.io.network.serialization.DataOutputSerializer;
import org.apache.flink.runtime.ipc.ConnectionHeader;
import org.apache.flink.runtime.ipc.RemoteException;
import org.apache.flink.runtime.ipc.Server;
import org.apache.flink.runtime.ipc.Status;
import org.apache.flink.runtime.net.NetUtils;
import org.apache.flink.runtime.util.IOUtils;
import org.apache.flink.util.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Client {
    public static final Logger LOG = LoggerFactory.getLogger(Client.class);
    private Hashtable<ConnectionId, Connection> connections = new Hashtable();
    private int counter;
    private AtomicBoolean running = new AtomicBoolean(true);
    private final int maxIdleTime;
    private final int maxRetries;
    private boolean tcpNoDelay = false;
    private int pingInterval = 60000;
    private SocketFactory socketFactory;
    private int refCount = 1;
    static final int DEFAULT_PING_INTERVAL = 60000;
    static final int PING_CALL_ID = -1;

    synchronized void incCount() {
        ++this.refCount;
    }

    synchronized void decCount() {
        --this.refCount;
    }

    synchronized boolean isZeroReference() {
        return this.refCount == 0;
    }

    public Client(SocketFactory factory) {
        this.maxIdleTime = 1000;
        this.maxRetries = 10;
        this.socketFactory = factory;
    }

    public Client() {
        this(NetUtils.getDefaultSocketFactory());
    }

    SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (!this.running.compareAndSet(true, false)) {
            return;
        }
        Hashtable<ConnectionId, Connection> hashtable = this.connections;
        synchronized (hashtable) {
            for (Connection conn : this.connections.values()) {
                conn.interrupt();
            }
        }
        while (!this.connections.isEmpty()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOReadableWritable call(IOReadableWritable param, InetSocketAddress addr, Class<?> protocol) throws InterruptedException, IOException {
        Call call = new Call(param);
        Connection connection = this.getConnection(addr, protocol, call);
        connection.sendParam(call);
        Call call2 = call;
        synchronized (call2) {
            while (!call.done) {
                try {
                    call.wait();
                }
                catch (InterruptedException ignored) {}
            }
            if (call.error != null) {
                if (call.error instanceof RemoteException) {
                    call.error.fillInStackTrace();
                    throw call.error;
                }
                throw this.wrapException(addr, call.error);
            }
            return call.value;
        }
    }

    private IOException wrapException(InetSocketAddress addr, IOException exception) {
        if (exception instanceof ConnectException) {
            return (ConnectException)new ConnectException("Call to " + addr + " failed on connection exception: " + exception).initCause(exception);
        }
        if (exception instanceof SocketTimeoutException) {
            return (SocketTimeoutException)new SocketTimeoutException("Call to " + addr + " failed on socket timeout exception: " + exception).initCause(exception);
        }
        return (IOException)new IOException("Call to " + addr + " failed on local exception: " + exception).initCause(exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getConnection(InetSocketAddress addr, Class<?> protocol, Call call) throws IOException {
        Connection connection;
        if (!this.running.get()) {
            throw new IOException("The client is stopped");
        }
        ConnectionId remoteId = new ConnectionId(addr, protocol);
        do {
            Hashtable<ConnectionId, Connection> hashtable = this.connections;
            synchronized (hashtable) {
                connection = this.connections.get(remoteId);
                if (connection == null) {
                    connection = new Connection(remoteId);
                    this.connections.put(remoteId, connection);
                }
            }
        } while (!connection.addCall(call));
        connection.setupIOstreams();
        return connection;
    }

    private static class ConnectionId {
        InetSocketAddress address;
        Class<?> protocol;
        private static final int PRIME = 16777619;

        ConnectionId(InetSocketAddress address, Class<?> protocol) {
            this.protocol = protocol;
            this.address = address;
        }

        InetSocketAddress getAddress() {
            return this.address;
        }

        Class<?> getProtocol() {
            return this.protocol;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ConnectionId) {
                ConnectionId id = (ConnectionId)obj;
                return this.address.equals(id.address) && this.protocol == id.protocol;
            }
            return false;
        }

        public int hashCode() {
            return this.address.hashCode() + 16777619 * System.identityHashCode(this.protocol);
        }
    }

    private static class ParallelResults {
        private IOReadableWritable[] values;
        private int size;
        private int count;

        private ParallelResults() {
        }

        public synchronized void callComplete(ParallelCall call) {
            this.values[((ParallelCall)call).index] = call.value;
            ++this.count;
            if (this.count == this.size) {
                this.notify();
            }
        }
    }

    private class ParallelCall
    extends Call {
        private final ParallelResults results;
        private final int index;

        public ParallelCall(IOReadableWritable param, ParallelResults results, int index) {
            super(param);
            this.results = results;
            this.index = index;
        }

        @Override
        protected void callComplete() {
            this.results.callComplete(this);
        }
    }

    private class Connection
    extends Thread {
        private InetSocketAddress server;
        private ConnectionHeader header;
        private ConnectionId remoteId;
        private Socket socket = null;
        private DataInputStream in;
        private DataOutputStream out;
        private Hashtable<Integer, Call> calls = new Hashtable();
        private AtomicLong lastActivity = new AtomicLong();
        private AtomicBoolean shouldCloseConnection = new AtomicBoolean();
        private IOException closeException;

        public Connection(ConnectionId remoteId) throws IOException {
            this.remoteId = remoteId;
            this.server = remoteId.getAddress();
            if (this.server.isUnresolved()) {
                throw new UnknownHostException("unknown host: " + remoteId.getAddress().getHostName());
            }
            Class<?> protocol = remoteId.getProtocol();
            this.header = new ConnectionHeader(protocol == null ? null : protocol.getName());
            this.setName("Flink-IPC Client (" + Client.this.socketFactory.hashCode() + ") connection to " + remoteId.getAddress().toString() + " from an unknown user");
            this.setDaemon(true);
        }

        private void touch() {
            this.lastActivity.set(System.currentTimeMillis());
        }

        private synchronized boolean addCall(Call call) {
            if (this.shouldCloseConnection.get()) {
                return false;
            }
            this.calls.put(call.id, call);
            this.notify();
            return true;
        }

        private synchronized void setupIOstreams() {
            if (this.socket != null || this.shouldCloseConnection.get()) {
                return;
            }
            int ioFailures = 0;
            int timeoutFailures = 0;
            try {
                while (true) {
                    try {
                        this.socket = Client.this.socketFactory.createSocket();
                        this.socket.setTcpNoDelay(Client.this.tcpNoDelay);
                        NetUtils.connect(this.socket, this.remoteId.getAddress(), 20000);
                        this.socket.setSoTimeout(Client.this.pingInterval);
                    }
                    catch (SocketTimeoutException toe) {
                        int n = timeoutFailures;
                        timeoutFailures = (short)(timeoutFailures + 1);
                        this.handleConnectionFailure(n, 45, toe);
                        continue;
                    }
                    catch (IOException ie) {
                        int n = ioFailures;
                        ioFailures = (short)(ioFailures + 1);
                        this.handleConnectionFailure(n, Client.this.maxRetries, ie);
                        continue;
                    }
                    break;
                }
                this.in = new DataInputStream(new BufferedInputStream(new PingInputStream(NetUtils.getInputStream(this.socket))));
                this.out = new DataOutputStream(new BufferedOutputStream(NetUtils.getOutputStream(this.socket)));
                this.writeHeader();
                this.touch();
                this.start();
            }
            catch (IOException e) {
                this.markClosed(e);
                this.close();
            }
        }

        private void handleConnectionFailure(int curRetries, int maxRetries, IOException ioe) throws IOException {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                LOG.warn("Not able to close a socket", (Throwable)e);
            }
            this.socket = null;
            if (curRetries >= maxRetries) {
                throw ioe;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
            LOG.info("Retrying connect to server: " + this.server + ". Already tried " + curRetries + " time(s).");
        }

        private void writeHeader() throws IOException {
            this.out.write(Server.HEADER.array());
            DataOutputSerializer buf = new DataOutputSerializer(4 + this.header.getProtocol().getBytes().length + 1);
            this.header.write(buf);
            ByteBuffer wrapper = buf.wrapAsByteBuffer();
            int bufLen = wrapper.limit();
            this.out.writeInt(bufLen);
            this.out.write(wrapper.array(), 0, bufLen);
        }

        private synchronized boolean waitForWork() {
            long timeout;
            if (this.calls.isEmpty() && !this.shouldCloseConnection.get() && Client.this.running.get() && (timeout = (long)Client.this.maxIdleTime - (System.currentTimeMillis() - this.lastActivity.get())) > 0L) {
                try {
                    this.wait(timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!this.calls.isEmpty() && !this.shouldCloseConnection.get() && Client.this.running.get()) {
                return true;
            }
            if (this.shouldCloseConnection.get()) {
                return false;
            }
            if (this.calls.isEmpty()) {
                this.markClosed(null);
                return false;
            }
            this.markClosed((IOException)new IOException().initCause(new InterruptedException()));
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void sendPing() throws IOException {
            long curTime = System.currentTimeMillis();
            if (curTime - this.lastActivity.get() >= (long)Client.this.pingInterval) {
                this.lastActivity.set(curTime);
                DataOutputStream dataOutputStream = this.out;
                synchronized (dataOutputStream) {
                    this.out.writeInt(-1);
                    this.out.flush();
                }
            }
        }

        @Override
        public void run() {
            while (this.waitForWork()) {
                this.receiveResponse();
            }
            this.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendParam(Call call) {
            if (this.shouldCloseConnection.get()) {
                return;
            }
            DataOutputSerializer d = null;
            try {
                DataOutputStream dataOutputStream = this.out;
                synchronized (dataOutputStream) {
                    d = new DataOutputSerializer(64);
                    d.writeInt(call.id);
                    call.param.write((DataOutputView)d);
                    ByteBuffer wrapper = d.wrapAsByteBuffer();
                    byte[] data = wrapper.array();
                    int dataLength = wrapper.limit();
                    this.out.writeInt(dataLength);
                    this.out.write(data, 0, dataLength);
                    this.out.flush();
                }
            }
            catch (IOException e) {
                this.markClosed(e);
            }
        }

        private void receiveResponse() {
            block16: {
                if (this.shouldCloseConnection.get()) {
                    return;
                }
                this.touch();
                try {
                    int id = this.in.readInt();
                    Call call = this.calls.remove(id);
                    int state = this.in.readInt();
                    if (state == Status.SUCCESS.state) {
                        IOReadableWritable value = null;
                        boolean isNotNull = this.in.readBoolean();
                        if (isNotNull) {
                            String returnClassName = StringRecord.readString((DataInput)this.in);
                            Class c = null;
                            try {
                                c = ClassUtils.getRecordByName((String)returnClassName);
                            }
                            catch (ClassNotFoundException e) {
                                LOG.error("Could not find class " + returnClassName + ".", (Throwable)e);
                            }
                            try {
                                value = (IOReadableWritable)c.newInstance();
                            }
                            catch (InstantiationException e) {
                                LOG.error("Could not instantiate object of class " + c.getCanonicalName() + ".", (Throwable)e);
                            }
                            catch (IllegalAccessException e) {
                                LOG.error("Error instantiating object of class " + c.getCanonicalName() + ".", (Throwable)e);
                            }
                            try {
                                value.read((DataInputView)new InputViewDataInputStreamWrapper(this.in));
                            }
                            catch (Throwable e) {
                                LOG.error("Exception while receiving an RPC call", e);
                            }
                        }
                        call.setValue(value);
                        break block16;
                    }
                    if (state == Status.ERROR.state) {
                        call.setException(new RemoteException(StringRecord.readString((DataInput)this.in), StringRecord.readString((DataInput)this.in)));
                    } else if (state == Status.FATAL.state) {
                        this.markClosed(new RemoteException(StringRecord.readString((DataInput)this.in), StringRecord.readString((DataInput)this.in)));
                    }
                }
                catch (IOException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Closing RPC connection due to exception", (Throwable)e);
                    }
                    this.markClosed(e);
                }
            }
        }

        private synchronized void markClosed(IOException e) {
            if (this.shouldCloseConnection.compareAndSet(false, true)) {
                this.closeException = e;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void close() {
            if (!this.shouldCloseConnection.get()) {
                LOG.error("The connection is not in the closed state");
                return;
            }
            Hashtable hashtable = Client.this.connections;
            synchronized (hashtable) {
                if (Client.this.connections.get(this.remoteId) == this) {
                    Client.this.connections.remove(this.remoteId);
                }
            }
            IOUtils.closeStream(this.out);
            IOUtils.closeStream(this.in);
            if (this.closeException == null) {
                if (!this.calls.isEmpty()) {
                    LOG.warn("A connection is closed for no cause and calls are not empty");
                    this.closeException = new IOException("Unexpected closed connection");
                    this.cleanupCalls();
                }
            } else {
                this.cleanupCalls();
            }
        }

        private void cleanupCalls() {
            Iterator<Map.Entry<Integer, Call>> itor = this.calls.entrySet().iterator();
            while (itor.hasNext()) {
                Call c = itor.next().getValue();
                c.setException(this.closeException);
                itor.remove();
            }
        }

        private class PingInputStream
        extends FilterInputStream {
            protected PingInputStream(InputStream in) {
                super(in);
            }

            private void handleTimeout(SocketTimeoutException e) throws IOException {
                if (Connection.this.shouldCloseConnection.get() || !Client.this.running.get()) {
                    throw e;
                }
                Connection.this.sendPing();
            }

            @Override
            public int read() throws IOException {
                while (true) {
                    try {
                        return super.read();
                    }
                    catch (SocketTimeoutException e) {
                        this.handleTimeout(e);
                        continue;
                    }
                    break;
                }
            }

            @Override
            public int read(byte[] buf, int off, int len) throws IOException {
                while (true) {
                    try {
                        return super.read(buf, off, len);
                    }
                    catch (SocketTimeoutException e) {
                        this.handleTimeout(e);
                        continue;
                    }
                    break;
                }
            }
        }
    }

    private class Call {
        int id;
        IOReadableWritable param;
        IOReadableWritable value;
        IOException error;
        boolean done;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Call(IOReadableWritable param) {
            this.param = param;
            Client client2 = Client.this;
            synchronized (client2) {
                this.id = Client.this.counter++;
            }
        }

        protected synchronized void callComplete() {
            this.done = true;
            this.notify();
        }

        public synchronized void setException(IOException error) {
            this.error = error;
            this.callComplete();
        }

        public synchronized void setValue(IOReadableWritable value) {
            this.value = value;
            this.callComplete();
        }
    }
}

