/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph;

import org.apache.flink.api.common.io.FinalizeOnMaster;
import org.apache.flink.api.common.io.InitializeOnMaster;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.operators.util.UserCodeWrapper;
import org.apache.flink.runtime.jobgraph.AbstractJobVertex;
import org.apache.flink.runtime.operators.util.TaskConfig;

public class OutputFormatVertex
extends AbstractJobVertex {
    private static final long serialVersionUID = 1L;
    private String formatDescription;

    public OutputFormatVertex(String name) {
        super(name);
    }

    public void setFormatDescription(String formatDescription) {
        this.formatDescription = formatDescription;
    }

    public String getFormatDescription() {
        return this.formatDescription;
    }

    @Override
    public void initializeOnMaster(ClassLoader loader) throws Exception {
        OutputFormat outputFormat;
        UserCodeWrapper wrapper;
        TaskConfig cfg = new TaskConfig(this.getConfiguration());
        try {
            wrapper = cfg.getStubWrapper(loader);
        }
        catch (Throwable t) {
            throw new Exception("Deserializing the OutputFormat (" + this.formatDescription + ") failed: " + t.getMessage(), t);
        }
        if (wrapper == null) {
            throw new Exception("No input format present in InputFormatVertex's task configuration.");
        }
        try {
            outputFormat = (OutputFormat)wrapper.getUserCodeObject(OutputFormat.class, loader);
        }
        catch (Throwable t) {
            throw new Exception("Instantiating the OutputFormat (" + this.formatDescription + ") failed: " + t.getMessage(), t);
        }
        try {
            outputFormat.configure(cfg.getStubParameters());
        }
        catch (Throwable t) {
            throw new Exception("Configuring the OutputFormat (" + this.formatDescription + ") failed: " + t.getMessage(), t);
        }
        if (outputFormat instanceof InitializeOnMaster) {
            ((InitializeOnMaster)outputFormat).initializeGlobal(this.getParallelism());
        }
    }

    @Override
    public void finalizeOnMaster(ClassLoader loader) throws Exception {
        OutputFormat outputFormat;
        UserCodeWrapper wrapper;
        TaskConfig cfg = new TaskConfig(this.getConfiguration());
        try {
            wrapper = cfg.getStubWrapper(loader);
        }
        catch (Throwable t) {
            throw new Exception("Deserializing the OutputFormat (" + this.formatDescription + ") failed: " + t.getMessage(), t);
        }
        if (wrapper == null) {
            throw new Exception("No input format present in InputFormatVertex's task configuration.");
        }
        try {
            outputFormat = (OutputFormat)wrapper.getUserCodeObject(OutputFormat.class, loader);
        }
        catch (Throwable t) {
            throw new Exception("Instantiating the OutputFormat (" + this.formatDescription + ") failed: " + t.getMessage(), t);
        }
        try {
            outputFormat.configure(cfg.getStubParameters());
        }
        catch (Throwable t) {
            throw new Exception("Configuring the OutputFormat (" + this.formatDescription + ") failed: " + t.getMessage(), t);
        }
        if (outputFormat instanceof FinalizeOnMaster) {
            ((FinalizeOnMaster)outputFormat).finalizeGlobal(this.getParallelism());
        }
    }
}

