/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.accumulators;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.runtime.jobgraph.JobID;
import org.apache.flink.runtime.jobmanager.accumulators.JobAccumulators;

public class AccumulatorManager {
    private final Map<JobID, JobAccumulators> jobAccumulators = new HashMap<JobID, JobAccumulators>();
    private final LinkedList<JobID> lru = new LinkedList();
    private int maxEntries;

    public AccumulatorManager(int maxEntries) {
        this.maxEntries = maxEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processIncomingAccumulators(JobID jobID, Map<String, Accumulator<?, ?>> newAccumulators) {
        Map<JobID, JobAccumulators> map = this.jobAccumulators;
        synchronized (map) {
            JobAccumulators jobAccumulators = this.jobAccumulators.get(jobID);
            if (jobAccumulators == null) {
                jobAccumulators = new JobAccumulators();
                this.jobAccumulators.put(jobID, jobAccumulators);
                this.cleanup(jobID);
            }
            jobAccumulators.processNew(newAccumulators);
        }
    }

    public Map<String, Accumulator<?, ?>> getJobAccumulators(JobID jobID) {
        JobAccumulators jobAccumulators = this.jobAccumulators.get(jobID);
        if (jobAccumulators == null) {
            return new HashMap();
        }
        return jobAccumulators.getAccumulators();
    }

    private void cleanup(JobID jobId) {
        if (!this.lru.contains(jobId)) {
            this.lru.addFirst(jobId);
        }
        if (this.lru.size() > this.maxEntries) {
            JobID toRemove = this.lru.removeLast();
            this.jobAccumulators.remove(toRemove);
        }
    }
}

