/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.archive;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.flink.runtime.event.job.AbstractEvent;
import org.apache.flink.runtime.event.job.RecentJobEvent;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.jobgraph.JobID;
import org.apache.flink.runtime.jobmanager.archive.ArchiveListener;

public class MemoryArchivist
implements ArchiveListener {
    private final Object lock = new Object();
    private final Map<JobID, List<AbstractEvent>> collectedEvents = new HashMap<JobID, List<AbstractEvent>>();
    private final Map<JobID, RecentJobEvent> oldJobs = new HashMap<JobID, RecentJobEvent>();
    private final Map<JobID, ExecutionGraph> graphs = new HashMap<JobID, ExecutionGraph>();
    private final LinkedList<JobID> lru = new LinkedList();
    private final int max_entries;

    public MemoryArchivist(int max_entries) {
        this.max_entries = max_entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void archiveExecutionGraph(JobID jobId, ExecutionGraph graph) {
        Object object = this.lock;
        synchronized (object) {
            this.graphs.put(jobId, graph);
            this.cleanup(jobId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void archiveEvent(JobID jobId, AbstractEvent event) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.collectedEvents.containsKey(jobId)) {
                this.collectedEvents.put(jobId, new ArrayList());
            }
            this.collectedEvents.get(jobId).add(event);
            this.cleanup(jobId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void archiveJobevent(JobID jobId, RecentJobEvent event) {
        Object object = this.lock;
        synchronized (object) {
            this.oldJobs.put(jobId, event);
            this.cleanup(jobId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RecentJobEvent> getJobs() {
        Object object = this.lock;
        synchronized (object) {
            return new ArrayList<RecentJobEvent>(this.oldJobs.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RecentJobEvent getJob(JobID jobId) {
        Object object = this.lock;
        synchronized (object) {
            return this.oldJobs.get(jobId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AbstractEvent> getEvents(JobID jobID) {
        Map<JobID, ExecutionGraph> map = this.graphs;
        synchronized (map) {
            return this.collectedEvents.get(jobID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutionGraph getExecutionGraph(JobID jid) {
        Object object = this.lock;
        synchronized (object) {
            return this.graphs.get(jid);
        }
    }

    private void cleanup(JobID jobId) {
        if (!this.lru.contains(jobId)) {
            this.lru.addFirst(jobId);
        }
        if (this.lru.size() > this.max_entries) {
            JobID toRemove = this.lru.removeLast();
            this.collectedEvents.remove(toRemove);
            this.oldJobs.remove(toRemove);
            this.graphs.remove(toRemove);
        }
    }
}

