/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.scheduler;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.flink.runtime.AbstractID;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.instance.Instance;
import org.apache.flink.runtime.instance.SharedSlot;
import org.apache.flink.runtime.instance.SimpleSlot;
import org.apache.flink.runtime.instance.Slot;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationConstraint;
import org.apache.flink.runtime.jobmanager.scheduler.Locality;
import org.apache.flink.runtime.jobmanager.scheduler.Scheduler;
import org.slf4j.Logger;

public class SlotSharingGroupAssignment
implements Serializable {
    static final long serialVersionUID = 42L;
    private static final Logger LOG = Scheduler.LOG;
    private final transient Object lock = new Object();
    private final Set<SharedSlot> allSlots = new LinkedHashSet<SharedSlot>();
    private final Map<AbstractID, Map<Instance, List<SharedSlot>>> availableSlotsPerJid = new LinkedHashMap<AbstractID, Map<Instance, List<SharedSlot>>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleSlot addSharedSlotAndAllocateSubSlot(SharedSlot sharedSlot, Locality locality, AbstractID groupId, CoLocationConstraint constraint) {
        Instance location = sharedSlot.getInstance();
        Object object = this.lock;
        synchronized (object) {
            this.allSlots.add(sharedSlot);
            SimpleSlot subSlot = null;
            if (constraint == null) {
                subSlot = sharedSlot.allocateSubSlot(groupId);
            } else {
                SharedSlot constraintGroupSlot = sharedSlot.allocateSharedSlot(groupId);
                subSlot = constraintGroupSlot.allocateSubSlot(null);
            }
            subSlot.setLocality(locality);
            boolean entryForNewJidExists = false;
            for (Map.Entry<AbstractID, Map<Instance, List<SharedSlot>>> entry : this.availableSlotsPerJid.entrySet()) {
                if (entry.getKey().equals(groupId)) {
                    entryForNewJidExists = true;
                    continue;
                }
                Map<Instance, List<SharedSlot>> available = entry.getValue();
                SlotSharingGroupAssignment.putIntoMultiMap(available, location, sharedSlot);
            }
            if (!entryForNewJidExists) {
                this.availableSlotsPerJid.put(groupId, new LinkedHashMap());
            }
            return subSlot;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleSlot getSlotForTask(ExecutionVertex vertex) {
        Object object = this.lock;
        synchronized (object) {
            Pair<SharedSlot, Locality> p = this.getSlotForTaskInternal(vertex.getJobvertexId(), vertex, vertex.getPreferredLocations(), false);
            if (p != null) {
                SharedSlot ss = (SharedSlot)p.getLeft();
                SimpleSlot slot = ss.allocateSubSlot(vertex.getJobvertexId());
                slot.setLocality((Locality)((Object)p.getRight()));
                return slot;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleSlot getSlotForTask(ExecutionVertex vertex, CoLocationConstraint constraint) {
        Object object = this.lock;
        synchronized (object) {
            SharedSlot shared = constraint.getSharedSlot();
            if (shared != null && !shared.isDead()) {
                SimpleSlot subslot = shared.allocateSubSlot(null);
                subslot.setLocality(Locality.LOCAL);
                return subslot;
            }
            if (shared == null) {
                Pair<SharedSlot, Locality> p = this.getSlotForTaskInternal(constraint.getGroupId(), vertex, vertex.getPreferredLocations(), false);
                if (p == null) {
                    return null;
                }
                shared = (SharedSlot)p.getLeft();
                Locality l = (Locality)((Object)p.getRight());
                SharedSlot constraintGroupSlot = shared.allocateSharedSlot(constraint.getGroupId());
                SimpleSlot sub = constraintGroupSlot.allocateSubSlot(null);
                sub.setLocality(l);
                if (l != Locality.NON_LOCAL) {
                    constraint.setSharedSlot(constraintGroupSlot);
                }
                return sub;
            }
            Instance location = shared.getInstance();
            Pair<SharedSlot, Locality> p = this.getSlotForTaskInternal(constraint.getGroupId(), vertex, Collections.singleton(location), true);
            if (p == null) {
                return null;
            }
            shared = (SharedSlot)p.getLeft();
            SharedSlot constraintGroupSlot = shared.allocateSharedSlot(constraint.getGroupId());
            constraint.setSharedSlot(constraintGroupSlot);
            SimpleSlot subSlot = constraintGroupSlot.allocateSubSlot(null);
            subSlot.setLocality(Locality.LOCAL);
            return subSlot;
        }
    }

    private Pair<SharedSlot, Locality> getSlotForTaskInternal(AbstractID groupId, ExecutionVertex vertex, Iterable<Instance> preferredLocations, boolean localOnly) {
        Map<Instance, List<SharedSlot>> slotsForGroup = this.availableSlotsPerJid.get(groupId);
        if (this.allSlots.isEmpty()) {
            return null;
        }
        if (slotsForGroup == null) {
            slotsForGroup = new LinkedHashMap<Instance, List<SharedSlot>>();
            this.availableSlotsPerJid.put(groupId, slotsForGroup);
            for (SharedSlot availableSlot : this.allSlots) {
                SlotSharingGroupAssignment.putIntoMultiMap(slotsForGroup, availableSlot.getInstance(), availableSlot);
            }
        } else if (slotsForGroup.isEmpty()) {
            return null;
        }
        boolean didNotGetPreferred = false;
        if (preferredLocations != null) {
            for (Instance location : preferredLocations) {
                didNotGetPreferred = true;
                SharedSlot slot = SlotSharingGroupAssignment.removeFromMultiMap(slotsForGroup, location);
                if (slot == null || slot.isDead()) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Local assignment in shared group : " + vertex + " --> " + slot);
                }
                return new ImmutablePair((Object)slot, (Object)Locality.LOCAL);
            }
        }
        if (didNotGetPreferred && localOnly) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No local assignment in shared possible for " + vertex);
            }
            return null;
        }
        SharedSlot slot = SlotSharingGroupAssignment.pollFromMultiMap(slotsForGroup);
        if (slot != null && !slot.isDead()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((didNotGetPreferred ? "Non-local" : "Unconstrained") + " assignment in shared group : " + vertex + " --> " + slot);
            }
            return new ImmutablePair((Object)slot, (Object)(didNotGetPreferred ? Locality.NON_LOCAL : Locality.UNCONSTRAINED));
        }
        return null;
    }

    private void removeSharedSlot(SharedSlot sharedSlot) {
        if (!this.allSlots.contains(sharedSlot)) {
            throw new IllegalArgumentException("Slot was not associated with this SlotSharingGroup before.");
        }
        this.allSlots.remove(sharedSlot);
        Instance location = sharedSlot.getInstance();
        for (Map.Entry<AbstractID, Map<Instance, List<SharedSlot>>> mapEntry : this.availableSlotsPerJid.entrySet()) {
            Map<Instance, List<SharedSlot>> map = mapEntry.getValue();
            List<SharedSlot> list = map.get(location);
            if (list == null || !list.remove(sharedSlot)) {
                throw new IllegalStateException("Bug: SharedSlot was not available to another vertex type that it was not allocated for before.");
            }
            if (!list.isEmpty()) continue;
            map.remove(location);
        }
        sharedSlot.markCancelled();
        this.returnAllocatedSlot(sharedSlot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSharedSlot(SharedSlot sharedSlot) {
        Object object = this.lock;
        synchronized (object) {
            Set<Slot> subSlots = sharedSlot.getSubSlots();
            for (Slot subSlot : subSlots) {
                subSlot.markDisposed();
                if (subSlot instanceof SharedSlot) {
                    this.releaseSharedSlot((SharedSlot)subSlot);
                    continue;
                }
                if (!(subSlot instanceof SimpleSlot)) continue;
                this.releaseSimpleSlot((SimpleSlot)subSlot);
            }
            subSlots.clear();
            this.returnSlot(sharedSlot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSimpleSlot(SimpleSlot simpleSlot) {
        Object object = this.lock;
        synchronized (object) {
            simpleSlot.cancel();
            this.returnSlot(simpleSlot);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void returnSlot(Slot slot) {
        if (!slot.markDead()) return;
        if (slot.getParent() == null) {
            if (!(slot instanceof SharedSlot)) throw new IllegalStateException("Simple slot cannot be returned from SlotSharingGroupAssignment.");
            this.removeSharedSlot((SharedSlot)slot);
            return;
        } else {
            AbstractID groupID = slot.getGroupID();
            SharedSlot parent = slot.getParent();
            if (groupID != null) {
                if (!this.allSlots.contains(parent)) {
                    throw new IllegalArgumentException("Slot was not associated with this SlotSharingGroup before.");
                }
                Map<Instance, List<SharedSlot>> slotsForJid = this.availableSlotsPerJid.get(groupID);
                if (slotsForJid == null) {
                    throw new IllegalStateException("Trying to return a slot for group " + groupID + " when available slots indicated that all slots were available.");
                }
                SlotSharingGroupAssignment.putIntoMultiMap(slotsForJid, parent.getInstance(), parent);
            }
            if (!slot.markDisposed() || slot.getParent().freeSubSlot(slot) != 0) return;
            this.releaseSharedSlot(slot.getParent());
        }
    }

    private void returnAllocatedSlot(SharedSlot slot) {
        slot.getInstance().returnAllocatedSlot(slot);
    }

    public int getNumberOfSlots() {
        return this.allSlots.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfAvailableSlotsForJid(JobVertexID jid) {
        Object object = this.lock;
        synchronized (object) {
            Map<Instance, List<SharedSlot>> available = this.availableSlotsPerJid.get(jid);
            if (available != null) {
                HashSet<SharedSlot> set = new HashSet<SharedSlot>();
                for (List<SharedSlot> list : available.values()) {
                    for (SharedSlot slot : list) {
                        set.add(slot);
                    }
                }
                return set.size();
            }
            return this.allSlots.size();
        }
    }

    private static final void putIntoMultiMap(Map<Instance, List<SharedSlot>> map, Instance location, SharedSlot slot) {
        List<SharedSlot> slotsForInstance = map.get(location);
        if (slotsForInstance == null) {
            slotsForInstance = new ArrayList<SharedSlot>();
            map.put(location, slotsForInstance);
        }
        slotsForInstance.add(slot);
    }

    private static final SharedSlot removeFromMultiMap(Map<Instance, List<SharedSlot>> map, Instance location) {
        List<SharedSlot> slotsForLocation = map.get(location);
        if (slotsForLocation == null) {
            return null;
        }
        SharedSlot slot = slotsForLocation.remove(slotsForLocation.size() - 1);
        if (slotsForLocation.isEmpty()) {
            map.remove(location);
        }
        return slot;
    }

    private static final SharedSlot pollFromMultiMap(Map<Instance, List<SharedSlot>> map) {
        Iterator<Map.Entry<Instance, List<SharedSlot>>> iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            List<SharedSlot> slots = iter.next().getValue();
            if (slots.isEmpty()) {
                iter.remove();
                continue;
            }
            if (slots.size() == 1) {
                SharedSlot slot = slots.remove(0);
                iter.remove();
                return slot;
            }
            return slots.remove(slots.size() - 1);
        }
        return null;
    }
}

