/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators;

import org.apache.flink.api.common.functions.FlatCombineFunction;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.runtime.operators.PactDriver;
import org.apache.flink.runtime.operators.PactTaskContext;
import org.apache.flink.runtime.operators.util.TaskConfig;
import org.apache.flink.runtime.util.MutableToRegularIteratorWrapper;
import org.apache.flink.util.Collector;
import org.apache.flink.util.MutableObjectIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllGroupReduceDriver<IT, OT>
implements PactDriver<GroupReduceFunction<IT, OT>, OT> {
    private static final Logger LOG = LoggerFactory.getLogger(AllGroupReduceDriver.class);
    private PactTaskContext<GroupReduceFunction<IT, OT>, OT> taskContext;
    private MutableObjectIterator<IT> input;
    private TypeSerializer<IT> serializer;
    private DriverStrategy strategy;

    @Override
    public void setup(PactTaskContext<GroupReduceFunction<IT, OT>, OT> context) {
        this.taskContext = context;
    }

    @Override
    public int getNumberOfInputs() {
        return 1;
    }

    @Override
    public Class<GroupReduceFunction<IT, OT>> getStubType() {
        Class<GroupReduceFunction> clazz = GroupReduceFunction.class;
        return clazz;
    }

    @Override
    public int getNumberOfDriverComparators() {
        return 0;
    }

    @Override
    public void prepare() throws Exception {
        TaskConfig config = this.taskContext.getTaskConfig();
        this.strategy = config.getDriverStrategy();
        if (this.strategy == DriverStrategy.ALL_GROUP_COMBINE) {
            if (!(this.taskContext.getStub() instanceof FlatCombineFunction)) {
                throw new Exception("Using combiner on a UDF that does not implement the combiner interface " + FlatCombineFunction.class.getName());
            }
        } else if (this.strategy != DriverStrategy.ALL_GROUP_REDUCE) {
            throw new Exception("Unrecognized driver strategy for AllGroupReduce driver: " + config.getDriverStrategy().name());
        }
        this.serializer = this.taskContext.getInputSerializer(0).getSerializer();
        this.input = this.taskContext.getInput(0);
    }

    @Override
    public void run() throws Exception {
        MutableToRegularIteratorWrapper<IT> inIter;
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.taskContext.formatLogString("AllGroupReduce preprocessing done. Running Reducer code."));
        }
        if ((inIter = new MutableToRegularIteratorWrapper<IT>(this.input, this.serializer)).hasNext()) {
            if (this.strategy == DriverStrategy.ALL_GROUP_REDUCE) {
                GroupReduceFunction<IT, OT> reducer = this.taskContext.getStub();
                Collector<OT> output = this.taskContext.getOutputCollector();
                reducer.reduce(inIter, output);
            } else {
                FlatCombineFunction combiner = (FlatCombineFunction)this.taskContext.getStub();
                Collector<OT> output = this.taskContext.getOutputCollector();
                combiner.combine(inIter, output);
            }
        }
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void cancel() {
    }
}

