/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators;

import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.runtime.operators.PactDriver;
import org.apache.flink.runtime.operators.PactTaskContext;
import org.apache.flink.runtime.operators.util.TaskConfig;
import org.apache.flink.runtime.util.KeyGroupedIterator;
import org.apache.flink.runtime.util.KeyGroupedIteratorImmutable;
import org.apache.flink.util.Collector;
import org.apache.flink.util.MutableObjectIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupReduceDriver<IT, OT>
implements PactDriver<GroupReduceFunction<IT, OT>, OT> {
    private static final Logger LOG = LoggerFactory.getLogger(GroupReduceDriver.class);
    private PactTaskContext<GroupReduceFunction<IT, OT>, OT> taskContext;
    private MutableObjectIterator<IT> input;
    private TypeSerializer<IT> serializer;
    private TypeComparator<IT> comparator;
    private boolean mutableObjectMode = false;
    private volatile boolean running;

    @Override
    public void setup(PactTaskContext<GroupReduceFunction<IT, OT>, OT> context) {
        this.taskContext = context;
        this.running = true;
    }

    @Override
    public int getNumberOfInputs() {
        return 1;
    }

    @Override
    public Class<GroupReduceFunction<IT, OT>> getStubType() {
        Class<GroupReduceFunction> clazz = GroupReduceFunction.class;
        return clazz;
    }

    @Override
    public int getNumberOfDriverComparators() {
        return 1;
    }

    @Override
    public void prepare() throws Exception {
        TaskConfig config = this.taskContext.getTaskConfig();
        if (config.getDriverStrategy() != DriverStrategy.SORTED_GROUP_REDUCE) {
            throw new Exception("Unrecognized driver strategy for GroupReduce driver: " + config.getDriverStrategy().name());
        }
        this.serializer = this.taskContext.getInputSerializer(0).getSerializer();
        this.comparator = this.taskContext.getDriverComparator(0);
        this.input = this.taskContext.getInput(0);
        this.mutableObjectMode = config.getMutableObjectMode();
        if (LOG.isDebugEnabled()) {
            LOG.debug("GroupReduceDriver uses " + (this.mutableObjectMode ? "MUTABLE" : "IMMUTABLE") + " object mode.");
        }
    }

    @Override
    public void run() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.taskContext.formatLogString("GroupReducer preprocessing done. Running GroupReducer code."));
        }
        GroupReduceFunction<IT, OT> stub = this.taskContext.getStub();
        Collector<OT> output = this.taskContext.getOutputCollector();
        if (this.mutableObjectMode) {
            KeyGroupedIterator<IT> iter = new KeyGroupedIterator<IT>(this.input, this.serializer, this.comparator);
            while (this.running && iter.nextKey()) {
                stub.reduce((Iterable)iter.getValues(), output);
            }
        } else {
            KeyGroupedIteratorImmutable<IT> iter = new KeyGroupedIteratorImmutable<IT>(this.input, this.serializer, this.comparator);
            while (this.running && iter.nextKey()) {
                stub.reduce((Iterable)iter.getValues(), output);
            }
        }
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void cancel() {
        this.running = false;
    }
}

